/**
 * Copyright (c) 2014, Vincent Petry <pvince81@owncloud.com>
 * This file is licensed under the Affero General Public License version 3 or later.
 * See the COPYING-README file.
 */
OC.Settings = OC.Settings || {};
OC.Settings = _.extend(OC.Settings, {

    _cachedGroups: null,

    /**
     * Setup selection box for group selection.
     *
     * Values need to be separated by a pipe "|" character.
     * (mostly because a comma is more likely to be used
     * for groups)
     *
     * @param $elements jQuery element (hidden input) to setup select2 on
     * @param {Array} [extraOptions] extra options hash to pass to select2
     * @param {Array} [options] extra options
     * @param {Array} [options.excludeAdmins=false] flag whether to exclude admin groups
     */
    setupGroupsSelect: function($elements, extraOptions, options) {
        var self = this;
        options = options || {};
        if ($elements.length > 0) {
            // Let's load the data and THEN init our select
            $.ajax({
                url: OC.linkToOCS('cloud/groups', 2) + 'details',
                dataType: 'json',
                success: function(data) {
                    var results = [];

                    if (data.ocs.data.groups && data.ocs.data.groups.length > 0) {

                        data.ocs.data.groups.forEach(function(group) {
                            if (!options.excludeAdmins || group.id !== 'admin') {
                                results.push({ id: group.id, displayname: group.displayname });
                            }
                        })

                        // note: settings are saved through a "change" event registered
                        // on all input fields
                        $elements.select2(_.extend({
                            placeholder: t('core', 'Groups'),
                            allowClear: true,
                            multiple: true,
                            toggleSelect: true,
                            separator: '|',
                            data: { results: results, text: 'displayname' },
                            initSelection: function(element, callback) {
                                var groups = $(element).val();
                                var selection;
                                if (groups && results.length > 0) {
                                    selection = _.map((groups || []).split('|').sort(), function(groupId) {
                                        return {
                                            id: groupId,
                                            displayname: results.find(function (group) {
                                                return group.id === groupId;
                                            }).displayname
                                        };
                                    });
                                } else if (groups) {
                                    selection = _.map((groups || []).split('|').sort(), function(groupId) {
                                        return {
                                            id: groupId,
                                            displayname: groupId
                                        };
                                    });
                                }
                                callback(selection);
                            },
                            formatResult: function(element) {
                                return escapeHTML(element.displayname);
                            },
                            formatSelection: function(element) {
                                return escapeHTML(element.displayname);
                            },
                            escapeMarkup: function(m) {
                                // prevent double markup escape
                                return m;
                            }
                        }, extraOptions || {}));
                    } else {
                        OC.Notification.show(t('settings', 'Group list is empty'), { type: 'error' });
                        console.log(data);
                    }
                },
                error: function(data) {
                    OC.Notification.show(t('settings', 'Unable to retrieve the group list'), { type: 'error' });
                    console.log(data);
                }
            });
        }
    }
});
 
	var ShareURL = "";
	//绑定所有分享按钮所在A标签的鼠标移入事件，从而获取动态ID
	$(function () {
		$(".bdsharebuttonbox a").mouseover(function () {
			ShareURL = $(this).attr("data-url");
		});
                $("#sinaWeiBo").click( function(){
                    sinaWeiBo('Xfcloud先锋云盘是分布式云存储云盘，人人都能搭建的私人云端存储系统！')
                });
                
                  $("#shareToQZone").click( function(){
                    shareToQZone('Xfcloud先锋云盘是分布式云存储系统!','人人都能搭建的私人云端存储系统！')
                })
             

	});
 
	/*
	* 动态设置百度分享URL的函数,具体参数
	* cmd为分享目标id,此id指的是插件中分析按钮的ID
	*，我们自己的文章ID要通过全局变量获取
	* config为当前设置，返回值为更新后的设置。
	*/
       var ShareURL = window.location.href;
	function SetShareUrl(cmd, config) {
            console.log('----------SetShareUrl----------------')
         
	     config.bdUrl = ShareURL;		 
	     return config;
	}
	//插件的配置部分，注意要记得设置onBeforeClick事件，主要用于获取动态的文章ID
	window._bd_share_config = {
		"common": {
			onBeforeClick: SetShareUrl, "bdSnsKey": {}, "bdText": "",bdUrl : window.location.href
			, "bdMini": "2", "bdMiniList": false,  "bdStyle": "0", "bdSize": "24"
		}, "share": {}
	};
	//插件的JS加载部分
	with (document) 0[(getElementsByTagName('head')[0] || body)
			.appendChild(createElement('script'))
			.src = 'http://bdimg.share.baidu.com/static/api/js/share.js?v=89860593.js?cdnversion='
			+ ~(-new Date() / 36e5)];



	function shareToQZone(title,sum) {
        var url = "https://sns.qzone.qq.com/cgi-bin/qzshare/cgi_qzshare_onekey" +
            "?url=" + encodeURIComponent(window.location.href) +
            "&title=" + encodeURIComponent( title) +
            "&summary=" + encodeURIComponent(sum)     +
            "&desc="    + encodeURIComponent('')  +
            "&site=" + encodeURIComponent(window.location.href) +
            "&pics=" + encodeURIComponent('http://xfcloud.xfplay.com/image/share.jpg');
        window.open(url);
    }

	function sinaWeiBo(title, url, pic) {
	    var param = {
	        url: url || window.location.href,
	        type: '3',
	        count: '1', /** 是否显示分享数，1显示(可选)*/
	        appkey: '', /** 您申请的应用appkey,显示分享来源(可选)*/
	        title: title, /** '影音先锋-强大的P2P云3D播放器！'分享的文字内容(可选，默认为所在页面的title)*/
	        pic: pic || 'http://xfcloud.xfplay.com/image/share.jpg', /**分享图片的路径(可选)*/
	        ralateUid: '', /**关联用户的UID，分享微博会@该用户(可选)*/
	        rnd: new Date().valueOf()
	    }
	    var temp = [];
	    for (var p in param) {
	        temp.push(p + '=' + encodeURIComponent(param[p] || ''))
	    }
	    var targetUrl = 'https://service.weibo.com/share/share.php?' + temp.join('&');
	    window.open(targetUrl);
	}
 
 
