<!DOCTYPE html>
<html class="ng-csp" data-placeholder-focus="false" lang="<?php p($_['language']); ?>" data-locale="<?php p($_['locale']); ?>" >
	<head data-user="<?php p($_['user_uid']); ?>" data-user-displayname="<?php p($_['user_displayname']); ?>" data-requesttoken="<?php p($_['requesttoken']); ?>">
		<meta charset="utf-8">
		<title>
			<?php
				p(!empty($_['application'])?$_['application'].' - ':'');
				p($theme->getTitle());
			?>
		</title>
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
                <meta name=renderer  content=webkit>
		<meta name="referrer" content="no-referrer">
		<meta name="viewport" content="width=device-width, initial-scale=1.0, minimum-scale=1.0">
		<meta name="apple-itunes-app" content="app-id=<?php p($theme->getiTunesAppId()); ?>">
		<meta name="apple-mobile-web-app-capable" content="yes">
		<meta name="apple-mobile-web-app-status-bar-style" content="black">
		<meta name="apple-mobile-web-app-title" content="<?php p((!empty($_['application']) && $_['appid']!='files')? $_['application']:$theme->getTitle()); ?>">
		<meta name="mobile-web-app-capable" content="yes">
		<meta name="theme-color" content="<?php p($theme->getColorPrimary()); ?>">
		<link rel="icon" href="<?php print_unescaped(image_path($_['appid'], 'favicon.ico')); /* IE11+ supports png */ ?>">
		<link rel="apple-touch-icon-precomposed" href="<?php print_unescaped(image_path($_['appid'], 'favicon-touch.png')); ?>">
		<link rel="mask-icon" sizes="any" href="<?php print_unescaped(image_path($_['appid'], 'favicon-mask.svg')); ?>" color="<?php p($theme->getColorPrimary()); ?>">
		<link rel="manifest" href="<?php print_unescaped(image_path($_['appid'], 'manifest.json')); ?>">
		<?php emit_css_loading_tags($_); ?>
		<?php emit_script_loading_tags($_); ?>
		<?php print_unescaped($_['headers']); ?>
	</head>
	<body id="<?php p($_['bodyid']);?>">
	<?php include 'layout.noscript.warning.php'; ?>

		<a href="#app-content" class="button primary skip-navigation skip-content"><?php p($l->t('Skip to main content')); ?></a>
		<a href="#app-navigation" class="button primary skip-navigation"><?php p($l->t('Skip to navigation of app')); ?></a>

		<div id="notification-container">
			<div id="notification"></div>
		</div>
                <header role="banner" id="header">
			<div class="header-left">
				<a href="<?php print_unescaped(link_to('', 'index.php')); ?>"
					id="nextcloud">
                                   <!-- 
                                   <span style="posisiton:absolute; left: 100px; top: 10px;"><?php p($theme->getTitle());?></span>
                                   -->
					<div class="logo logo-icon">
						<h1 class="hidden-visually">
							<?php p($theme->getName()); ?> <?php p(!empty($_['application'])?$_['application']: $l->t('Apps')); ?>
						</h1>
					</div>
				</a>
                    
				<ul id="topMenu" <?php if ($_['themingInvertMenu']) { ?>class="inverted"<?php } ?> class="layui-nav layui-layout-left">
					<li class="layui-nav-item" data-hash="files"><a  href="<?php print_unescaped(link_to('apps', 'files')); ?>#view=files"><?php p($l->t('My cloud disk')); ?></a></li>
					<li class="layui-nav-item" data-hash="complete"><a href="<?php print_unescaped(link_to('apps', 'files')); ?>#view=complete"><?php p($l->t('Transmission list')); ?></a></li>
					<li class="layui-nav-item" data-hash="shareoverview"><a  href="<?php print_unescaped(link_to('apps', 'files')); ?>#view=shareoverview"><?php p($l->t('Friend sharing')); ?></a></li>
					
					<li class="layui-nav-item siteNameli" role="button" 
					aria-label="<?php p($theme->getTitle());?>"	aria-haspopup="true" 
					aria-controls="navAsitediv" aria-expanded="false">
						<a > <?php p($theme->getTitle());?><span class="layui-nav-more" style="border-color:#8AD2FF transparent transparent;"></span></a>
					
					<dl id="navAsitediv" class="layui-nav-child layui-anim layui-anim-upbit"> 
							<div class="items"></div>
							<dd class="dd1">
							<a><span  class="button">添加收藏 <i>+</i></span></a>
						</dd>
						<dd class="dd2" style="display:none; padding: 5px;">
							<form name="siteNameliform" class="siteNameliform">
								<input id="siteNameli-input-folder" type="text" value="" name="siteNameliformInput" autocomplete="off" autocapitalize="off">
								<input type="submit" value=" " class="icon-confirm">
							</form>
						</dd>
						</dl>
					</li>
				</ul>
						
				<nav role="navigation">
					<div id="navigation" style="display:none; "  aria-label="<?php p($theme->getTitle());?>">
						<div id="apps">
                                                    <div id="searchbox"><form class="searchbox"></form></div>                                                    
							<!--<ul>	<?php foreach($_['navigation'] as $entry): ?>
									<li data-id="<?php p($entry['id']); ?>">
									<a href="<?php print_unescaped($entry['href']); ?>"
										<?php if( $entry['active'] ): ?> class="active"<?php endif; ?>
										aria-label="<?php p($entry['name']); ?>">
										<svg width="16" height="16" viewBox="0 0 16 16" alt="">
											<defs><filter id="invertMenuMore-<?php p($entry['id']); ?>"><feColorMatrix in="SourceGraphic" type="matrix" values="-1 0 0 0 1 0 -1 0 0 1 0 0 -1 0 1 0 0 0 1 0"></feColorMatrix></filter></defs>
											<image x="0" y="0" width="16" height="16" preserveAspectRatio="xMinYMin meet" filter="url(#invertMenuMore-<?php p($entry['id']); ?>)" xlink:href="<?php print_unescaped($entry['icon'] . '?v=' . $_['versionHash']); ?>"  class="app-icon"></image>
										</svg>
										<div class="icon-loading-small" style="display:none;"></div>
										<span><?php p($entry['name']); ?></span>
									</a>
									</li></ul>
								<?php endforeach; ?>
                                                            -->
       
							
						</div>
					</div>
				</nav>

			</div>

			<div  class="header-right layui-nav">
                            
                            	<div id="settings">
					<div id="expand" tabindex="0" role="button" class="menutoggle"
						aria-label="<?php p($l->t('Settings'));?>"
						aria-haspopup="true" aria-controls="expanddiv" aria-expanded="false">
						<div class="avatardiv<?php if ($_['userAvatarSet']) { print_unescaped(' avatardiv-shown'); } else { print_unescaped('" style="display: none'); } ?>">
							<?php if ($_['userAvatarSet']): ?>
								<img alt="" width="32" height="32"
								src="<?php p(\OC::$server->getURLGenerator()->linkToRoute('core.avatar.getAvatar', ['userId' => $_['user_uid'], 'size' => 32, 'v' => $_['userAvatarVersion']]));?>"
								srcset="<?php p(\OC::$server->getURLGenerator()->linkToRoute('core.avatar.getAvatar', ['userId' => $_['user_uid'], 'size' => 64, 'v' => $_['userAvatarVersion']]));?> 2x, <?php p(\OC::$server->getURLGenerator()->linkToRoute('core.avatar.getAvatar', ['userId' => $_['user_uid'], 'size' => 128, 'v' => $_['userAvatarVersion']]));?> 4x"
								>
							<?php endif; ?>
						</div>
                                            <span>&nbsp;</span>
                                            <div id="expandDisplayName" style="border:0px; margin-top:0px;" class="icon-settings-white"> </div>
					</div>
					<nav id="expanddiv" style="display:none;"
						aria-label="<?php p($l->t('Settings menu'));?>">
					<ul>
					<?php foreach($_['settingsnavigation'] as $entry):?>
                                            <?php if( in_array($entry['id'], ['settings' ,'logout','core_apps','core_users']) ){ ?>
						<li data-id="<?php p($entry['id']); ?>">
							<a href="<?php print_unescaped($entry['href']); ?>"
								<?php if( $entry["active"] ): ?> class="active"<?php endif; ?>>
								<img alt="" src="<?php print_unescaped($entry['icon'] . '?v=' . $_['versionHash']); ?>">
								<?php p($entry['name']) ?>
							</a>
						</li>
                                            <?php }?>
					<?php endforeach; ?>
					</ul>
					</nav>
				</div>
                            <div id="header-notice"></div>
                            <li class="layui-nav-item">
                                <div class="dialogBtn">            
                                    <a><i class="ton ton-minimize"></i></a>
                                    <a><i class="ton ton-maximize"></i></a>
                                    <a href="<?php print_unescaped($_['settingsnavigation']['logout']['href']); ?>" title="<?php p($_['settingsnavigation']['logout']['name']) ?>"><i class="ton ton-close"></i></a>
                                </div>
                            </li> 
			<!--头部end--> 
			</div>
		</div></header>
 
                <div id="sudo-login-background" class="hidden"></div>
		<form id="sudo-login-form" class="hidden">
			<label>
				<?php p($l->t('This action requires you to confirm your password')); ?><br/>
				<input type="password" class="question" autocomplete="new-password" name="question" value=" <?php /* Hack against browsers ignoring autocomplete="off" */ ?>"
				placeholder="<?php p($l->t('Confirm your password')); ?>" />
			</label>
			<input class="confirm" value="<?php p($l->t('Confirm')); ?>" type="submit">
		</form>
                <div id="content" class="app-<?php p($_['appid']) ?>" role="main">
			<?php print_unescaped($_['content']); ?>
		</div>                
	</body>
</html>
