<?php 
 
/**
 * @var array $_
 * @var \OCP\IL10N $l
 * @var \OCP\Defaults $theme
 */

?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title><?php p($theme->getTitle()); ?></title>
    <meta name="viewport" content="width=device-width, user-scalable=no"> 
  <?php emit_css_loading_tags($_); ?>
  <?php emit_script_loading_tags($_); ?>
 
    <style>
        html,body {
    background-color: #fff;
    width: 100%;
}
body { font-family: 'Microsoft Yahei','微软雅黑',simsun,Arial;}
html,body,div,p,h1,a,img,span {
    padding: 0;
    margin: 0 auto;
}
img {
    border: 0 none;
    height: auto;
    display: block;
}
a {text-decoration: none}
p {width: 100%;}

.header {
    height:1.28rem;
    width: 100%;
    position: fixed;
    top: 0;
    left: 0;
    z-index: 10;
    background-color: #fff;
}
.header img {
    width: 2.79rem;
    margin-left: .36rem;
    margin-top: .11rem;
}
.header a {
    display: block;
    width: 1.62rem;
    height: .62rem;
    border-radius: 0.06rem;
    background-color: #248aff;
    line-height: .62rem;
    color: #fff;
    font-size: .26rem;
    position: absolute;
    top: .31rem;
    right: .33rem;
    text-align: center;
}

.head {
    width: 100%;
    height: 12rem;
    margin-top: 1.28rem;
    position: relative;
    text-align: center;
    color: #fff;
    background-image: url('/core/css/images/app_guide_bg1.png');
    background-repeat: no-repeat;
    background-position: center top;
    background-size: cover;
}

.head .hd-bg {
    position: absolute;
    left: 0;
    top: 0;
    width: 100%;
}

.head .head-title {
    position: relative;
    top: 0.31rem;
    width: 100%;
    margin: 0 auto;
}

.head p {
    width: 100%;
    position: absolute;
    left: 0;
}
.head .title1 {
    font-size: .56rem;
    font-weight: bold;
    top: 0.72rem;
}
.head .title2 {
    font-size: .28rem;
    top: 1.89rem;
}
.dl_btn {
    display: block;
    width: 5.02rem;
    height: 1.04rem;
    line-height: 1.04rem;
    color: #fff;
    border-radius: 6px;
    background-color: #0362C0;
    box-shadow: 0 8px 16px 0 rgba(24, 135, 255, 0.38);
    font-size: .32rem;
    border-radius: 0.06rem;
    margin: 0 auto;
    position: relative;
}
.head a {
    top: -1rem;
}
.head .arrow {
    width: .40rem;
    position: relative;
    top: -0.8rem;
    margin: 0 auto;
}

.page {
    background-color: #fff;
    height: 12rem;
    width: 100%;
    text-align: center;
}
.page.blue {background-color: #f5f8fc;}
.page h1 {
    font-size: .48rem;
    font-weight: bold;
    color: #333333;
    width: 100%;
    padding-top: .9rem;
}
.page h1 span{
    color: #248aff;
}
.page .des {
    margin-top: .22rem;
}
.page p {
    color: #999999;
    font-size: .28rem;
    line-height: .49rem;
    text-align: left;
    width: 5.8rem;
}

.page p span {
    color: #4a90e2;
}

.page p.remark {
    color: #82b1f2;
    font-size: .22rem;
}
.page img {
    width: 100%;
}
.page1-img {
    margin-top: 0.69rem;
}
.page2-img {
    margin-top: 0.59rem;
}
.page3-img {
    margin-top: 0.69rem;
}
.page4-img {
    margin-top: 0.69rem;
}
.page5-img {
    margin-top: 0.67rem;
}
.page .more {
    display: block;
    color: #398dee;
    font-size: .28rem;
    margin-top: .44rem;
}

.ft-dl {
    height: 4.8rem;
    width: 100%;
    position: relative;
    text-align: center;
}
.ft-dl img {
    width: 100%;
    position: absolute;
    top: 0;
    left: 0;
}
.ft-dl p {
    color: #333333;
    font-size: .6rem;
    position: absolute;
    top: 1.2rem;
    left: 0;
}
.ft-dl a {
    bottom: -2.86rem;
}

.footer {
    width: 100%;
    height: 2.3rem;
    background-color: #fefefe;
    text-align: center;
}
.footer img {
    width: 2.66rem;
    padding-top: .52rem;
}
.footer .copyright {
    color: #a4a7ad;
    font-size: .28rem;
    margin-top: .36rem;
}
    </style>
</head>
<body>
 
    <div class="header">
        <img src="/core/css/images/logo_top.png" />
        <a class="header_dl dl" href="<?php p($_['otherUrl']);?>" >立即打开</a>
    </div>
    <div class="head">
        <img class="head-title" src="/core/css/images/app_guide1.png" /> 
        <p class="title1"> &nbsp; &nbsp; &nbsp; &nbsp;</p>
        <p class="title2">免费超大空间，开启你的高效视频观看之旅</p>
        <a class="dl_btn top dl" href="<?php p($_['siteurl']);?>">立即下载</a>
        <img class="arrow" src="/core/css/images/arrow.svg"/>
    </div>
   <!-- <div class="page">
        <h1><span>文档管理</span>，高效记录</h1>
        <div class="des">
            <p>文字/图片/语音/手写/OCR/Markdown等多种形式，随时随地记录你的精彩。全面兼容office、PDF等办公常用文档，无需下载即可查看编辑。</p>
        </div>
        <img class="page1-img" src="http://note.youdao.com/WAP/intro/images/page1.png" />
    </div>
    <div class="page blue">
        <h1><span>收藏</span>，精彩不错过</h1>
        <div class="des">
            <p>支持微信、微博、链接收藏和网页剪报等多种形式，优秀内容一键保存永不丢失，搭建属于你的知识体系。</p>
        </div>
        <img class="page2-img" src="http://note.youdao.com/WAP/intro/images/page2.png" />
    </div>
    <div class="page">
        <h1><span>OCR扫描</span>，快捷准确</h1>
        <div class="des">
            <p>满足文档、手写、名片等多场景需求，特别支持PDF转Word功能，无需繁琐操作，一键轻松搞定。</p>
        </div>
        <img class="page3-img" src="http://note.youdao.com/WAP/intro/images/page3.png" />
    </div>
    <div class="page blue">
        <h1><span>多端同步</span>，随时查看</h1>
        <div class="des">
            <p>PC/iPhone/Android/web/iPad/Mac/Wap……随时备份，云端同步，重要资料还可加密保存。无惧断网/断电困扰，任何情况下都能轻松查阅。</p>
        </div>
        <img class="page4-img" src="http://note.youdao.com/WAP/intro/images/page4.png" />
    </div>
    <div class="page">
        <h1><span>轻松分享</span>，协同处理</h1>
        <div class="des">
            <p>文档一键分享微信、QQ、微博、邮件等平台。团队协作修改，实时处理更高效。</p>
        </div>
        <img class="page5-img" src="http://note.youdao.com/WAP/intro/images/page5.png" />
    </div>
    <div class="ft-dl">
        <img src="http://note.youdao.com/WAP/intro/images/bt_bg.png" />
        <p>现在开始使用吧</p>
        <a class="dl_btn bottom dl" href="http://note.youdao.com/device.html">立即下载</a>
    </div>-->
    <div class="footer">
        <img src="/core/css/images/logo_top.png" />
        <p class="copyright"> <?php p($l->t('版权所有')); ?> &copy;copy 2005-<?php p(date('Y'));?> <?php p($l->t('零与壹软件.')); ?></p>
    </div>
   
</body>
</html>

 
