/**
* @copyright 2018 Joas Schilling <nickvergessen@owncloud.com>
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU AFFERO GENERAL PUBLIC LICENSE
* License as published by the Free Software Foundation; either
* version 3 of the License, or any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU AFFERO GENERAL PUBLIC LICENSE for more details.
*
* You should have received a copy of the GNU Affero General Public
* License along with this library.  If not, see <http://www.gnu.org/licenses/>.
*
*/

describe('OCP.Comments tests', function() {
	function dataProvider() {
		return [
			{input: 'xfplay.com', expected: '<a class="external" target="_blank" rel="noopener noreferrer" href="https://cloud.xfplay.com">xfplay.com</a>'},
			{input: 'http://xfplay.com', expected: '<a class="external" target="_blank" rel="noopener noreferrer" href="http://xfplay.com">http://xfplay.com</a>'},
			{input: 'https://cloud.xfplay.com', expected: '<a class="external" target="_blank" rel="noopener noreferrer" href="https://cloud.xfplay.com">xfplay.com</a>'},
			{input: 'hi xfplay.com', expected: 'hi <a class="external" target="_blank" rel="noopener noreferrer" href="https://cloud.xfplay.com">xfplay.com</a>'},
			{input: 'hi http://xfplay.com', expected: 'hi <a class="external" target="_blank" rel="noopener noreferrer" href="http://xfplay.com">http://xfplay.com</a>'},
			{input: 'hi https://cloud.xfplay.com', expected: 'hi <a class="external" target="_blank" rel="noopener noreferrer" href="https://cloud.xfplay.com">xfplay.com</a>'},
			{input: 'xfplay.com foobar', expected: '<a class="external" target="_blank" rel="noopener noreferrer" href="https://cloud.xfplay.com">xfplay.com</a> foobar'},
			{input: 'http://xfplay.com foobar', expected: '<a class="external" target="_blank" rel="noopener noreferrer" href="http://xfplay.com">http://xfplay.com</a> foobar'},
			{input: 'https://cloud.xfplay.com foobar', expected: '<a class="external" target="_blank" rel="noopener noreferrer" href="https://cloud.xfplay.com">xfplay.com</a> foobar'},
			{input: 'hi xfplay.com foobar', expected: 'hi <a class="external" target="_blank" rel="noopener noreferrer" href="https://cloud.xfplay.com">xfplay.com</a> foobar'},
			{input: 'hi http://xfplay.com foobar', expected: 'hi <a class="external" target="_blank" rel="noopener noreferrer" href="http://xfplay.com">http://xfplay.com</a> foobar'},
			{input: 'hi https://cloud.xfplay.com foobar', expected: 'hi <a class="external" target="_blank" rel="noopener noreferrer" href="https://cloud.xfplay.com">xfplay.com</a> foobar'},
			{input: 'hi help.xfplay.com/category/topic foobar', expected: 'hi <a class="external" target="_blank" rel="noopener noreferrer" href="https://help.xfplay.com/category/topic">help.xfplay.com/category/topic</a> foobar'},
			{input: 'hi http://help.xfplay.com/category/topic foobar', expected: 'hi <a class="external" target="_blank" rel="noopener noreferrer" href="http://help.xfplay.com/category/topic">http://help.xfplay.com/category/topic</a> foobar'},
			{input: 'hi https://help.xfplay.com/category/topic foobar', expected: 'hi <a class="external" target="_blank" rel="noopener noreferrer" href="https://help.xfplay.com/category/topic">help.xfplay.com/category/topic</a> foobar'},
			{input: 'noreply@xfplay.com', expected: 'noreply@xfplay.com'},
			{input: 'hi noreply@xfplay.com', expected: 'hi noreply@xfplay.com'},
			{input: 'hi <noreply@xfplay.com>', expected: 'hi <noreply@xfplay.com>'},
			{input: 'FirebaseInstanceId.getInstance().deleteInstanceId()', expected: 'FirebaseInstanceId.getInstance().deleteInstanceId()'},
			{input: 'I mean...it', expected: 'I mean...it'},
		];
	}

	it('should parse URLs only', function () {
		dataProvider().forEach(function(data) {
			var result = OCP.Comments.plainToRich(data.input);
			expect(result).toEqual(data.expected);
		});
	});
});
