/**
 * Copyright (c) 2015
 *  Vincent Petry <pvince81@owncloud.com>
 *  Jan-Christoph Borchardt, http://jancborchardt.net
 * This file is licensed under the Affero General Public License version 3 or later.
 * See the COPYING-README file.
 */

/**
 * @namespace
 * @memberOf OC
 * @private
 */
OC.Login = _.extend(OC.Login || {}, {
	onLogin: function () {
            /*
             * 这个方法被用在两个地方 
             * /login 和/xflogin 两个表单提交都依赖此方法；
             */
		// Only if password reset form is not active
		if($('form[name=login][action]').length === 0) {
			$('#submit-wrapper .submit-icon')
				.removeClass('icon-confirm-white')
				.addClass(OCA.Theming && OCA.Theming.inverted
					? 'icon-loading-small'
					: 'icon-loading-small-dark');
			$('#submit')
				.attr('value', t('core', 'Logging in …'));
			$('.login-additional').fadeOut();
                        //增加是否手机号
                        var mobile = $("#user").val();
                        var xfnickname = $("#xfnickname").val();/*手机号提交第一次需要转换为先锋昵称*/
                        if(!xfnickname && mobile && OC.Login.isPoneAvailable(mobile)){
                           
                            var url =  '/xflogin/usermobile'
                            +'?mobile='+  mobile 
                            +'&password='+ $("#password").val();
                            $.get(url, function(res){
                                 var info = res;
                                 if(info === null || info =='null'){
                                    $("#xfnickname").val( mobile );
                                    $('#submit').trigger('click');
                                    return;
                                 }
                                 if(info.result==1){
                                    $("#xfnickname").val( info.user_name);
                                    $('#submit').trigger('click');
                                }else{
                                    $("#xfnickname").val( mobile );
                                    $('#submit').trigger('click');
                                }
                            })
                        }else{
                            return true;
                        }
			return false;
		}
		return false;
	},
        isPoneAvailable(str) {
            var myreg=/^[1][2,3,4,5,6,7,8,9][0-9]{9}$/;
            if (!myreg.test(str)) {
                return false;
            } else {
                return true;
            }
        },
	rememberLogin: function(){
		if($(this).is(":checked")){
			if($("#user").val() && $("#password").val()) {
				$('#submit').trigger('click');
			}
		}
	} 
});
/*下面是滑块验证码*/

(function (window) {
  const l = 42, // 滑块边长
    r = 10, // 滑块半径
    w = 360, // canvas宽度
    h = 155, // canvas高度
    PI = Math.PI
  const L = l + r * 2 // 滑块实际边长

  function getRandomNumberByRange(start, end) {
    return Math.round(Math.random() * (end - start) + start)
  }

  function createCanvas(width, height) {
    const canvas = createElement('canvas')
    canvas.width = width
    canvas.height = height
    return canvas
  }

  function createImg(onload) {
    const img = createElement('img')
    img.crossOrigin = "Anonymous"
    img.onload = onload
    img.onerror = () => {
      img.src = getRandomImg()
    }
    img.src = getRandomImg()
    return img
  }
  
  function createElement(tagName) {
    return document.createElement(tagName)
  }

  function addClass(tag, className) {
    tag.classList.add(className)
  }

  function removeClass(tag, className) {
    tag.classList.remove(className)
  }
  
  function getRandomImg() {
    return '/core/css/xficon/slide' + getRandomNumberByRange(0, 10)+ ".jpg"
  }

  function draw(ctx, operation, x, y) {
    ctx.beginPath()
    ctx.moveTo(x, y)
    ctx.lineTo(x + l / 2, y)
    ctx.arc(x + l / 2, y - r + 2, r, 0, 2 * PI)
    ctx.lineTo(x + l / 2, y)
    ctx.lineTo(x + l, y)
    ctx.lineTo(x + l, y + l / 2)
    ctx.arc(x + l + r - 2, y + l / 2, r, 0, 2 * PI)
    ctx.lineTo(x + l, y + l / 2)
    ctx.lineTo(x + l, y + l)
    ctx.lineTo(x, y + l)
    ctx.lineTo(x, y)
    ctx.fillStyle = '#fff'
    ctx[operation]()
    ctx.beginPath()
    ctx.arc(x, y + l / 2, r, 1.5 * PI, 0.5 * PI)
    ctx.globalCompositeOperation = "xor"
    ctx.fill()
  }

  function sum(x, y) {
    return x + y
  }

  function square(x) {
    return x * x
  }

  class jigsaw {
    constructor(el, success, fail) {
      this.el = el
      this.success = success
      this.fail = fail
    }

    init() {
      this.initDOM()
      this.initImg()
      this.draw()
      this.bindEvents()
    }

    initDOM() {
      const canvas = createCanvas(w, h) // 画布
      const block = canvas.cloneNode(true) // 滑块
      const sliderContainer = createElement('div')
      const refreshIcon = createElement('div')
      const sliderMask = createElement('div')
      const slider = createElement('div')
      const sliderIcon = createElement('span')
      const text = createElement('span')

      block.className = 'block'
      sliderContainer.className = 'sliderContainer'
      refreshIcon.className = 'refreshIcon'
      sliderMask.className = 'sliderMask'
      slider.className = 'slider'
      sliderIcon.className = 'sliderIcon'
      text.innerHTML = '请按住滑块 拖至右边'
      text.className = 'sliderText'
   
      const el = this.el
      el.appendChild(canvas)
      el.appendChild(refreshIcon)
      el.appendChild(block)
      slider.appendChild(sliderIcon)
      sliderMask.appendChild(slider)
      sliderContainer.appendChild(sliderMask)
      sliderContainer.appendChild(text)
      document.getElementById("slideCodeBar").appendChild(sliderContainer)

      Object.assign(this, {
        canvas,
        block,
        sliderContainer,
        refreshIcon,
        slider,
        sliderMask,
        sliderIcon,
        text,
        canvasCtx: canvas.getContext('2d'),
        blockCtx: block.getContext('2d')
      })
    }

    initImg() {
      const img = createImg(() => {
        this.canvasCtx.drawImage(img, 0, 0, w, h)
        this.blockCtx.drawImage(img, 0, 0, w, h)
        const y = this.y - r * 2 + 2
        const ImageData = this.blockCtx.getImageData(this.x, y, L, L)
        this.block.width = L
        this.blockCtx.putImageData(ImageData, 0, y)
      })
      this.img = img
    }

    draw() {
      // 随机创建滑块的位置
      this.x = getRandomNumberByRange(L + 10, w - (L + 10))
      this.y = getRandomNumberByRange(10 + r * 2, h - (L + 10))
      draw(this.canvasCtx, 'fill', this.x, this.y)
      draw(this.blockCtx, 'clip', this.x, this.y)
    }

    clean() {
      this.canvasCtx.clearRect(0, 0, w, h)
      this.blockCtx.clearRect(0, 0, w, h)
      this.block.width = w
    }

    bindEvents() {
      this.el.onselectstart = () => false
      this.refreshIcon.onclick = () => {
        this.reset()
      }
   

      let originX, originY, trail = [], isMouseDown = false;
  
      let self = this;
      var mousedown = function(e){
           if(e.targetTouches && e.targetTouches.length==1){ 
               var te = e.targetTouches[0];
               e.x = te.clientX;
               e.y = te.clientY;
           }  
         originX = e.x, originY = e.y
         isMouseDown = true;
         document.getElementById('slideCodeBox').style.display = "block"; 
      }
      self.slider.addEventListener('mousedown',mousedown  );
      self.slider.addEventListener('touchstart',mousedown  );
      /**/
      var mousemove = function(e){
        
           if(e.targetTouches && e.targetTouches.length==1){ 
               var te = e.targetTouches[0];
               e.x = te.clientX;
               e.y = te.clientY;
           }
         
       
            if (!isMouseDown) return false
            const moveX = e.x - originX
            const moveY = e.y - originY
            if (moveX < 0 || moveX + 38 >= w) return false
            self.slider.style.left = moveX + 'px'
            var blockLeft = (w - 40 - 20) / (w - 40) * moveX
            self.block.style.left = blockLeft + 'px'
    
            addClass(self.sliderContainer, 'sliderContainer_active')
            self.sliderMask.style.width = moveX + 'px'
            trail.push(moveY)
      }
      document.addEventListener('mousemove', mousemove );
      document.addEventListener('touchmove', mousemove );
      /**/
      var mouseup  = function(e){
        if (!isMouseDown) return false
        isMouseDown = false
        if (e.x == originX) return false
        removeClass(self.sliderContainer, 'sliderContainer_active')
        self.trail = trail
        const {spliced, TuringTest} = self.verify()
        if (spliced) {
          if (TuringTest) {
            addClass(self.sliderContainer, 'sliderContainer_success')
            self.success && self.success()
          } else {
            addClass(self.sliderContainer, 'sliderContainer_fail')
            self.text.innerHTML = '再试一次'
            self.reset()
          }
        } else {
          addClass(self.sliderContainer, 'sliderContainer_fail')
          self.fail && self.fail()
          setTimeout(() => {
            self.reset()
          }, 1000)
        }
      }
      document.addEventListener('mouseup', mouseup );
      document.addEventListener('touchend', mouseup ); 
    }

    verify() {
      const arr = this.trail // 拖动时y轴的移动距离
      const average = arr.reduce(sum) / arr.length // 平均值
      const deviations = arr.map(x => x - average) // 偏差数组
      const stddev = Math.sqrt(deviations.map(square).reduce(sum) / arr.length) // 标准差
      const left = parseInt(this.block.style.left)
      return {
        spliced: Math.abs(left - this.x) < 10,
        TuringTest: average !== stddev, // 只是简单的验证拖动轨迹，相等时一般为0，表示可能非人为操作
      }
    }

    reset() {
      this.sliderContainer.className = 'sliderContainer'
      this.slider.style.left = 0
      this.block.style.left = 0
      this.sliderMask.style.width = 0
      this.clean()
      this.img.src = getRandomImg()
      this.draw()
    }

  }

  window.jigsaw = {
    init: function (element, success, fail) {
      new jigsaw(element, success, fail).init()
    }
  }
}(window))

/*这个是扫码登陆的*/
OC.Erweima = _.extend(OC.Erweima || {}, {
    /**
             * 这个是 获取二维码接口
             */
            renderQrcode( ){
                
                if(! this.qrcode_expire ){
                    this.qrcode_expire = 180;
                    this.qrcode_data = {};
                    this.refresh_btn = $('.refresh-qrcode' );
                    this.refresh_btn.bind('click', this.refreshQrcode.bind(this));
                    
                    $(".erweimab") .addClass('hidden');
                    $(".erweima-show").removeClass('hidden');
                    var self = this;        
                    $.get( '/erweima?enews=getLoginQrCode' , 
                         (ret)=>{ 
                                if(!ret){  return false;}
                                self.qrcode_expire =   ret.data.expire;
                                self.qrcode_data = ret.data ;  
                                if(! this.canvas_el ){
                                     this.canvas_el = $('canvas');
                                } else{
                                      this.canvas_el = $('.qrcode-img') || $('canvas');
                                }
                                var width = this.canvas_el.attr("width");
                                var height = this.canvas_el.attr("height");
                                   
                                if ( ret.error.errorCode ==='0') {
                                    this.canvas_el.parent().html (  '<img class="qrcode-img" src="data:image/jpeg;base64,'+ret.data.qrcode+'" width="'
                                            +width+'" height="'+height+'"/>' );
                                    
                                }
                               $(".erweimab") .addClass('hidden');
                               $(".erweima-show").removeClass('hidden');
                                /*倒计时*/
                               // console.log(this.qrcode_data);
                                //查询扫码状态
                                self.timers_status = setInterval(()=>{
                                         self.checkQrcodeStatus()  
                                },3000);
                                //更新倒计时
                                
                                self.timers_expire =   setInterval(()=>{
                                    self.qrcode_expire = self.qrcode_expire -1;
                                    if(self.qrcode_expire >0){
                                         self.refresh_btn.html('倒计时 '+ this.qrcode_expire + ' 秒') ;
                                    }else{
                                        clearInterval(self.timers_expire);
                                        self.refresh_btn.html('刷新二维码') ;
                                        delete self.qrcode_expire ;                                        
                                        return;
                                    }
                                }, 1000);
                                
                            } );
                } 
               
            },
         checkQrcodeStatus(){ 
                var self = this;
                if(!_.isNull( this.qrcode_data)){
                   $.get(  '/erweima?enews=checkCodeStatus&uid='+ this.qrcode_data.uuid,  
                      (ret)=>{  
                          /**/
                          if(ret.data.retCode ==='104'){                       
                              $(".erweimab") .addClass('hidden') ;
                              $(".erweima-success").removeClass('hidden');
                              clearInterval(self.timers_status);                                                           
                              //console.log('登录成功===');
                              /**
                               * data:
                                headImage: "iVBORw0KGgoAAAANSUhEUgAAAHwAAAB9CAYAAABgQgcbAAAgAE"
                                nickName: "清明上河"
                                retCode: "104"
                                token: "205716e01a8e457ab7d9c1c8f20b7fe0"
                                uid: "effabfd13d54137713a082194ba2ff55"
                                user: "kunbei11"
                               */
                              console.log(ret);
                              $.ajax({url:  '/erweima', type: 'POST', 
                                  dataType: "JSON",
                                  data : {headImage: ret.data.headImage, nickName: ret.data.nickName,uid : ret.data.uid},
                                  success: function(ret){
                                      //console.log(ret);
                                      window.location.href = ret.data;
                                  }
                                  
                              })
                              return ; //扫码，点击登陆
                          }else if(ret.data.retCode ==='101'){
                             
                              $(".erweimab") .addClass('hidden') ;
                              $(".erweima-refresh").removeClass('hidden');
                             
                              delete self.qrcode_expire  ; 
                              clearInterval(self.timers_expire);
                              clearInterval(self.timers_status);  
                              self.refresh_btn .html('刷新二维码') ;
                              return ; //码过期，刷新
                          }else if(ret.data.retCode ==='102'){
                               $(".erweimab") .addClass('hidden') ;
                               $(".erweima-show").removeClass('hidden');
                              return true; //未扫码
                          }else if(ret.data.retCode ==='103'){
                               $(".erweimab") .addClass('hidden') ;                               
                               $(".erweima-confirm").removeClass('hidden');
                               return true; //已扫码未点击登陆
                          }else{
                              clearInterval(self.timers_expire);
                              clearInterval(self.timers_status);  
                              return true;
                          }
                         
                   }) ;
                }
            },
             //清零定时器
            clearTimers(){
                if( this.timers_status ){
                     clearInterval(this.timers_status);  
                }
                if( this.timers_expire ){
                     clearInterval(this.timers_expire);  
                }
                 delete this.qrcode_expire;
                 
            },
            /**
             *  点击刷新二维码
             */
            refreshQrcode(ev){
                 if (ev && ev.preventDefault) { ev.preventDefault(); }
                                
                 if( this.qrcode_expire ){
                    /* this.scanQrcode(); 这个地方要 删除，由手机app扫码实现*/
                    /*this.checkQrcodeStatus();*/
                    return;
                 }
                 this.clearTimers();
                 this.renderQrcode();
            },           
})

$(document).ready(function() {
    if(document.getElementById('captcha')){ 
        jigsaw.init(document.getElementById('captcha'), function () {
            $('#xfnickname').val($('input[name="requesttoken"]').val());
            $('#slideCodeBox').hide();
        }, function(){
            $('#xfnickname').val("");
        })
    }
	$('form[name=login]').submit(OC.Login.onLogin);

	$('#remember_login').click(OC.Login.rememberLogin);
        
       $(".labelagree").click( function(){
             //event.preventDefault();
            if($('input[name=agree]').is(':checked')){
                $('input[name=agree]').attr('checked', false);
            }else{
                $('input[name=agree]').attr('checked', true);
            }
        })

        /* 用户协议 和 保密协议*/
        var regDilaog = $.extend(OCdialogs, {
           showXieyi: function(){
              var self = this;
              var html = $("#xieyiTemp").text();
              
              self.$tmp = $(html).octemplate({});
              $('body').append(self.$tmp); 
              self.$tmp.ocdialog({
				closeOnEscape: true,
				// max-width of 600
				width: 580,
				height: 520,
				modal: true,
				buttons: [],
                                title: '用户协议',
				style: {
					buttons: 'aside',
				},
				close: function() {
					try {
						$(this).ocdialog('destroy').remove();
                                                 $('input[name=agree]').attr('checked', true);
					} catch(e) {}
					 
				}
			}); 
           },
           showYinsi: function(){
                var self = this;
              var html = $("#yinsiTemp").text();              
              self.$tmp = $(html).octemplate({});
              $('body').append(self.$tmp); 
              self.$tmp.ocdialog({
				closeOnEscape: true,
				// max-width of 600
				width: 580,
				height: 520,
				modal: true,
				buttons: [],
                                title: '隐私政策',
				style: {
					buttons: 'aside',
				},
				close: function() {
					try {
						$(this).ocdialog('destroy').remove();
                                                 $('input[name=agree]').attr('checked', true);
					} catch(e) {}
					 
				}
			}); 
           }
        });
       $("#clickUserXieyi").click(function(){
            event.preventDefault();
             regDilaog.showXieyi()
             
       })  ;
       $('#clickUserBaomi').click(function(){
            event.preventDefault();
             regDilaog.showYinsi() 
       })
        /*先锋号注册*/
        $("form[name=xfregister]").submit(function(){
            //第二次触发提交按钮
             if($("form[name=xfregister]").data('checked')==1){
                 return true;
             }
            if(! $('input[name=agree]').is(':checked')) {
                $('#agree').parents(".showlink").find(".errorMsg").remove();
                $('#agree').parents(".showlink").append("<span class='errorMsg'>请同意条款</span>");
               /* $('#agree').click(function(){
                    $('#agree').parents(".showlink").find(".errorMsg").remove();
                })*/
                return false;
            }
            if(!$('#xfnickname').val()){
                $('#slideCodeBox').show();
                return false;
            }
            $('#submit') .attr('value', t('core', '提交中 …'));
            /*检测手机号是否注册*/
            var mobile =  $('#mobile').val();
            if(OC.Login.isPoneAvailable(mobile)){
                $.get("/xfreg/checkmobile?mobile=" + mobile, function(res){
                       var info = res.data;
                       if(info && info.result =="1"){

                           $("form[name=xfregister]").data('checked','1');
                            $('#submit').trigger("click");
                           return true;
                       }else{

                           var error = $("<span class='errorMsg'>手机号已经注册</span>");
                           $('#mobile').parent(".line").append(error);  
                           $('#mobile').focus(function(){
                                $('#mobile').parent(".line").find(".errorMsg").remove();
                           });
                           $('#submit') .attr('value', t('core', '下一步'));
                           return false;
                       }
                })
            }else{
                  var error = $("<span class='errorMsg'>手机号码格式有误</span>");
                           $('#mobile').parent(".line").append(error);  
                           $('#mobile').focus(function(){
                                $('#mobile').parent(".line").find(".errorMsg").remove();
                           });
                           $('#submit') .attr('value', t('core', '下一步'));
                           return false;
            }
            return false;
        });
        /*输入短信验证码表单提交*/
         $("form[name=xfregisterSms]").submit(function(){
             if($("form[name=xfregisterSms]").data('ckispass')=="1"){
                 //找回密码第二次触发submit按钮直接返回 提交表单
                 return true;
             }
             /*找回密码*/
            if($("input[name=smscode]").val()){
                //return true;
                var smstype = $("#submit").data('smstype');
                var smscode = $("input[name=smscode]").val();
                
                if(smstype =='findpassword'){
                     $('#submit') .attr('value', t('core', '验证中 …'));
                     $.get('/xfpassport/cksmscode?smscode=' + smscode,  function(res){
                       
                      /*info = {regedit: "1"  result: "1"  user_name: "nihongw"  } */
                        if(res.result==1){ //修改成功
                            // console.log(info);
                            $("form[name=xfregisterSms]").data('ckispass',"1");
                            $("#submit").trigger("click");
                         }else{ //console.log(e);
                           $("input[name=smscode]").focus();
                           $(".showcode p").html("<span class='errorCode' style='color:red'>短信验证码错误</span>");
                           $('#submit') .attr('value', t('core', '下一步'));
                         // return false;
                        }
                      
                     });
                }else{
                    return true;
                }
                
            }
            return false;
        });
        /*验证码倒计时*/
        if($("#redobtn").length>0){
            $("form[name=xfregisterSms]").attr("action","/xfreg/regok");
            //设置步骤表单提交进入下一步
            var daojis = $('<label>倒计时(<span>60</span>)秒<label>');
             var timmer ;
            var daojisfunction = function(){
                var now = daojis.find("span").html();
                if(now==0){
                    $("#redobtn").data('canresend', "1");
                    clearInterval(timmer);
                     $("#redobtn").html('重新发送验证码').addClass('primary');
                    return;
                }else{
                    now = now -1;
                    daojis.find("span").html(now);
                }
            }
            if($("#redobtn").data('canresend')=="0"){
           
                $("#redobtn").html(daojis).removeClass('primary');
                $("#redobtn").data('canResend', "0");               
                timmer = setInterval( daojisfunction, 1000); 
            }else{
                 $("#redobtn").html('重新发送验证码').addClass('primary'); 
            }
            //onclick
             $("#redobtn").click(function(){
                 var mobile = $("#xfnickname").val();
                 var last = $("#lasttime").val();
                 if($(this).data('canresend')==1 && mobile && last ){
                     var smstype = $(this).data('smstype');
                     $.get('/xfreg/sendsms?mobile='+mobile+"&last="+last+"&type="+smstype, function(ret){
                            daojis.find("span").html("60");
                            $("#redobtn").html(daojis).removeClass('primary');
                            $("#redobtn").data('canResend', "0");
                            timmer = setInterval( daojisfunction, 1000); 
                            $("#lasttime").val(ret.lasttime); //最后发送时间
                     })
                 }
             })
        }
        /*找回密码的输入手机号+新密码 滑块表单 /xfpassport/cksmscode*/
        $("form[name=findpassword]").submit(function(){
            if(!$('#xfnickname').val()){
                $('#slideCodeBox').show();
                return false;
            }
        
            return true;
        });
        function timeoutRedirect($formobj,url, callback){
            var index = 3;
            var timer = null;
            $formobj.find(".showmsg").append('<p><a href="'+url+'"><span class="timeout">3</span> 秒后跳转……</a></p>');
            var fun = function(){
                index = index  - 1;
                $(".timeout").html(index);
                if(index==0){
                    clearInterval(timer);
                    if(callback) callback();
                }
            }
            timer = setInterval(fun, 1000);
        }
         /*欢迎页面 如果有 回调 处理包括第三方授权登陆后 回调到 第三方网址welcomeForm */
          if($("form[name=welcomeForm]").length>0){
                 var $formobj = $("form[name=welcomeForm]");
                if($("input[name=redirect_url]").length>0){
                    var url = $("input[name=redirect_url]").val();
                    if(url){
                        timeoutRedirect($formobj, url, function(){ window.location.href=url; })
                    }
                }    
          }
        /*先锋号扫码登陆界面js*/
        if($("form[name=erweimaLogin]").length>0){
           // OC.Erweima.renderQrcode();
        }
        /*先锋号注册成功，重置密码成功 后3秒跳转*/
        if($("form[name=xfregisterOk]").length>0){
            var $formobj = $("form[name=xfregisterOk]");
            if($("input[name=regok_redirect_url]").length>0){
                var url = $("input[name=regok_redirect_url]").val();
                if(url){
                  timeoutRedirect($formobj, url, function(){ window.location.href=url; })
                }
            }
            /*第三方登陆成功后跳转 不使用了*/
            if(($("input[name=oauthType]").length>0)){
                 var url = $("input[name=redirect_url]").val();
                 if(url){
                   timeoutRedirect($formobj, url, function(){
                       $formobj.attr('action', url);
                       $formobj.submit();
                   })  
                    /*$formobj.attr('action',$("input[name=redirect_url]").val() );
                    $formobj.find(".showmsg").append('<p><a href="'+url+'">3秒后跳转……</a></p>');
                     var fun = function(){
                        //$formobj.submit();
                    }
                    setTimeout(fun, 3000);*/
                }
            }
        }
        /*扫码和表单登陆切换 login-icon-ercode*/
        $(".login-type-ercode").click(function(){
            var a = $(this);
            var curr = a.data('curr');
            var iconErcode = "login-icon-ercode";
            var iconPc = "login-icon-pc";
            var erweimaForm = $("#xfErweimaFromBox");
            var pcForm = $("#xfLoginFromBox");
            if(curr =='xfLoginFromBox'){
                a.data("curr", 'xfErweimaFromBox');
                pcForm.hide();
                erweimaForm.show();
                a.find("i").removeClass(iconErcode).addClass(iconPc);
                OC.Erweima.renderQrcode(); //显示二维码
            }else{
                a.data("curr", 'xfLoginFromBox');
                pcForm.show();
                erweimaForm.hide();
                a.find("i").removeClass(iconPc).addClass(iconErcode); 
               
            }
        });
         /*第三方mevideo 和 xfplay 的app扫码登陆界面
         * /xflogin/erweima/mevideo */
         if($("#otherAppErweimaForm").length>0){
              OC.Erweima.renderQrcode(); //显示二维码
         }  
         
         $("#showSaoMa").click(function(){
             $('.tabBox').hide();
             $(".tabItems").show();
             $(".tabItemsQrcode").hide();
         })
         $(".tabshowBack").click( function(){
             
             $(".tabItems").hide();
             $(".tabItemsQrcode").hide();
             $('.tabBox').show();
         })
         $("#showErWeiMa").click(function(){
             $('.tabBox').hide();
             $(".tabItems").hide();
             $(".tabItemsQrcode").show();
         })
         /* 下载二维码和 扫码登陆切换*/
         $(".openShowDn").click(function(){
             $("#showDn").fadeIn();
             return false;
         })
         $(".closeShowDn").click(function(){
             $("#showDn").fadeOut();
              return false;
         })
});
