<?php
/**
 * ownCloud - registration
 *
 * This file is licensed under the Affero General Public License version 3 or
 * later. See the COPYING file.
 *
 * @author Pellaeon Lin <pellaeon@hs.ntnu.edu.tw>
 * @author Julius Härtl <jus@bitgrid.net>
 * @copyright Pellaeon Lin 2014
 */

$app = new \OCA\Registration\AppInfo\Application();

return [
	'routes' => [
		['name' => 'settings#admin', 'url' => '/settings', 'verb' => 'POST'],
                ['name' => 'settings#domainPanel', 'url' => '/domainPanel', 'verb' => 'POST'],
                ['name' => 'xflogin#redirect', 'url' => '/', 'verb' => 'GET'],
                ['name' => 'xflogin#authback', 'url' => '/authback', 'verb' => 'GET'],
                ['name' => 'xflogin#xfUserAuthLogin', 'url' => '/xfback', 'verb' => 'GET'],
                ['name' => 'xflogin#xfUserRegisterNotice', 'url' => '/xfback', 'verb' => 'POST'],
                ['name' => 'xflogin#getToken', 'url' => '/auth2/token', 'verb' => 'GET'],
                ['name' => 'xflogin#getInfo', 'url' => '/api/users/getInfo', 'verb' => 'GET'], 
                ['name' => 'xflogin#authorize', 'url' => '/auth2/authorize', 'verb' => 'GET'], 
                ['name' => 'xflogin#refreshToken', 'url' => '/auth2/refreshToken', 'verb' => 'GET'],
                ['name' => 'xflogin#getJsConfig', 'url' => '/js/config.js', 'verb' => 'GET'], 
                ['name' => 'xflogin#registerUserAPI', 'url' => '/createUser', 'verb' => 'POST'],
                ['name' => 'xflogin#getSiteNostr', 'url' => '/getnostr', 'verb' => 'GET'],
                ['name' => 'xflogin#OtherRedirect', 'url' => '/otherRedirect', 'verb' => 'GET'],
                ['name' => 'xflogin#setCode', 'url' => '/setCode', 'verb' => 'GET'],
		['name' => 'register#askEmail', 'url' => '/email', 'verb' => 'GET'],
		['name' => 'register#validateEmail', 'url' => '/', 'verb' => 'POST'],
		['name' => 'register#verifyToken', 'url' => '/verify/{token}', 'verb' => 'GET'],
		['name' => 'register#createAccount', 'url' => '/verify/{token}', 'verb' => 'POST'],
                ['name'=> 'xflogin#csrfAjax', 'url'=> '/csrfAjax', 'verb' => 'GET']
	],
	'ocs' => [
		['root' => '/registration', 'name' => 'api#validate', 'url' => '/v1/validate', 'verb' => 'POST'],
		['root' => '/registration', 'name' => 'api#status', 'url' => '/v1/status', 'verb' => 'POST'],
		['root' => '/registration', 'name' => 'api#register', 'url' => '/v1/register', 'verb' => 'POST'],
                [  'name' => 'api#show', 'url' => '/v1/show/{username}', 'verb' => 'GET']
	]
];
