(function() {
        OCdialogs || {};
        if(!OC.Share) {
		OC.Share = {};
	}
        if (!OCA.Sharing) {
            /**
             * @namespace OCA.Sharing
             */
            OCA.Sharing = {};
        }
  /**
   * 分享链接对话框
   * 文件的菜单  fileActions.registerAction（{name: 'Share'………}）
   */
 
        var ShareDialog = $.extend(OCdialogs, {
            shareId: false,
             //改变列表上 --分享链接后图标的显示      
            TriggerShareIcon : function(shareModel){
                if( !shareModel.get('linkShares') ){
                    return false;
                }
                if(! this.fileList){
                    return false;
                }
                var fileInfoModel = shareModel.fileInfoModel;
                var $tr = this.fileList.findFileEl(fileInfoModel.get('name'));

                // We count email shares as link share
                var hasLinkShares = shareModel.hasLinkShares();
                shareModel.get('shares').forEach(function (share) {
                        if (share.share_type === OC.Share.SHARE_TYPE_EMAIL) {
                                hasLinkShares = true;
                        }
                });

                OCA.Sharing.Util._updateFileListDataAttributes(this.fileList, $tr, shareModel);
                if (!OCA.Sharing.Util._updateFileActionIcon($tr, shareModel.hasUserShares(), hasLinkShares)) {
                        // remove icon, if applicable
                        OC.Share.markFileAsShared($tr, false, false);
                }

                // FIXME: this is too convoluted. We need to get rid of the above updates
                // and only ever update the model and let the events take care of rerendering
                fileInfoModel.set({
                        shareTypes: shareModel.getShareTypes(),
                        // in case markFileAsShared decided to change the icon,
                        // we need to modify the model
                        // (FIXME: yes, this is hacky)
                        icon: $tr.attr('data-icon')
                });
            },     
            randomPassword :   function (size) {
                  var seed = new Array('A','B','C','D','E','F','G','H','I','J','K','L','M','N','P','Q','R','S','T','U','V','W','X','Y','Z',
                  'a','b','c','d','e','f','g','h','i','j','k','m','n','p','Q','r','s','t','u','v','w','x','y','z',
                  '2','3','4','5','6','7','8','9'
                  );//数组
                  var seedlength = seed.length;//数组长度
                  var createPassword = '';
                  for (i=0;i<size;i++) {
                    j = Math.floor(Math.random()*seedlength);
                    createPassword += seed[j];
                  }
                  return createPassword;
            },
            /**
             * 创建分享链接
             * @returns {Boolean}
             */
            createShare: function(){
                var self = this;
                 //创建第一次链接
                var configModel = this.shareModel.configModel;
                var shareData = {}  
                    //判断是否有链接生成过
                 if(this.shareModel.get('linkShares') && this.shareModel.get('linkShares').length>0){
                     return false;
                 }
                  var isPasswordEnforced = configModel.get('enforcePasswordForPublicLink');
                  var isExpirationEnforced = configModel.get('isDefaultExpireDateEnforced');

                  // set default expire date
                  if (isExpirationEnforced) {
                      //如果系统有设置默认分享有效期天数时
                          var defaultExpireDays = configModel.get('defaultExpireDate');
                          var expireDate = moment().add(defaultExpireDays, 'day').format('DD-MM-YYYY')
                          shareData.expireDate = expireDate;
                  }
                  //如果在对话框中点击选择了日期
                 var day =  self.$openShare.find('input[type="radio"]:checked').val(); 
                 if(day==1 || day==7){
                    var expireDate = moment().add( day, 'day').format('DD-MM-YYYY')
                    shareData.expireDate = expireDate;  
                 }
                  //密码设置情况
                  var form_used_pawd = self.$openShare.find('#select_password').is(":checked");
                  if(form_used_pawd || isPasswordEnforced){
                    if(!self.tqpwd){
                         self.tqpwd = OCA.Sharing.ShareDialog.randomPassword(8);
                     }
                  }else{
                      self.tqpwd = '';
                  }
                  shareData.password =  shareData.label =   self.tqpwd;                                             
             
                // else, we have a password or it is not enforced
                 $.when(this.shareModel.saveLinkShare(shareData, {
                         success: function( e ) {
                            
                            //self.shareModel.trigger('sharesChanged', self.shareModel); 
                            if(e.changed.shares){
                              //  self.shareModel.set('linkShares', e.changed.shares);
                            }
                         },
                         error: function() {
                                 // empty function to override the default Dialog warning
                         }
                 })).fail(function(response) {
                     self.click_ok_button = false;
                    // console.log(response)
                 }).then(function(response) {
                        self.click_ok_button = false;
                         // resolve before success                       
                       if(!self.shareId){
                            if(response.ocs.data instanceof Array){ 
                                 var last = response.ocs.data.pop();
                                 self.shareId = last.id;
                            }else{
                                self.shareId = response.ocs.data.id;
                            }
                        }
                       
                        if(self.tqpwd !==''){
                            self.$openShare.find('.tqpwd').html( t('files_sharing', 'ExtractionCode') + '（'+self.tqpwd +'）');
                        }
                 }); 

            },

            /**
             * 弹出分享链接设置对话框
             * @param {type} title
             * @param {type} callback
             * @param {type} type
             * @param {type} emptyText
             * @returns {undefined}
             */
            openshare: function(context, fileList, callback, type,emptyText){
                //加载分享对话框的模板和初始化
               this.context = context;
               this.fileList = fileList;
                //this.change = shareModel;
                this.click_ok_button = false;
                this.tqpwd = ""; //初始化每一次弹窗的参数；
                //this.configModel = shareModel.configModel;
                     //获取分享链接信息
                var permissions = parseInt(context.$file.data('share-permissions'), 10);
                var attributes = {
                    itemType: context.$file.data('type')=='dir'? 'folder': 'file' ,
                    itemSource: context.$file.data('id'),
                    possiblePermissions: permissions
                }; 
                var configModel = new OC.Share.ShareConfigModel();
                this.shareModel = new OC.Share.ShareItemModel(attributes, {
                        configModel: configModel,
                        fileInfoModel: context.fileInfoModel
                });    
                var self = this;
                var title = t('files_sharing', 'Link sharing');
                //设置shareItemModel 数据变化后触发事件；
                /**
                 * 流程很重要，先设置模型监听事件
                 * 最好在执行 this.shareModel.fetch()去取数据
                 * 取到数据后，shareChanged事件通知 监听处理函数，
                 */
                this.shareModel.on('change', function(){                  
                    this.trigger('sharesChanged', self.shareModel);      
                }) 
                //这里是 显示对话框的模板内容，并初始化元素的相关事件
          	$.when(this._getOpenShareTemplate()).then(function($tmpl) {                   
                       
			self.openshare.loading = false;
			var dialogId = 'oc-dialog-openshare-content';
			if(self.$openShare) {
				self.$openShare.ocdialog('close');
			} 
                        //模板数据
			self.$openShare = $tmpl.octemplate({
				dialog_id: dialogId,
				title: title,
				emptytext: emptyText,
                                checkLabel : t('files_sharing', 'Enable extraction code'),
                                share_validate: t('files_sharing', 'Term of validity:'),
                                day: t('files_sharing', 'Day'),
                                share_unlimit: t('files_sharing', 'Unlimited'),
                                share_cancel: t('files_sharing', 'Cancel share'),
                                share_copy: t('files_sharing', 'Please strictly abide by the relevant laws and regulations, and strictly prohibit the storage or dissemination of classified, obscene, pirated, infringing and content and information endangering national security and social harmony.')
			}).data('path', '') ;
                        //模板添加到DOM树
			$('body').append(self.$openShare); 
                        //模板添加到当前页面的DOM文档树完成后，ready事件
			self.$openShare.ready(function() {
                             self.okbutton = self.$openShare.find('.el-dialog__confirm-1');
                             self.cancelbutton = self.$openShare.find('.el-dialog__cancel-1');
                             self.password_checkbox = self.$openShare. find("#select_password");
                             self.expiredate_radio = self.$openShare. find("input[name='extensionDate']");
                             self.input_tqpwd = self.$openShare. find("#share-input-tqpwd");
                             self.input_tqpwd_submit = self.$openShare. find("#share-submit-tqpwd");
                             self.input_tqpwd_form = self.$openShare. find(".filenameform");
                             //模拟点击
                            // self.okbutton.trigger('click');
                             //密码修改后
                             self.password_checkbox.on('change', function(event){
                               
                                 if(self.password_checkbox.is(":checked")){
                                     //记录一下提取密码
                                     //console.log(self.shareId)
                                     self.tqpwd = self.randomPassword(8);                                     
                                     self.input_tqpwd_form.show();
                                     self.input_tqpwd.val(self.tqpwd)
                                 }else{
                                     self.tqpwd = '';                                   
                                     self.input_tqpwd_form.hide();
                                     self.input_tqpwd.val('')
                                 }
                                 console.log('---------'+self.shareId)
                                 if(self.shareId){  //如果是修改可以直接提交
                                     self.shareModel.updateShare(self.shareId, {
                                            password:self.tqpwd ,
                                            label: self.tqpwd,
                                            passwordChanged: true,
                                            cid: self.shareId
                                        })
                                 }
                             })
                             self.input_tqpwd_submit.on('click', function(){
                                 //记录一下提取密码
                                    var pwd2 = self.input_tqpwd.val();
                                     
                                     self.tqpwd = self.input_tqpwd.val( ) ;
                                     if(self.shareId){ 
                                     self.shareModel.updateShare(self.shareId,{
                                         password:self.tqpwd ,
                                         label: self.tqpwd,
                                         passwordChanged: true,
                                         cid: self.shareId
                                     })
                                 }
                             })
                             //过期时间修改后
                             self.expiredate_radio.on('change', function(event){
                                var expireDate = null;
                                var day =  self.$openShare.find('input[type="radio"]:checked').val(); 
                                if(day==1 || day==7){
                                    expireDate = moment().add( day, 'day').format('DD-MM-YYYY');                                     
                                } 
                                if(self.shareId){ 
                                 self.shareModel.updateShare(self.shareId,{
                                         expireDate:  expireDate,                                       
                                         cid: self.shareId
                                     })
                                 }
                             })
                             //点击确定按钮后生成链接或者复制链接地址
                             self.okbutton.on("click", function(event){                                
                                 if(self.click_ok_button){
                                     return true;
                                 }
                                 self.click_ok_button = true;
                                 if(!self.shareId){
                                      self.createShare();//创建新链接
                                      /**
                                       * 当文件没有分享链接时，打开分享窗口
                                       * 需要点击创建链接按钮，生成链接
                                       * 或者通过选择 启用提取码，有效期两个
                                       * 按钮也能生成链接；
                                       * self.shareId 作为判断是否新创建和编辑
                                       */
                                 }
                             });
                             //取消按钮事件后处理
                             self.cancelbutton.on("click", function(event){
                               //如果有链接存在，就取消当前分享链接
                               if(self.shareId){
                                    self.change.removeShare( self.shareId, {
                                          success: function() {
                                                 self.TriggerShareIcon(self.change);
                                                 self.$openShare.ocdialog('close');
                                                  OC.Notification.showTemporary(t('core', '取消分享链接成功！'));
                                          },
                                          error: function() {
                                                 self.$openShare.ocdialog('close');
                                                  OC.Notification.showTemporary(t('core', 'Could not unshare'));
                                          }
                                         });
                                }else{
                                    self.$openShare.ocdialog('close');
                                }                          
                              })
			});
                        //把上面的模板 用全局统一的dialog方式打开；
                        self.$openShare.ocdialog({
				closeOnEscape: true,
				// max-width of 600
				width: 580,
				height: 420,
				modal: true,
				buttons: [],
                                title: title,
				style: {
					buttons: 'aside',
				},
				close: function() {
                                        self.shareId = false;
					try {
						$(this).ocdialog('destroy').remove();
					} catch(e) {}
					self.$openShare = null;
				}
			});
                        //美化对话框的样式+标题栏
                        $("#"+dialogId).parent().addClass('dialog-openshare');
                        $("#"+dialogId).parent().children('.oc-dialog-title') .html(' <i class="ton ton-logo-copy"></i>'+ title)
		})
		.fail(function(status, error) {
			// If the method is called while navigating away
			// from the page, it is probably not needed ;)
			self.openshare.loading = false;
			if(status !== 0) {
				alert(t('core', 'Error loading file picker template: {error}', {error: error}));
			}
		});  
     
                /**
                 * 这个 事件监听 分享链接的数据模型变化后 进行
                 * 相关动作的修改，界面变化
                 * 非常重要
                 */
                this.shareModel.on('sharesChanged', function(data){
                    self.change = data; //把每次的数据变化保存起来
                 
                    if(data.changed.shares && data.get('linkShares').length===0){
                        // console.log('--sharesChanged-')
                        data.set("linkShares", data.changed.shares);
                    }
                    var linkShares = data.get('linkShares');
		    var shareIndex = _.findIndex(linkShares, function(share) {return share.id === self.shareId})
                    if(shareIndex>-1){
                        var linkShare = linkShares[shareIndex];
                    }else{   
                      //  console.log('----------')
                      //var linkShare = data.get('linkShares').pop();  
                      var linkShare = self.shareModel.get('linkShares').pop();
                    }
                    //console.log(linkShare);
                    //console.log(self.shareId)
                    var file_type = data.fileInfoModel.get('type') == 'dir' ?  t('files_sharing', 'Folder'):  t('files_sharing', 'File');
                    var file_name = data.fileInfoModel.get('name');
                    var title =  t('files_sharing', 'Share')+ " " + file_type+ " "+file_name  ;
                    if(!linkShare || linkShare === 'undefined'){                       
                        //self.shareId = false;
                        //console.log('linkshare---3')
                        //生成按钮 
                        self.$openShare.find('.hidden-columns__texts-1').html( title ); 
                        if(self.shareId){
                             self.$openShare.find('.el-dialog__confirm-1').html( t('files_sharing','Click Copy link'));
                        }else{
                            self.$openShare.find('.el-dialog__confirm-1').html( t('files_sharing','Click to create a sharing link'));
                        }
                        
                        //self.$openShare.find('.share-open-url').addClass("hidden");
                        return false; //没有数据是不处理
                    }else{
                        var share_title =t('files_sharing', 'Link created. Share it with friends now.');
                        self.$openShare.find('.hidden-columns__texts-1').html( t('files_sharing', share_title)); 
                        self.$openShare.find('.el-dialog__confirm-1').html( t('files_sharing','Click Copy link'));
                        self.$openShare.find('.share-open-url').removeClass("hidden");
                    }
                    self.$openShare.parent().find('.oc-dialog-title').html(' <i class="ton ton-logo-copy"></i>'+ t('files_sharing','Shared:')+ file_name)
                    self.shareId = linkShare.id;
                    // console.log(self.shareId)
                    // console.log(self);
                    if(!self.$openShare){
                        return false;
                    }
                    self.copydata = linkShare.url;
                    self.$openShare.find('.el-dialog__linktext-1').val(linkShare.url);
                    if(linkShare.password){
                        self.tqpwd = linkShare.label; //原始密码
                        self.$openShare.find('#select_password').attr('checked', true) ;
                        self.$openShare.find("#share-input-tqpwd").val(self.tqpwd);
                        self.$openShare.find('.filenameform').show( ) ;
                    }
                    if(linkShare.expiration){
                        //相差天数
                        var diff = moment(linkShare.expiration  ).diff(  moment(), 'days');                        
                        if(diff<=1){
                            self.$openShare.find('#sharingDialogAllowPublicUpload-r-1').attr('checked', true) ;
                        }else if(diff<7){//1天内
                            self.$openShare.find('#sharingDialogAllowPublicUpload-r-7').attr('checked', true) ;
                        }else{ //系统过期的分享会被自动删除
                           self.$openShare.find ('.day-items').append('<label style="color:red">已经期</label>'); 
                        }
                        
                    }else{
                       self.$openShare.find('#sharingDialogAllowPublicUpload-r-9').attr('checked', true) ; 
                    }
                    if(self.tqpwd !==''){
                            self.$openShare.find('.tqpwd').html( t('files_sharing', 'ExtractionCode') + '（'+self.tqpwd +'）');
                            self.copydata+=   '#-------- '+t('files_sharing', 'ExtractionCode')+' （'+self.tqpwd +'）';
                    }else{
                         self.$openShare.find('.tqpwd').html('');
                    }
                    //改变列表的文件夹图标
                     self.TriggerShareIcon(data);
                     //设置复制的内容
                     
                     self.$openShare.find('#link-share-text-input').val(self.copydata);
                     //绑定 按钮点击复制功能
                     var clipboard = new Clipboard('.el-dialog__confirm-1');
			clipboard.on('success', function(e) {
				var $trigger = $(e.trigger); 
			});
			clipboard.on('error', function (e) {
				$input =  self.$openShare.find('#link-share-text-input');
				$input.select();				 
			});
                })               
                   
                    
                //加载当前文件的分享 数据
                this.shareModel.fetch();              
               
                    
            },
            
            _getOpenShareTemplate: function() {
		var defer = $.Deferred();
		if(!this.$openShareTemplate) {
			var self = this;
			$.get(OC.filePath('files_sharing', 'templates', 'sharing.html?t='+Math.random()), function(tmpl) {
				self.$openShareTemplate = $(tmpl);				 
				defer.resolve(self.$openShareTemplate);
			})
			.fail(function(jqXHR, textStatus, errorThrown) {
				defer.reject(jqXHR.status, errorThrown);
			});
		} else {
			defer.resolve(this.$openShareTemplate);
		}
		return defer.promise();
            },
            
        });
        
        OCA.Sharing.ShareDialog = ShareDialog;
})();


