/**
 * ownCloud - core
 *
 * This file is licensed under the Affero General Public License version 3 or
 * later. See the COPYING file.
 *
 * @author Bernhard Posselt <dev@bernhard-posselt.com>
 * @copyright Bernhard Posselt 2014
 */

(function (document, $, exports) {

	'use strict';

	var dynamicSlideToggleEnabled = false;

	exports.Apps = {
		enableDynamicSlideToggle: function () {
			dynamicSlideToggleEnabled = true;
		}
	};

	/**
	 * Shows the #app-sidebar and add .with-app-sidebar to subsequent siblings
	 *
	 * @param {Object} [$el] sidebar element to show, defaults to $('#app-sidebar')
	 */
	exports.Apps.showAppSidebar = function($el) {
		var $appSidebar = $el || $('#app-sidebar');
		$appSidebar.removeClass('disappear')
			.show('slide', { direction: 'right' }, 300);
		$('#app-content').trigger(new $.Event('appresized'));
	};

	/**
	 * Shows the #app-sidebar and removes .with-app-sidebar from subsequent
	 * siblings
	 *
	 * @param {Object} [$el] sidebar element to hide, defaults to $('#app-sidebar')
	 */
	exports.Apps.hideAppSidebar = function($el) {
		var $appSidebar = $el || $('#app-sidebar');
		$appSidebar.hide('slide', { direction: 'right' }, 300,
			function() {
				$appSidebar.addClass('disappear');
			});
		$('#app-content').trigger(new $.Event('appresized'));
	};

	/**
	 * Provides a way to slide down a target area through a button and slide it
	 * up if the user clicks somewhere else. Used for the news app settings and
	 * add new field.
	 *
	 * Usage:
	 * <button data-apps-slide-toggle=".slide-area">slide</button>
	 * <div class=".slide-area" class="hidden">I'm sliding up</div>
	 */
	var registerAppsSlideToggle = function () {
		var buttons = $('[data-apps-slide-toggle]');

		if (buttons.length === 0) {
			$('#app-navigation').addClass('without-app-settings');
		}

		$(document).click(function (event) {

			if (dynamicSlideToggleEnabled) {
				buttons = $('[data-apps-slide-toggle]');
			}

			buttons.each(function (index, button) {

				var areaSelector = $(button).data('apps-slide-toggle');
				var area = $(areaSelector);

				function hideArea() {
					area.slideUp(OC.menuSpeed*4, function() {
						area.trigger(new $.Event('hide'));
					});
					area.removeClass('opened');
					$(button).removeClass('opened');
				}
				function showArea() {
					area.slideDown(OC.menuSpeed*4, function() {
						area.trigger(new $.Event('show'));
					});
					area.addClass('opened');
					$(button).addClass('opened');
					var input = $(areaSelector + ' [autofocus]');
					if (input.length === 1) {
						input.focus();
					}
				}

				// do nothing if the area is animated
				if (!area.is(':animated')) {

					// button toggles the area
					if ($(button).is($(event.target).closest('[data-apps-slide-toggle]'))) {
						if (area.is(':visible')) {
							hideArea();
						} else {
							showArea();
						}

					// all other areas that have not been clicked but are open
					// should be slid up
					} else {
						var closest = $(event.target).closest(areaSelector);
						if (area.is(':visible') && closest[0] !== area[0]) {
							hideArea();
						}
					}
				}
			});

		});
	};
        var  kbSetCookie =     function (cname, cvalue, exdays) {
                    var d = new Date();
                    d.setTime(d.getTime() + (exdays*24*60*60*1000));
                    var expires = "expires="+ d.toUTCString();
                    document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
                } 
                //==
         var kbGetCookie =        function (cname) {
                        var name = cname + "=";
                        var decodedCookie = decodeURIComponent(document.cookie);
                        var ca = decodedCookie.split(';');
                        for(var i = 0; i <ca.length; i++) {
                            var c = ca[i];
                            while (c.charAt(0) == ' ') {
                                c = c.substring(1);
                             }
                             if (c.indexOf(name) == 0) {
                                return c.substring(name.length, c.length);
                             }
                         }
                        return "";
                    }  
        var removeSiteFavorite = function(obj){
            var siteFavorite = kbGetCookie("siteFavorite");
            var cs = siteFavorite ? JSON.parse( siteFavorite) : [];
            var name = $(obj).attr('title');
            var _arr = cs;
            var length = cs.length;
             for(var i in cs){                    
                    if(name ===  cs[i].name){
                        if (i == 0) {
                            _arr.shift(); //删除并返回数组的第一个元素                            
                        }
                        else if (i == length - 1) {
                            _arr.pop();  //删除并返回数组的最后一个元素                            
                        }
                        else {
                            _arr.splice(i, 1); //删除下标为i的元素                            
                        } 
                    }
                }
             $(obj).parents('dd').remove();
             kbSetCookie('siteFavorite',  JSON.stringify(cs), 3650);
        }
        var registerSiteFavoriteDropMenu = function(){
            var button = $('.siteNameli');
            var myURL = new URL(window.location.href);
            var selfUrl = myURL.protocol+"//"+ myURL.hostname + (myURL.port? ":"+ myURL.port :'');
            var name = button .attr('aria-label');
            var target = $("#"+ button.attr('aria-controls'));
            var siteFavorite = kbGetCookie("siteFavorite");
            var cs = siteFavorite ? JSON.parse( siteFavorite) : [];
            var html = '';           
            var canAdd = true;
            if( (cs instanceof  Array) && cs.length>0){
                for(var i in cs){
                    html+='<dd lay-unselect=""><a href="'+cs[i].url+'">'+cs[i].name+'</a><a class="rmddaa" title="'+cs[i].name+'">×</a></dd>';
                    if(name ===  cs[i].name){
                        canAdd = false;
                    }
                }
                target.find('.items').html(html);
                $('.rmddaa').click(function(){ removeSiteFavorite(this)})
            }
           
            button.hover(function(){
                target.show();
            }, function(){
                target.hide();
            });
            function addtofavorite(canAdd, url, name){
               var newhtml = '<dd lay-unselect=""><a href="'+url+'">'+name+'</a></dd>';
               if(canAdd){
                    cs.push({"url":url, "name": name});
                    kbSetCookie('siteFavorite',  JSON.stringify(cs),3650);
                    target.find('.items').append(newhtml); 
                    canAdd = false;
                }
            }
            button.find('.button').click(function(){                         
               
               button.find('.dd1').hide();
               button.find('.dd2').show();
               addtofavorite(canAdd, selfUrl, name);
            })
           $("form[name=siteNameliform]").submit(function(){
               var inputUrl = $('input[name=siteNameliformInput]').val();
               var myURL = new URL(inputUrl);
               inputUrl = myURL.protocol+"//"+ myURL.hostname + (myURL.port? ":"+ myURL.port :'');
               $.ajax({url: '/apps/registration/csrfAjax?url='+inputUrl, type:'GET',dataType: "JSON",
                   success:function(e){
                        var canAdd2 = true;
                        try{
                            for(var i in cs){
                               if(e.siteName ===  cs[i].name){
                                        canAdd2 = false;
                                    }
                            }                             
                            addtofavorite(canAdd2, inputUrl,  e.siteName); 
                            
                        }catch(e){
                             return false;
                        }
                        return false;
                   },
                   complete: function(e){
                        button.find('.dd2').hide();
                        button.find('.dd1').show();
                         return false;
                   }
               });
               return false;
           });
        }


	$(document).ready(function () {
		registerAppsSlideToggle();
                
                registerSiteFavoriteDropMenu();
	});

}(document, jQuery, OC));
