<?php

/**
 * 这个是生成到先锋号授权中心地址并跳转
 */

namespace OCA\Registration\Controller;

use OCA\Registration\Db\Registration;
use OCA\Registration\Service\MailService;
use OCA\Registration\Service\RegistrationException;
use OCA\Registration\Service\RegistrationService;
use \OCP\IRequest;
use \OCP\AppFramework\Http\TemplateResponse;
use \OCP\AppFramework\Http\RedirectResponse;
use \OCP\AppFramework\Controller;
use OCP\AppFramework\Http;
use OCP\AppFramework\Http\DataDisplayResponse;
use OCP\AppFramework\Http\DataResponse;
use OCP\IURLGenerator;
use OCP\IAvatarManager;
use \OCP\IConfig;
use \OCP\IL10N;
use OCA\Registration\Util\pinyin;

class XfloginController extends Controller {

    /** @var IL10N */
    private $l10n;

    /** @var IURLGenerator */
    private $urlgenerator;

    /** @var IConfig */
    private $config;

    /** @var RegistrationService */
    private $registrationService;

    /** @var MailService */
    private $mailService;
    private $avatarManager;

    public function __construct(
    $appName, IRequest $request, IL10N $l10n, IURLGenerator $urlgenerator, IConfig $config, RegistrationService $registrationService, MailService $mailService, IAvatarManager $avatarManager
    ) {
        parent::__construct($appName, $request);
        $this->l10n = $l10n;
        $this->urlgenerator = $urlgenerator;
        $this->registrationService = $registrationService;
        $this->mailService = $mailService;
        $this->avatarManager = $avatarManager;
        $this->config = $config;
    }

    /**
     * @NoCSRFRequired
     * @PublicPage
     * 
     * @return DataResponse
     * route /apps/registration/xfback 
     * method = POST
     * 这个 是xfback 的post方法用于 注册一个 网盘账号 
     * xfUserAuthLogin 是一个 GET 方法
     * 两个方法配合使用，提供给先锋用户授权中心回调
     */
    public function xfUserRegisterNotice() {
        return $this->registerUserAPI();
    }

    /**
     * @NoCSRFRequired
     * @PublicPage
     * 
     * @return DataResponse
     * route /apps/registration/createUser 
     * method = POST
     */
    public function registerUserAPI() {
        $default_img_data = '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';

        $p['headImage'] = $this->request->getParam('headImage');
        if (empty($p['headImage'])) {
            $p['headImage'] = $default_img_data;
        }
        $client = $this->request->getParam('client');
        //验证码app端的nostr 
        $nostr = $this->request->getParam('nostr');
        $isapp = $this->request->getParam('isapp');
        if (!empty($isapp) && $isapp == 1) {
            //$mac =  $this->config->getSystemValue('instanceid');
            //if($nostr !== md5($mac)){
            $mac = $this->config->getSystemValue('macnostr');
            if ($nostr !== $mac) {
                return new DataResponse(['error' => 1, 'msg' => 'nostr invalid'], Http::STATUS_OK);
            }
        }
        //=  
        $p['userId'] = $this->request->getParam('userId');
        //= 'e4a3245a0d4b869d2fc39c9e0e3c6b4b';
        $p['username'] = $this->request->getParam('username');
        if (empty($p['username'])) {
            /* 此接口不能判断用户名空 最后有修改头像和 昵称功能，可能不传用户名 */
            // return new DataResponse( [ 'error'=> 1, 'msg'=> 'userId or username is empty'], Http::STATUS_OK);
        }
        //检验先锋号有特殊字符情况，采用复合规则的进行
        $p['username'] = preg_replace("/(|\~|\_|\`|\!|\@|\#|\$|\%|\^|\&|\*|\(|\)|\-|\+|\=|\{|\}|\[|\]|\||\\|\:|\;|\"|\'|\<|\,|\>|\.|\?|\/)/is", "", trim($p['username']));
        $acsii_str = $this->encode($p['username']);
        $acsii_str = str_replace('&#8198;', '', $acsii_str);
        $s = $this->decode($acsii_str);
        $p['username'] = trim($s);

        $password = $this->registrationService->makeRangePassd();
        $randlen = 3;
        $pinyin = new pinyin();
        //处理特殊情况没有昵称；
        try {
            if (empty($p['username'])) {
                $p['username'] = '先锋用户';
                $randlen = 6;
                $username = $pinyin->str2pys('先锋');
            } else {
                //用先锋号昵称 转换拼音
                //$username = $p['username'];
                $username = $pinyin->str2pys($p['username']);
            }
        } catch (\Exception $e) {
            $randlen = 6;
            $username = 'xianfeng';
        }
        if (empty($username)) {
            $randlen = 6;
            $username = 'xianfeng';
        }
        //= '清明上河';{"access_token":"2fa9c18e-d79c-41de-9e12-71b411fc0f60","refresh_token":"a95f3984-4389-4cc8-9539-a2036b98aa9d","scope":"basic","expires_in":1569726119013,"userId":"89363471580e12d5982288997e434069"}
        //$tokeninfo = json_encode(['access_token'=>'1' ,'refresh_token'=>'','scope'=>'base','userId'=>$p['userId']]);
        //print_r($p);
        //判断是否注册过 
        $isfirst = 0;
        try {
            $registration = $this->registrationService->verifyUserId($p['userId']);
        } catch (RegistrationException $e) {
            //先判断生成的用户名是否在registration表存在；
            try {
                $randstr = "";
                do {
                    $username = $username . $randstr;
                    $randstr = $this->registrationService->makeRangePassd($randlen);
                } while ($this->registrationService->checkUsernameIsexist($username));
                $isfirst = 1;
                $registration = $this->registrationService->createUserId($p['userId']);
            } catch (RegistrationException $e) {
                return new DataResponse(['error' => 1, 'msg' => $username . $this->l10n->t('login has failed')], Http::STATUS_OK);
            }
        }

        if ($registration->getUsername() && $registration->getPassword()) {
            $username = $registration->getUsername();          
            $encode_password = $registration->getPassword();    /* 已经被加密的密码，返回给接口用 */
            /*已经绑定过时解密密码*/
            $password = $this->registrationService->DesBase64_Decrypt($encode_password);
        } else {
            /*新绑定时password 是随机生成*/
            $this->registrationService->saveUserInfo($registration, $username, $password, $p['username']);
            $encode_password = $registration->getPassword();  /* 已经被加密的密码，返回给接口用 */
        }

        //注册一个新云盘账号 
        try {
            $user = false;
            //user表已经存在同username 的云盘号时，修改密码
            if ($user = $this->registrationService->checkUsernameBinded($username)) {
                //检验当前密码 是否和 云盘账号相同
                $pass_noequ = $this->registrationService->verifyUserPassword($username, $password);
                if (!$pass_noequ) { //密码不对无法登陆要进行修改
                    //修改 云盘的账号用户的密码
                    $user = $this->registrationService->setUserAccountPassword($username, $password);
                }
            }
            //新绑定
            if (!$user) {
                $isfirst = 1;
                //创建云盘账号
                $user = $this->registrationService->bindCreateAccount($registration, $username, $password);
                $user->setDisplayName($p['username']);
                //设置头像
                $image = new \OC_Image();
                $image->loadFromBase64($p['headImage']);
                try {
                    $avatar = $this->avatarManager->getAvatar($user->getUID());
                    $avatar->set($image);
                } catch (\Exception $e) {
                    
                }
            }
        } catch (\Exception $ex) {
            return new DataResponse(['error' => 1, 'msg' => $username . $this->l10n->t('login has failed')], Http::STATUS_OK);
        }

        /* 用户 */
        $user = $this->registrationService->getUserAccount($registration);

        /* 如果是明确指定要修改昵称或头像 */
        $changeImage = $this->request->getParam('changeImage');
        $changeName = $this->request->getParam('changeName');
        if (!empty($changeName)) {
            $user->setDisplayName($p['username']);
        }
        if (!empty($changeImage)) {
            //设置头像
            $image = new \OC_Image();
            $image->loadFromBase64($p['headImage']);
            try {
                $avatar = $this->avatarManager->getAvatar($user->getUID());
                $avatar->set($image);
            } catch (\Exception $e) {
                return new DataResponse(['uid' => $user->getUID(),
                    'error' => '1'], Http::STATUS_OK);
            }
        }
        /* 生成一个客户端登陆密钥，零时用登录要设置为空 */
        $clienToken = "";
        if (!empty($client) && $client == 'xfplay') {
            $clienToken = $this->registrationService->updateTokenInfo($registration);
        }

        return new DataResponse(['uid' => $user->getUID(),
            'username' => $p['username'],
            'nickName' => $user->getDisplayName(),
            'clienToken' => $clienToken,
            'isfirst' => $isfirst ,
            'password' => $encode_password, 'error' => '0'], Http::STATUS_OK);
    }

    /**
     * @NoCSRFRequired
     * @PublicPage
     * 
     * 这个是先锋号授权中心通过GET 方式回调 登陆系统
     * @param userId 先锋号
     * route /apps/registration/xfback
     *  http://test2019.xfplay.com:20081/apps/registration/xfback?getcode=1
     * 这个接口需要两个参数，先锋号授权中心 post 到 
     */
    public function xfUserAuthLogin($userId, $clienToken = '') {
        $code = $this->request->getParam('getcode');
        if (!empty($code) && $code == 1) {
            return $this->getSiteNostr();
        }
        $userId = $this->request->getParam('userId');
        try {
            $registration = $this->registrationService->verifyUserId($userId);
        } catch (RegistrationException $e) {
            return new TemplateResponse(
                    'registration', 'message', array('msg' => $this->l10n->t('Failed to authorize login')), 'guest');
        }
        /* 检查是否post一次 */
        if (empty($clienToken)) {
            return new TemplateResponse(
                    'registration', 'message', array('msg' => $this->l10n->t('Failed to authorize login')), 'guest');
        }
        $bc = $registration->getClientSecret();
        if (empty($bc) || $bc === 'NULL' || ($bc !== $clienToken)) {
            return new TemplateResponse(
                    'registration', 'message', array('msg' => $this->l10n->t('Failed to authorize login')), 'guest');
        }
        $this->registrationService->cleanClienToken($registration); /* 情况零时密钥 */
        //$registration->setClientSecret('NULL');
        $user = $this->registrationService->getUserAccount($registration);
        $username = $registration->getUsername();
        $password_enstr = $registration->getPassword();
        $password = $this->registrationService->DesBase64_Decrypt($password_enstr);

        try {
            return $this->registrationService->loginUser($user->getUID(), $username, $password, false);
        } catch (\Exception $ex) {
            return new TemplateResponse('registration', 'xflogin.rediret_html', [], 'guest');
        }
    }

    /**
     * @NoCSRFRequired
     * @PublicPage
     *
     * @param $errormsg
     * @param $entered
     * @return TemplateResponse
     * 这个接口是 通过xmpp 的 先锋号授权接口返回code 进行登录；
     */
    public function authback() {
        $p = $this->registrationService->getAuthorizeParams();
        $isapi = $this->request->getParam('isapi');
        $code = $this->request->getParam('code');
        // $registration = $this->registrationService->verifyToken($code);
        $ret = $this->getToken($code);
        //code 过期或者已经调用过
        if ($ret['error']['errorCode']) {
            if ($isapi == 1) {
                return new DataResponse(array('msg' => $this->l10n->t($ret['error']['msg'])), Http::STATUS_OK);
            }
            return new TemplateResponse(
                    'registration', 'message', array('msg' => $this->l10n->t($ret['error']['msg'])), 'guest');
        }
        //把tokeninfo 保存起来 和账号对应
        $tokeninfo = json_encode($ret['data']);
        $access_token = $ret['data']['access_token'];
        $userId = $ret['data']['userId'];

        $ret = $this->getInfo($access_token, $userId);
        if ($ret['error']['errorCode']) {
            if ($isapi == 1) {
                return new DataResponse(array('msg' => $this->l10n->t($ret['error']['msg'])), Http::STATUS_OK);
            }
            return new TemplateResponse(
                    'registration', 'message', array('msg' => $this->l10n->t($ret['error']['msg'])), 'guest');
        }
        //userId 没有的情况；
        if (empty($ret['data']['userId']) || $ret['data']['userId'] == '') {
            if ($isapi == 1) {
                return new DataResponse(['msg' => $this->l10n->t('Failed to authorize login')], Http::STATUS_OK);
            }
            return new TemplateResponse('registration', 'message', ['msg' => $this->l10n->t('Failed to authorize login')], 'guest');
        }
        $p['headImage'] = $ret['data']['headImage'];
        //=  
        $p['userId'] = $ret['data']['userId'];
        //= 'e4a3245a0d4b869d2fc39c9e0e3c6b4b';
        $p['username'] = $ret['data']['username'];

        //检验先锋号有特殊字符情况，采用复合规则的进行
        $p['username'] = str_replace(['@', '.', '/', '_'], ['', '', '', ''], trim($p['username']));

        $password = $this->registrationService->makeRangePassd();
        $randlen = 3;
        $pinyin = new pinyin();
        //处理特殊情况没有昵称；
        if (empty($p['username'])) {
            $p['username'] = '先锋用户';
            $randlen = 6;
            $username = $pinyin->str2pys('先锋');
        } else {
            //用先锋号昵称 转换拼音
            $username = $pinyin->str2pys($p['username']);
        }

        //= '清明上河';
        $p['email'] = '';
        $p['token'] = $this->request->getParam('code');
        //print_r($p);
        //判断是否注册过 
        try {
            $registration = $this->registrationService->verifyUserId($p['userId']);
        } catch (RegistrationException $e) {
            $registration = $this->registrationService->createUserId($p['userId']);
        }
        //保存账号和 tokeninfo 的对应关系
        $this->registrationService->updateTokenInfo($registration, $tokeninfo);
        //判断是否注册过. 第一次授权登陆
        if ($registration->getUsername() == '') {
            //注册一个新账号 
            try {
                $randstr = "";
                do {
                    $username = $username . $randstr;
                    $randstr = $this->registrationService->makeRangePassd($randlen);
                    //防止重名无法注册
                } while ($this->registrationService->checkUsernameBinded($username));
                //新绑定
                $user = $this->registrationService->bindCreateAccount($registration, $username, $password);
            } catch (\Exception $ex) {
                if ($isapi == 1) {
                    return new DataResponse(['msg' => $this->l10n->t('login has failed')], Http::STATUS_OK);
                }
                return new TemplateResponse('registration', 'message', ['msg' => $this->l10n->t('login has failed')], 'guest');
            }
            $user->setDisplayName($p['username']);
            //把注册信息 记录起来
            $this->registrationService->saveUserInfo($registration, $username, $password, $p['username']);
            //设置头像
            $image = new \OC_Image();
            $image->loadFromBase64($p['headImage']);
            try {
                $avatar = $this->avatarManager->getAvatar($user->getUID());
                $avatar->set($image);
            } catch (\Exception $e) {
                
            }
        } else {
            $user = $this->registrationService->getUserAccount($registration);
            //$user->setDisplayName($p['username']);
            $username = $registration->getUsername();
            $password_enstr = $registration->getPassword();
            $password = $this->registrationService->DesBase64_Decrypt($password_enstr);
        }
        if ($isapi == 1) {
            return new DataResponse(['uid' => $user->getUID(), 'username' => $username, 'password' => $password], Http::STATUS_OK);
        }
        //是否启用了待审核
        if ($user->isEnabled()) {//是否已经启用账号审核问题；
            //自动登陆
            return $this->registrationService->loginUser($user->getUID(), $username, $password, false);
        } else {
            return new TemplateResponse('registration', 'message', ['msg' => $this->l10n->t('Account number under review')], 'guest');
        }

        return new TemplateResponse('registration', 'xflogin.rediret_html', $p, 'guest');
    }

    /**
     * @NoCSRFRequired
     * @PublicPage  
     *  
     * @param type $url
     * @param type $data
     * @param type $type
     */
    public function csrfAjax($url) {
        $url = $this->request->getParam('url');
        $data = file_get_contents($url . '/apps/registration/getnostr');
        return new DataResponse(json_decode($data, true), Http::STATUS_OK);
    }

    /**
     * @NoCSRFRequired
     * @PublicPage  
     * 
     * router /apps/registration/getnostr
     * method  GET
     */
    public function getSiteNostr() {
        //$mac =  $this->config->getSystemValue('instanceid');
        $mac = $this->config->getSystemValue('macnostr');
        $request = \OC::$server->getRequest();
        $host = $request->getServerProtocol() . "://" . $request->getServerHost();
        $code = $this->request->getParam('code');
        if ($code == 'etcg') {
            $json = file_get_contents(realpath("./data/test.json"));
            header('content-type:application/json;charset=utf-8');
            echo $json;
            exit;
        }

        return new DataResponse([
            'nostr' => $mac, //md5( $mac) ,
            'siteName' => strip_tags($this->config->getAppValue('theming', 'name')),
            'slogan' => \OCP\Util::sanitizeHTML($this->config->getAppValue('theming', 'slogan')),
            'siteUrl' => $host //$this->config->getAppValue('registration', 'appPackage')
                ], Http::STATUS_OK);
    }

    /**
     * @NoCSRFRequired
     * @PublicPage  
     * 
     * router /   
     * method  GET
     */
    public function OtherRedirect() {
        
    }

    /**
     * @NoCSRFRequired
     * @PublicPage  
     * 
     * router /apps/registration/setCode?code=2222   
     * method  GET
     */
    public function setCode() {
        $code = $this->request->getParam('code');
        if (!empty($code)) {
            $this->config->setAppValue('registration', 'domainCode', $code);
            echo 'success';
        } else {
            echo 'fail';
        }
        exit;
    }

    /**
     * @NoCSRFRequired
     * @PublicPage  
     * 
     * router /   
     * method  GET
     */
    public function redirect() {
        $p = $this->registrationService->getAuthorizeParams();
        $url = parse_url($p['appPackage']);
        $xfuser_center_url = $p['authrize_url'];
        $appPackage = $url['host']; /* 从回调地址里面解析出包名=域名 */
        $rediret_url = $p['authrize_url'] . '/wchat/index.html#converse/authlogin?'
                . "backurl=" . $p['appPackage'] .
                "&client_id=" . $p['client_id'] .
                "&secret_id=" . $p['secret_id'] .
                "&package=" . $appPackage;
        //header("Location: $rediret_url");        
        $back = $this->urlgenerator->linkToRouteAbsolute('registration.xflogin.xfUserAuthLogin');
        //$mac = $this->registrationService->getMac(PHP_OS);
        if (empty($xfuser_center_url)) {
            return new TemplateResponse(
                    'registration', 'message', array('msg' => $this->l10n->t('Administrator does not set the login information of pioneer number')), 'guest');
        }
        //$mac =  $this->config->getSystemValue('instanceid', '');
        $mac = $this->config->getSystemValue('macnostr', '');
        $app = $this->request->getParam('app');
        $rediret_url = $xfuser_center_url . "/index.php?redirect_url=$back&nostr=" . trim($mac);
        if (!empty($app)) {
            $rediret_url .= "&app=$app";
        }
        /* 这里采用云盘安装后产生的唯一id 如果系统重新安装需要保留这个instanceid 代替mac网卡地址 */
        if ($app == 'downApp') {
            $rediret_url = $xfuser_center_url . "/index.php?do=guideApp&redirect_url=$back&nostr=" . trim($mac);
        }
        header("Location: $rediret_url");
        exit;
    }

    /**
     * @NoCSRFRequired
     * @PublicPage  
     */
    public function getToken($code) {
        $p = $this->registrationService->getAuthorizeParams();
        $url = parse_url($p['appPackage']);
        $appPackage = $url['host'];
        /**/
        $baseUrl = $this->getBaseUrl();
        $grant_type = 'authorization_code';
        $client_id = $p['client_id'];
        $sign = $this->getSigna($code);

        //$code = $this->request->getParam('code');

        $url = $baseUrl . "auth2/token?"
                . "grant_type=" . $grant_type
                . "&client_id=" . $client_id
                . "&sign=" . $sign
                . "&appPackage=" . $appPackage
                . "&code=" . $code;

        $ret = file_get_contents($url);
        return json_decode($ret, true);
    }

    /**
     * 統一授权接口 的url 管理
     * @return string
     */
    public function getBaseUrl() {
        return 'https://api.xfplay.com:2020/';
    }

    /**
     * 用 $code ，按授权接口规则 进行签名；
     * @param type $code
     * @return type
     */
    public function getSigna($code) {
        $p = $this->registrationService->getAuthorizeParams();
        $url = parse_url($p['appPackage']);
        $appPackage = $url['host'];
        $params = [
            'grant_type' => 'authorization_code',
            'client_id' => $p['client_id'],
            'appPackage' => $appPackage,
            'code' => $code
        ];
        ksort($params);
        $keystr = "";
        $dot = "";
        foreach ($params as $key => $val) {
            $keystr .= $dot . $key . "=" . $val;
            $dot = "&";
        }
        $keystr = $keystr . "&key=" . $p['secret_id'];
        return strtoupper(md5($keystr));
    }

    /**
     * @NoCSRFRequired
     * @PublicPage  
     */
    public function authorize() {
        $baseUrl = $this->getBaseUrl();
        $url = $baseUrl . "auth2/authorize?"
                . "response_type=code"
                . "&client_id=" . $this->request->getParam('client_id')
                . "&scope=" . $this->request->getParam('scope')
                . "&state=1"
                . "&appPackage=" . $this->request->getParam('appPackage')
                . "&accessToken=" . $this->request->getParam('accessToken');
        $ret = file_get_contents($url);
        return json_decode($ret, true);
    }

    /**
     * @NoCSRFRequired
     * @PublicPage  
     */
    public function getInfo($access_token, $userId) {
        $baseUrl = $this->getBaseUrl();

        $url = $baseUrl . "api/users/getInfo?"
                . "access_token=" . $access_token
                . "&userId=" . $userId;

        $ret = file_get_contents($url);
        return json_decode($ret, true);
    }

    /**
     * @NoCSRFRequired
     * @PublicPage
     *
     * @return DataDisplayResponse
     */
    public function getJsConfig() {
        $p = $this->registrationService->getAuthorizeParams();
        $url = parse_url($p['appPackage']);
        $appPackage = $url['host'];
        /* 本js 依赖 js/xfsdk.js 中 xfloginSDK 对象 */
        $data = 'xfloginSDK.init({client_id:"' . $p['client_id'] . '",secret_id:"' . $p['secret_id'] . '",'
                . 'appPackage:"' . $appPackage . '", backurl: "/apps/registration/authback", showloading_func : function(){'
                . '$("#submit-wrapper").hide();$(".altlogin-wrapper .submit-icon") .removeClass("icon-confirm-white") .addClass(  "icon-loading-small-dark");$(".altlogin-wrapper .button").html("登录中…"); $(".login-additional").fadeOut();'
                . '}});'
                . ' if(xfloginSDK.getIsApp()){ '
                . '$(".altlogin-wrapper .button").attr("href","#");'
                . ' xfloginSDK.APP_xfLogin(); '
                . '}'
                . 'function xfTokenSignCallBack(code, sign) {'
                . 'xfloginSDK.xfTokenSignCallBack(code, sign);'
                . '}'
                . 'function xfcodeCallBack(errorCode, result) {   '
                . ' xfloginSDK.xfcodeCallBack(errorCode, result);'
                . '}'
                . 'console.log("loading--registration-js-config") ';

        return new DataDisplayResponse($data, Http::STATUS_OK, ['Content-type' => 'text/javascript']);
    }

    /**
     * 将ascii码转为字符串
     * @param type $str 要解码的字符串
     * @param type $prefix 前缀，默认:&#
     * @return type
     */
    protected function decode($str, $prefix = "&#") {
        $str = str_replace($prefix, "", $str);
        $a = explode(";", $str);
        $utf = "";
        foreach ($a as $dec) {
            if ($dec < 128) {
                $utf .= chr($dec);
            } else if ($dec < 2048) {
                $utf .= chr(192 + (($dec - ($dec % 64)) / 64));
                $utf .= chr(128 + ($dec % 64));
            } else {
                $utf .= chr(224 + (($dec - ($dec % 4096)) / 4096));
                $utf .= chr(128 + ((($dec % 4096) - ($dec % 64)) / 64));
                $utf .= chr(128 + ($dec % 64));
            }
        }
        return $utf;
    }

    /**
     * 将字符串转换为ascii码
     * @param type $c 要编码的字符串
     * @param type $prefix 前缀，默认：&#
     * @return string
     */
    protected function encode($c, $prefix = "&#") {
        $len = strlen($c);
        $a = 0;
        $scill = "";
        while ($a < $len) {
            $ud = 0;
            if (ord($c{$a}) >= 0 && ord($c{$a}) <= 127) {
                $ud = ord($c{$a});
                $a += 1;
            } else if (ord($c{$a}) >= 192 && ord($c{$a}) <= 223) {
                $ud = (ord($c{$a}) - 192) * 64 + (ord($c{$a + 1}) - 128);
                $a += 2;
            } else if (ord($c{$a}) >= 224 && ord($c{$a}) <= 239) {
                $ud = (ord($c{$a}) - 224) * 4096 + (ord($c{$a + 1}) - 128) * 64 + (ord($c{$a + 2}) - 128);
                $a += 3;
            } else if (ord($c{$a}) >= 240 && ord($c{$a}) <= 247) {
                $ud = (ord($c{$a}) - 240) * 262144 + (ord($c{$a + 1}) - 128) * 4096 + (ord($c{$a + 2}) - 128) * 64 + (ord($c{$a + 3}) - 128);
                $a += 4;
            } else if (ord($c{$a}) >= 248 && ord($c{$a}) <= 251) {
                $ud = (ord($c{$a}) - 248) * 16777216 + (ord($c{$a + 1}) - 128) * 262144 + (ord($c{$a + 2}) - 128) * 4096 + (ord($c{$a + 3}) - 128) * 64 + (ord($c{$a + 4}) - 128);
                $a += 5;
            } else if (ord($c{$a}) >= 252 && ord($c{$a}) <= 253) {
                $ud = (ord($c{$a}) - 252) * 1073741824 + (ord($c{$a + 1}) - 128) * 16777216 + (ord($c{$a + 2}) - 128) * 262144 + (ord($c{$a + 3}) - 128) * 4096 + (ord($c{$a + 4}) - 128) * 64 + (ord($c{$a + 5}) - 128);
                $a += 6;
            } else if (ord($c{$a}) >= 254 && ord($c{$a}) <= 255) { //error
                $ud = false;
            }
            $scill .= $prefix . $ud . ";";
        }
        return $scill;
    }

}
