/**
 * Created by jhwang on 14-10-13.
 */


define(function (require, exports) {
    var IOUtilBase = require('./ioutil').IOUtilBase;

    function IOUtil() {
    }

    IOUtil.prototype = new IOUtilBase();
    IOUtil.prototype.constructor = IOUtil;
    /**
     *   读文件
     * @param filePath
     * @returns {*}
     */
    IOUtil.prototype.readFile = function (filePath) {
        var def = jQuery.Deferred();
        if (!filePath)
            throw new Error("error argument");
        IOSSink.execute('readFile', filePath, false, function (err, ret) {
           if(err){
               console.err(err);
               def.resolve('');
           }
            else{
               def.resolve(ret);
           }
        });
        return def.promise();
    };

    /**
     * 写文件
     * @param filePath
     * @param content
     * @returns {*}
     */
    IOUtil.prototype.writeFile = function (filePath, content) {
        throw new Error("writeFile need impl");
    };

    /**
     * 使用系统自带的程序打开某个文件
     * @param filePath
     * @returns {*}
     */
    IOUtil.prototype.shellexecute = function (filePath) {
        throw new Error('shellexecute is not implemented !');
    };

    exports.IOUtil = new IOUtil();
});
