/**
 * Created with JetBrains WebStorm.
 * User: haozeswin7
 * Date: 14-6-24
 * Time: 下午8:04
 * To change this template use File | Settings | File Templates.
 */
define(function (require, exports) {

    function Hashtable() {
        this.container = new Object();

        /** put element */
        this.add = function (key, value) {
            if (typeof (key) == "undefined") {
                return false;
            }
            if (this.contains(key)) {
                return false;
            }
            this.container[key] = typeof (value) == "undefined" ? null : value;
            return true;
        };

        /**/
        /** remove element */
        this.remove = function (key) {
            delete this.container[key];
        };

        /**/
        /** get size */
        this.size = function () {
            var size = 0;
            for (var attr in this.container) {
                size++;
            }
            return size;
        };

        /**/
        /** get value by key */
        this.get = function (key) {
            return this.container[key];
        };

        /**/
        /** containts a key */
        this.contains = function (key) {
            return typeof (this.container[key]) != "undefined";
        };

        /**/
        /** clear all entrys */
        this.clear = function () {
            for (var attr in this.container) {
                delete this.container[attr];
            }
        };

        this.getValues = function () {
            var arr = [];
            for (var attr in this.container) {
                arr.push(this.container[attr]);
            }
            return arr;
        };

        /**/
        /** hashTable 2 string */
        this.toString = function () {
            var str = "";
            for (var attr in this.container) {
                str += "," + attr + "=" + this.container[attr];
            }
            if (str.length > 0) {
                str = str.substr(1, str.length);
            }
            return "{" + str + "}";
        };
    };


    exports.Hashtable = Hashtable;
});