define(function (require, exports, module) {

    var lab = require('asynLAB');

    var hasInit = false;
    /**
    *  初始化speech相关JS
    *  @param {boolean}  useLocalPlayer 是否使用本地播放器
     * @param {boolean}  useAndroidAdapter 是否使用Android适配器
    *  @param {Function} callback JS加载完毕回调
    */
    exports.init = function (useLocalPlayer, useAndroidAdapter, callback) {

        var callbackFun = function(){
            hasInit = true;
            if (typeof callback === "function") {
                callback.call(this, useLocalPlayer, useAndroidAdapter);
            }
        };

        if (hasInit) {
            if (typeof callback === "function") {
                callback.call(this, useLocalPlayer, useAndroidAdapter);
            }
        } else {

            // 加载音频组件相关JS
          var loader = lab.script(require.resolve("./iFlyPlayer/jwplayer/jwplayer"))
            .script(require.resolve("./iFlyPlayer/iFlyPlayer")).wait()
            .script(require.resolve("./SpeechRecorder/Settings")).wait()
            .script(require.resolve("./SpeechRecorder/swfobject")).wait()
            .script(require.resolve("./SpeechRecorder/SpeechRecorder"))
            .script(require.resolve("./SpeechJS/SpeechJS")).wait(function () {
                  LogUtil.reload({ top: 20, left: 850, showPanel: false, showConsole: false });
                  LogUtil.info("浏览器信息");
                 var browserInfo = getBrowserInfo();
                 for(var i in  browserInfo){
                     LogUtil.info(i + ":" + browserInfo[i]);
                 }
            });

            if(!useLocalPlayer){
                loader.script(require.resolve("./SpeechJS/Adapter/JWPlayerAdapter"));
            }else{
                if(useAndroidAdapter){
                    loader.script(require.resolve("./SpeechJS/Adapter/AndroidPlayerAdapter"));
                }else{
                    loader.script(require.resolve("./SpeechJS/Adapter/SmartBookPlayerAdapter"));
                }
            }

            if(useAndroidAdapter){
                loader.script(require.resolve("./SpeechJS/Adapter/AndroidRecorderAdapter")).wait(callbackFun);
            }else{
                loader.script(require.resolve("./SpeechJS/Adapter/SpeechRecorderAdapter")).wait(callbackFun);
            }
        }
    }
});