﻿/// <reference path="../SpeechJS.js" />

/*
 * 文件名: AndroidPlayerAdapter.js
 * 描述: AndroidPlayer SpeechJS适配器
 *
 * 功能说明：
 * 和Android中的播放器进行交互，让JS可以调用Android来进行放音功能， Android回调JS通知放音进度、音量等
 *
 * 版本: 1.0.0.0
 * 作者: qingwu@iflytek.com
 * 日期：2013/8/5
 *
 * 变更记录：
 *
 */

(function (win) {

    /**
     * 电子书接收，用以判断Message消息来源
     * 电子书回调时应该与该值相等
     * @type {string}
     * @private
     */
    var MESSAGE_ORIGIN = 'AndroidPlayerAdapter';

    function AndroidPlayerAdapter(option) {
        var _this = this;
        var _audioUrl;
        window.addEventListener('message', function (e) {
            if (typeof e.data === "string") {
                e = eval('(' + e.data + ')');
            }
            if (!e || !e.data.evt || e.data.origin !== MESSAGE_ORIGIN)
                return;

            var playerEventType = e.data.evt;
            console.log('evt:' + e.data.evt);
            if (playerEventType == 'play_start') {
                var sndLen = e.data.data.duration;
                option.events.onPlayBegin && option.events.onPlayBegin.call(_this, {duration: sndLen});
            }
            else if (playerEventType == 'play_resume') {
                var sndLen = e.data.data.duration;
                option.events.onPlayBegin && option.events.onPlayBegin.call(_this, {duration: sndLen});
            }
            else if (playerEventType == 'play_pause') {
                option.events.onPause && option.events.onPause.call(_this);
            }
            else if (playerEventType == 'play_end') {
                console.log('playerEventType == play_end');
                option.events.onStop && option.events.onStop.call(_this);
            }
            else if (playerEventType == 'playing') {
				if (option.events.onPlaying) {
					var info = e.data.data;
					var playingParam = {
						position : parseFloat(info.duration / 1000),
						energy : parseInt(0)
					};
					option.events.onPlaying.call(_this, playingParam);
				}
            }
        }, false);

        /**
         * 加载音频
         * @param {String} url 音频url地址
         */
        this.__proxy__.loadAudio = function (url) {
            /// <summary>加载音频</summary>
            _audioUrl = url;
        };

        /**
         * 播放音频，需先调用loadAudio加载音频
         */
        this.__proxy__.play = function () {
            var msg = {evt: 'play', origin: MESSAGE_ORIGIN, data: {filePath: _audioUrl}};
            window.parent.postMessage(msg, '*');
        };

        /**
         * 播放区域音频
         * @param {Number} beginPos 音频开始位置(单位:ms)
         * @param {Number} endPos   音频结束位置(单位:ms)
         */
        this.__proxy__.playRange = function (beginPos, endPos) {
            var msg = {evt: 'playRange', origin: MESSAGE_ORIGIN, data: {begPos: beginPos, endPos: endPos}};
            window.parent.postMessage(msg, '*');
        };

        this.__proxy__.pause = function () {
            /// <summary>暂停音频</summary>
        };
        /**
         * 停止播放
         */
        this.__proxy__.stop = function () {
            var msg = {evt: 'stop', origin: MESSAGE_ORIGIN};
            window.parent.postMessage(msg, '*');
        };

        this.__proxy__.getVolume = function () {
            /// <summary>获取音量</summary>
        };

        this.__proxy__.setVolume = function (volume) {
            /// <summary>设置音量</summary>
            /// <param name="volume" value="Number">音量值 between 0 and 100</param>
        };

        this.__class__.check.call(this);

        // 模拟播放器准备完成事件
        setTimeout(function () {
            option.events.onReady && option.events.onReady.call(_this);
        }, 0);
    }

    AndroidPlayerAdapter.prototype = new SpeechJS.PlayerAdapterBase();
    AndroidPlayerAdapter.prototype.constructor = AndroidPlayerAdapter;
    win.AndroidPlayerAdapter = AndroidPlayerAdapter;

})(window);