/**
 * 遮盖罩
 * @module speechui/common/resource
 * @date 2013/06/21
 */

define(function(require, exports, module) {
    var baseUrl = require('./common');
    var $       = require('jquery');

    var picBase = baseUrl.getSpeechUIBase() + 'view/images/';
    var loadImg = [];
    for(var picNum=0; picNum<4; picNum++){
        loadImg[picNum] = new Image();
    }

    loadImg[0].src = picBase + 'loading_bgcent.gif';
    loadImg[1].src = picBase + 'loading_bgleft.gif';
    loadImg[2].src = picBase + 'loading_bgright.gif';
    loadImg[3].src = picBase + 'loading_icon.gif';

    /**
     * 显示或隐藏遮罩
     * @function
     * @param {{
     *     self    : object
     *     type    : string
     *     msg     : string
     *     lagTime : Number
     *     flag    : Boolean
     * }} options 遮盖罩加载参数
     */

    function showMask(options){

        var self     =  options.self,
            type     =  options.type,
            msg      =  options.msg,
            flag     =  options.flag,
            lagTime  =  options.lagTime ? options.lagTime : 0,
            maskName = ( (type === 'poetry' || type === 'dialogue')  ? 'word_mask' :
                         (type === 'fullScreen') ? 'word_mask' :
                         (type === self.maskType.top) ? 'top_mask' :
                         'word_mask'
                        );

        var speechuiUrl = baseUrl.getSpeechUIBase();
        if( flag === true ){
            var bh;
            var bw;
            var select;
            var strHtml = "<div class='" + maskName + "'></div>";
            var zIndex  = ( (type === 'poetry' || type === 'dialogue') ? 20 :
                            (type === 'fullScreen') ? 20 :
                            (type === self.maskType.top) ? 20 :
                             5
                           );

            $('.' + maskName + '_load').remove();
            $('.' + maskName).remove();

            if(type === 'dialogue' || type === 'poetry' || type == 'fullScreen'){
                select = $('body');
                bh = select.height();
                bw = select.width();
                select.append(strHtml);
            } else {
                bh = self.dom.height();
                bw = self.dom.width();
                self.dom.append(strHtml);
            }

            $('.' + maskName).css("background-color" , "dimgray")
                .css("filter"			, "alpha(opacity=50)"	)
                .css("opacity"			, "0.5"					)
                .css("position"			, "absolute"				)
                .css("top"				, "0"					)
                .css("-moz-opacity"		, "0.5"					)
                .css("-khtml-opacity"	, "0.5"					)
                .css("display"			, "none"				)
                .css("height"           ,  bh	                )
                .css("width"            ,  bw	                )
                .css("z-index"          ,  zIndex               )
                .css("margin-top"      ,   '0px'              )
                .show(lagTime);

            if(msg){
                var msgLenth = msg.length;
                var htmlLoad = "";
                var info = {};
                if( type === 'poetry' || type === 'dialogue' || type === self.maskType.common || type === self.maskType.top ) {
                    var imgSrc = speechuiUrl + "view/images/loading_icon.gif";
                    htmlLoad += "<div class='" + maskName + "_load'>";
                    htmlLoad += 	"<div style='position:absolute;margin-left:-32px;z-index:-1;'>";
                   // htmlLoad +=			"<img border='0' src ='" + speechuiUrl + "view/images/loading_bgleft.gif' width='10px' height='50px' >";
                    htmlLoad +=			"<img class='" + maskName + "_bgcent' border='0' src='" + speechuiUrl +"view/images/loading_bgcent.gif' height='50px'>";
                   // htmlLoad +=			"<img border='0' src ='" + speechuiUrl + "view/images/loading_bgright.gif' width='10px' height='50px'>";
                    htmlLoad +=		"</div>"
                    htmlLoad += 	"<b class='" + maskName + "_msg' style='font-size:14px;color:#fff;margin-left:-12px;height:50px;line-height:50px;vertical-align:middle;display:inline-block;'>" + msg + "</b>";
                    htmlLoad += 	"<img src='" + imgSrc + "' width='24' height='24'style='position:absolute;padding-top:13px;' />";
                    htmlLoad += "</div>";
                }
                if( type !== 'poetry' && type !== 'dialogue' && type === self.maskType.card ){
                    htmlLoad += "<div class='" + maskName + "_load'>";
                    htmlLoad +=     msg;
                    htmlLoad += "</div>";
                }
                type === 'poetry' ? $('body').append(htmlLoad) :
                type === 'dialogue' ? $('.pop_box').append(htmlLoad):
                self.dom.append(htmlLoad);

                if( type !== 'poetry' && type !== 'dialogue' && type === self.maskType.card){
                    info = {
                        "marginLeft"     : 0.07 * bw,
                        "filter"         : "alpha(opacity = 100)",
                        "opacity"        : "1",
                        "mozOpacity"     : "1",
                        "khtmlOpacity"   : "1",
                        "position"       : "absolute",
                        "zIndex"         : "10",
                        "top"            : 0.25 * bh,
                        "textAlign"      : "left",
                        "padding"        : "40px 50px 0 32px"
                    }
                }else{
                    var length = 0.4 * bw - msgLenth * 2;
                    info = {
                        "marginLeft"     : length,
                        "filter"         : "alpha(opacity = 70)",
                        "opacity"        : "0.7",
                        "mozOpacity"     : "0.7",
                        "khtmlOpacity"   : "0.7",
                        "position"       : "absolute",
                        "zIndex"         : "10",
                        "top"            : 0.4 * bh,
                        "textAlign"      : "center",
                        "padding"        : "110px 50px 0 32px"
                    }
                    info.zIndex = ( (type === 'poetry' || type === 'dialogue') ? 25 :
                                    (type === self.maskType.top) ? 25 :
                                    10
                                  );
                }

                if(type == 'dialogue'){
                    info.top = 0.2 * bh;
                }

                $('.' + maskName + '_load').css("margin-left"     , info.marginLeft     )
                    .css("filter"		  , info.filter	        )
                    .css("opacity"		  , info.opacity		)
                    .css("-moz-opacity"	  , info.mozOpacity		)
                    .css("-khtml-opacity" , info.khtmlOpacity   )
                    .css("position"		  , info.position		)
                    .css("z-index"		  , info.zIndex			)
                    .css("top"            , info.top            )
                    .css("text-align"     , info.textAlign      )
                    .css("padding"        , info.padding        );

                var realLength;
                var minLength = 15 * msgLenth + 40;
                if( type === 'poetry' || type === 'dialogue' || type === self.maskType.common ){
                    realLength = parseInt($(".word_mask_load").width() + 56);
                    realLength = realLength > minLength ? realLength : minLength;
                    $('.word_mask_bgcent').css("width" , realLength);
                } else {
                    realLength =  parseInt($(".top_mask_load").width() + 56);
                    realLength = realLength > minLength ? realLength : minLength;
                    $('.top_mask_bgcent').css("width" ,realLength);
                }
            }
        } else {
            $('.' + maskName + '_load').remove();
            $('.' + maskName).fadeOut(lagTime, function(){
                $(this).remove();
            });
        }
    }
    /**
     * @export {speechui.common.mask.showMask}
     */
    exports.showMask = showMask;
});