/**
 * PPT卡片
 * @module speechui/cards
 * @author cmma@iflytek.com
 * @date 2013/06/09
 */
define(function (require, exports, module) {

    var _cardbase = require('./cardbase');
    var _define = require('../define');
    var tplparse = require('../thirdparty/template');

    /**
     * 响应鼠标滑动翻的鼠标最小滑动距离
     * @type {number}
     */
    var SLIDINGDISTANCE_MIN = 8;

    /**
     * 画廊卡片类构造函数
     * @constructor
     * @param {{
     *     title: string,
     *     imageInfos: Array.<GalleryImageInfo>
     * }}   option 卡片ID
     *
     * @extends {speechui.cards.cardbase.CardBase}
     */
    function PPTCard(option) {
        if (!('imageInfos' in option)) {
            throw new Error('option Parameters!');
        }


        var _galleryObj = option;                               //图片信息集合
        var _dom;                                               //dom
        var _self = this;                                       //画廊卡片对象
        var _currIndex = 0;                                     //当前图片的索引
        var _imageEles;                                         //图片列表集合
        var _imageDes;                                          //图片描述信息的集合
        var _imageCount;                                        //图片的个数
        var _galleryImgdiv;
        var _eleImgs;

        /**
         *初始化画廊卡片
         */
        function init() {
            //取原始模版
            _self.getTemplate().done(function(tpl){
                for (var i = 0; i < _galleryObj.imageInfos.length; i++) {
                    var obj = _galleryObj.imageInfos[i];
                    obj.index++;
                }
                //对option对象的infoList排序
                _self._sortImgByIndex(_galleryObj.imageInfos);
                var html = tplparse.render(tpl, option);          //模版解析
                _dom = $(html);                                   //为防止卡片间相互影响，使用dom
                _self.dom = _dom;

                _galleryImgdiv = _dom.find('.btn_gallery_add');
                _eleImgs = _dom.find('.btn_gallery_add span img');
                _imageEles = _dom.find('.btn_gallery_add span');
                _imageDes = _dom.find('.gallery_ms p');
                _imageCount = _galleryObj.imageInfos.length;
                //初始化样式
                _self._showImages(0);
                _self._displayDes(0);

                $.each(_eleImgs, function (eleIdx, img) {
                    $(img).attr("style", "vertical-align: middle;");
                });

                setTimeout(function(){
                    _galleryImgdiv.css("height", _dom.height() - 140);
                    _eleImgs.css("height", _dom.height() - 152);
                    _eleImgs.css("maxWidth", "100%");
                },100);

                _bindEvents();
            });
        }

        /**
         * 事件绑定
         * @private
         */
        function _bindEvents() {
            // 上一张图片
            _dom.find('.btn_scene_prev').bind("tap",function () {
                _self.onPreImg();
            });

            // 下一张图片
            _dom.find('.btn_scene_next').bind("tap",function () {
                _self.onNexImg();
            });
        }

        /**
         * 上一张
         * @private
         */
        this.onPreImg = function () {
            if (_currIndex == 0) {
                return;
            } else {
                _currIndex = _currIndex - 1;
            }
            _self._showImages(_currIndex);
            _self._displayDes(_currIndex);
        }

        /**
         * 下一张
         * @private
         */
        this.onNexImg = function () {
            if (_currIndex == _imageCount - 1) {
                return;
            } else {
                _currIndex = _currIndex + 1;
            }
            _self._showImages(_currIndex);
            _self._displayDes(_currIndex);
        }

        /**
         *
         * @returns {Array.<jQuery>}
         * @private
         */
        this._getImageEles = function () {
            return  _imageEles;
        }

        /**
         *
         * @returns {Array.<jQuery>}
         * @private
         */
        this._getImageDes = function () {
            return  _imageDes;
        }

        /**
         *
         * @returns {jQuery}
         */
        this.getContent = function () {
            return  _dom;
        }

        init();
    }

    PPTCard.prototype = new _cardbase.CardBase();
    PPTCard.prototype.constructor = PPTCard;

    /**
     * 根据图片的index，用冒泡排序法进行排序
     * @param { Array.<GalleryImageInfo> } imgInfoArr 图片信息列表
     * @private
     */
    PPTCard.prototype._sortImgByIndex = function (imgInfoArr) {
        //外层循环，共要进行arr.length次求最大值操作
        for (var i = 0; i < imgInfoArr.length; i++) {

            //内层循环，找到第i大的元素，并将其和第i个元素交换
            for (var j = i; j < imgInfoArr.length; j++) {

                if (imgInfoArr[i].index > imgInfoArr[j].index) {
                    //交换两个对象的位置
                    var temp = imgInfoArr[i];
                    imgInfoArr[i] = imgInfoArr[j];
                    imgInfoArr[j] = temp;
                }
            }
        }
    }

    /**
     * 图片切换
     * @param {number} index
     */
    PPTCard.prototype._showImages = function (index) {

        var imageEles = this._getImageEles();

        $.each(imageEles, function (eleIdx, imageEle) {
            if (index == eleIdx) {
                $(imageEle).fadeIn(800);
                $(imageEle).css("display","block");
            } else if (index == 0) {
                $(imageEle).hide();
            } else {
                $(imageEle).hide();
            }
        });
    }

    /**
     * 显示匹配元素的描述信息
     * @param {number} index
     */
    PPTCard.prototype._displayDes = function (index) {
        /*
        var imageDes = this._getImageDes();

        $.each(imageDes, function (eleIdx, imageDes) {
            if (index == eleIdx) {
                $(imageDes).slideDown();
            } else {
                $(imageDes).hide();
            }
        });
        */
    }

    /**
     * 上一张图片
     * @protected
     */
    PPTCard.prototype.onPreImg = function () {
        var self = this;
    }

    /**
     * 下一张图片
     * @protected
     */
    PPTCard.prototype.onNexImg = function () {
        var self = this;
    }

    /**
     * @inheritDoc
     */
    PPTCard.prototype.getCardName = function () {
        return _define.CardName.PPT;
    };

    /**
     * @export
     */
    exports.Constructor = PPTCard;

});