﻿/**
 * 分类题模板
 * Created by hyt on 14-7-22.
 * @vision 1.0
 */
define(function (require, exports, module) {
    var _cardbase = require('./cardbase');
    var _define = require('../define');
    var tplparse = require('../thirdparty/template');

    function PickCard(option, currentheight, currentwidth) {
        if (!('items' in option)) {
            throw new Error('option Parameters!');
        }
        var _dom;
        var _self = this;
        var _status = 'conform'; // conform / clear
        var _h = '';

        /**
         *初始分类题卡片
         */
        function init() {
            _self.getTemplate().done(function (tpl) {
                option.options.sort(function () {
                    return 0.5 - Math.random(1)
                });

                for (var i = 0; i < option.options.length; i++) {
                    if (option.options[i].type === 'img') {
                        _h += '<li class="dragItem" style="background: #f2f4f3;"><span id="' + option.options[i].id + '"><img src="' + option.options[i].value + '" alt=""></span></li>'
                    } else {
                        _h += '<li class="dragItem" style="overflow: hidden; background: #f2f4f3;"><span id="' + option.options[i].id + '">' + option.options[i].value + '</span></li>'
                    }
                }
                tpl = tpl.replace("{{html}}", _h);
                var html = tplparse.render(tpl, option);          //模版解析
                _dom = $(html);                             //为防止卡片间相互影响，使用dom


                <!--动态设置样式-->
                //标题
                _dom.find('.class_fl_tit').css({'height': currentheight * 0.08 + 'px', 'line-height': currentheight * 0.08 + 'px'});

                _dom.find('.classified_box').css({'height': currentheight * 0.82 + 'px'});
                _dom.find('.display_box_group,.display_box_group li').css({'height': currentheight * 0.3 + 'px'});
                _dom.find('.display_box2,.display_box2 ul').css({'height': currentheight * 0.43 + 'px'});

                _dom.find(".display_box2 li").css("margin-right", currentwidth * 0.009 + "px");
                _dom.find('.pick_answ_ul').css({'height': 0.25 * currentheight + 'px'});
                _dom.find('.add_box').css({'line-height': 0.23 * currentheight + 'px'});


                // 分类框题框
                if (option.items.length == 2) {
                    _dom.find('.display_box_group li').css({'width': currentwidth * 0.4 + 'px', 'margin-left': currentwidth * 0.03 + 'px'});
                }
                if (option.items.length == 3) {
                    _dom.find('.display_box_group li').css({'width': currentwidth * 0.28 + 'px', 'margin-left': currentwidth * 0.015 + 'px'});
                }
                if (option.items.length == 4) {
                    _dom.find('.display_box_group li').css({'width': currentwidth * 0.21 + 'px', 'margin-left': currentwidth * 0.012 + 'px'});
                }

                // 绑定拖动的元素
                _dom.find(".dragItem").draggable({ revert: "invalid", containment: _dom.find(".classified_box")});
                _dom.find(".dropItem").droppable({
                    drop: function (event, ui) {
                        _status = 'conform';
                        _self.changeStatus();// 调整到核对答案状态
                        _dom.find(".display_box_list").each(function (i) {
                            $(this).parents("li").find(".i_fw").html('');
                        });

                        var dom = $('<li class="dragItem">' + ui.draggable[0].innerHTML + '</li>');

                        ui.draggable.remove();
                        $(this).parents('li').find('.add_box').hide();
                        $(this).append(dom);

                        var li_index = $(this).parents('li.display_box_g1').index();
                        var itemId = dom.find('span').attr('id');

                        _dom.find('li.display_box_g1').each(function (i) {
                            if (i !== li_index) {
                                $(this).find('.pick_answ_ul li>span').each(function (i) {
                                    if ($(this).attr('id') === itemId) {
                                        $(this).parent('li').remove();
                                    }
                                });
                            }
                        });
                        dom.draggable({ revert: "invalid", containment: _dom.find(".classified_box"),
                            start: function () {
                                dom.css('border', '2px solid #f3f3f3');
                            }
                        });
                    }
                });
            });

            // 核对答案
            _dom.find("#btn_conform").click(function () {
                var isAllRight = true;
                var pickNum = 0;

                if (_status == 'conform') {
                    _status = 'clear';
                    _self.changeStatus();

                    _dom.find(".display_box_g1").each(function (i) {
                        var isRight = true;
                        var num = 0;

                        _dom.find(".display_box_list:eq(" + i + ")").parents("li").find(".i_fw").html('');

                        _dom.find(".display_box_list:eq(" + i + ") li").each(function (j) {
//                            num++;
                            if (option.items[i].answer.indexOf(parseInt($(this).find("span").attr("id"))) >= 0) {
                                num++;
//                                $(this).addClass("li_right");
                            } else {
                                isRight = false;
                                isAllRight = false;
                                $(this).addClass("li_error");
                            }
                        });
                        if (isRight && num == option.items[i].answer.length) {
                            pickNum++;
                            _dom.find(".display_box_list:eq(" + i + ")").parents("li").find(".i_fw").html('<i></i>');
                        }
                    });

                    if (isAllRight && pickNum === option.items.length) {
                        _dom.find('.resultImg').attr('src', 'share/assert/images/congratulation.png');
                    } else {
                        _dom.find('.resultImg').attr('src', 'share/assert/images/encourage.png');
                    }

                    _dom.find('.resultImg').show().animate({"height": "86px", "bottom": "60px", "opacity": "1"}, 300);
                    setTimeout(function () {
                        _dom.find('.resultImg').animate({"height": "60px", "bottom": "60px", "opacity": "0"}, 300).hide();
                    }, 2000);


                } else {
                    // 清空答案
                    _status = 'conform';
                    _self.changeStatus();
                    var dom = $(_h);
                    _dom.find("#answer_cards").empty().append(dom);
                    _dom.find(".display_box2 li").css("margin-right", currentwidth * 0.009 + "px");
                    _dom.find(".dragItem").draggable({ revert: "invalid", containment: _dom.find(".classified_box")});
                    _dom.find(".display_box_list").each(function (i) {
                        $(this).empty();
                        $(this).parents("li").find(".i_fw").html('');
                    });
                }
            });
        }

        this.changeStatus = function () {
            if (_status == 'conform') {
                _dom.find("#btn_conform").html("核对答案");
            } else {
                _dom.find("#btn_conform").html("再来一次");
            }
        }

        this.getContent = function () {
            return _dom;
        }

        init(); //调用入口
    }

    PickCard.prototype = new _cardbase.CardBase();
    PickCard.prototype.constructor = PickCard;
    PickCard.prototype.getCardName = function () {
        return _define.CardName.Pickcard;
    };

    exports.Constructor = PickCard;
});
