﻿/**
 * 画廊卡片
 * @module speechui/cards
 * @author yuwang@iflytek.com
 * @date 2013/06/09
 */
define(function (require, exports, module) {
    var _cardbase = require('./cardbase');
    var _define = require('../define');
    var tplParser = require('../thirdparty/template');

    /**
     * 画廊卡片类构造函数
     * @constructor
     */
    function GalleryCard(option,domWidth,domHeight) {
        var _self = this;
        _self._galleryObj = option;
        _self._templateDom = null;
        _self._currIndex = 0;
        _self._imageEleOuterSpans = null;
        _self._imageDesEles = null;
        _self._imageCount = null;
        _self._imagePages = null;
        _self._imgAndDesContainer = null;
        _self._galleryImgdiv = null;
        _self._imgEles = null;

        /**
         *初始化画廊卡片
         */
        function init() {
            //取原始模版
            _self.getTemplate().done(function (tpl) {
                //给每张画廊图片赋值index
                for (var i = 0; i < _self._galleryObj.imageInfos.length; i++) {
                    var obj = _self._galleryObj.imageInfos[i];
                    obj.index = parseInt(obj.index)+1;
                }
                //对option对象的infoList排序
                _self._sortImgByIndex(_self._galleryObj.imageInfos);
                var tplHtml = tplParser.render(tpl, _self._galleryObj);
                _self._templateDom = $(tplHtml);

                _self._imgAndDesContainer = _self._templateDom.find('.imgAndDesContainer');
                _self._galleryImgdiv = _self._templateDom.find('.btn_gallery_add');
                _self._imgEles = _self._templateDom.find('.btn_gallery_add span img');
                _self._imageEleOuterSpans = _self._templateDom.find('.btn_gallery_add span');
                _self._imageDesEles = _self._templateDom.find('.gallery_ms p');
                _self._imagePages = _self._templateDom.find('.gallery_btn_group2 a');
                _self._imageCount = _self._galleryObj.imageInfos.length;

                //为了兼容以前已经制作好的、非固定大小的画廊卡片，做一些兼容处理
                _self._imgAndDesContainer.css({"height":domHeight-100+"px"});
                _self._galleryImgdiv.css({"height":domHeight-140+"px"});
                _self._imageEleOuterSpans.css({"height":domHeight-140+"px","lineHeight":domHeight-160+"px"});
                //初始化样式
                _self._showImages(0);
                _self._displayDes(0);
                _bindEvents();
            });
        }

        /**
         * 事件绑定
         * @private
         */
        function _bindEvents() {
            // 上一张图片
            _self._templateDom.find('.btn_scene_prev').bind("vclick", function () {
                _self.onPreImg();
            });

            // 下一张图片
            _self._templateDom.find('.btn_scene_next').bind("vclick", function () {
                _self.onNexImg();
            });

            // 按钮
            _self._templateDom.find(".gallery_btn_group2 a").bind("vclick", function () {
                var button = $(this);
                var imageIndex = button.index();
                _self._showImages(imageIndex);
                _self._displayDes(imageIndex);
            });
        }

        /**
         * 上一张
         * @private
         */
        this.onPreImg = function () {
            var desIndex = 0;
            if (_self._currIndex === 0) {
                return;
            } else {
                desIndex = _self._currIndex - 1;
            }
            _self._showImages(desIndex);
            _self._displayDes(desIndex);
        }

        /**
         * 下一张
         * @private
         */
        this.onNexImg = function () {
            var desIndex = 0;
            if (_self._currIndex === _self._imageCount - 1) {
                return;
            } else {
                desIndex = _self._currIndex + 1;
            }
            _self._showImages(desIndex);
            _self._displayDes(desIndex);
        }

        /**
         *
         * @returns {jQuery}
         */
        this.getContent = function () {
            return  _self._templateDom;
        }

        init();
    }

    GalleryCard.prototype = new _cardbase.CardBase();
    GalleryCard.prototype.constructor = GalleryCard;

    /**
     * 根据图片的index，用冒泡排序法进行排序
     * @param { Array.<GalleryImageInfo> } imgInfoArr 图片信息列表
     * @private
     */
    GalleryCard.prototype._sortImgByIndex = function (imgInfoArr) {
        //外层循环，共要进行arr.length次求最大值操作
        for (var i = 0; i < imgInfoArr.length; i++) {
            //内层循环，找到第i大的元素，并将其和第i个元素交换
            for (var j = i; j < imgInfoArr.length; j++) {
                if (imgInfoArr[i].index > imgInfoArr[j].index) {
                    //交换两个对象的位置
                    var temp = imgInfoArr[i];
                    imgInfoArr[i] = imgInfoArr[j];
                    imgInfoArr[j] = temp;
                }
            }
        }
    }

    /**
     * 图片切换
     * @param {number} index
     */
    GalleryCard.prototype._showImages = function (index) {
        var _self = this;
        _self._imageEleOuterSpans.hide();
        _self._imageEleOuterSpans.eq(index).show();
        _self._imagePages.removeClass("gbg_active2");
        _self._imagePages.eq(index).addClass("gbg_active2");
        _self._currIndex = index;
    }

    /**
     * 显示匹配元素的描述信息
     * @param {number} index
     */
    GalleryCard.prototype._displayDes = function (index) {
        var _self = this;
        _self._imageDesEles.hide();
        _self._imageDesEles.eq(index).show();
    }

    /**
     * @inheritDoc
     */
    GalleryCard.prototype.getCardName = function () {
        return _define.CardName.Gallery;
    };

    /**
     * @export
     */
    exports.Constructor = GalleryCard;

});