/**
 * 全局变量模块，暂存一些会在各模块中用到的变量
 */
define(function (require, exports) {

    var path = require('./path');

    var AppContext = {};

    //播放状态下的运行环境
    AppContext.RunningPlatform={
        NodeWebkit:"NodeWebkit",
        CEF:"CEF",
        Android:"Android",
        Web:"Web"
    }

    //记录播放状态下的页面宽高
    AppContext.containerOffset={width:0,height:0};

    //记录播放状态下的页面整体缩放比例
    AppContext.zoomRate={x:1,y:1};

    //记录播放状态下每页的笔迹base64
    AppContext.strokeBase64Arr=[];

    //记录新建页名称和背景对应关系
    AppContext.newBlankSlides=[];

    //记录当前页是否为新建页
    AppContext.isCurNewBlankSlide = false;

    //标记是否为单个widget播放模式
    AppContext.isSingleWidgetPlayMode = false;
    //标记单个widget播放的当前类型
    AppContext.singleWidgetType = "";
    //标记单个widget播放的卡片路径
    AppContext.singleWidgetPath = "";
    //标记单个widget播放的路由地址
    AppContext.singleWidgetRouteAddress="";

    //标记编辑状态下右键点击的对象（每一次右键点击都会变化）
    AppContext.rightClicked = null;
    //标记编辑状态下点击了复制的对象
    AppContext.selectedCopyTarget = null;
    //标记复制对象的动画信息
    AppContext.oldAnimationInfo = null;
    //标记粘贴次数，用来计算粘贴后的位置
    AppContext.pasteTimes = 0;
    //包的名称，通过setPackageName(name)方法更改当前包的名称，
    AppContext.packageName = "lotuspackage";

    /**
     * 设定当前课件包名称
     * @param name{string} 当前课件包的名称
     */
    AppContext.setPackageName = function (name) {
        if (name) {
            AppContext.packageName = name;
        }
    };

    //包的位置，例如SlideApp/client/main/lotuspackage
    AppContext.packagePath = "";

    //binPath是程序的根目录，目前是SlideApp/client文件夹
    AppContext.getBinPath = function () {
        //修复盘符小写的bug   ----luxing
        var binPath = path.resolve("./");
        var diskStr = binPath.substr(0,binPath.lastIndexOf(":\\"));
        var DiskStr = diskStr.toUpperCase();
        binPath = binPath.replace(diskStr,DiskStr);
        return binPath;
    };

    AppContext.getLauncherPath = function(){
        return AppContext.getBinPath().replace("bin\\main","iFlySlide.exe");
    };

    AppContext.getNWPath = function(){
        return AppContext.getBinPath().replace("main","nw.exe");
    };

    //包的位置，例如SlideApp/client/main/lotuspackage
    AppContext.getCurSlidePackPath = function () {
        return AppContext.packagePath;
    };

    //设置包的位置
    AppContext.setCurSlidePackPath = function (url, isDebug) {
        url = path.toPosix(url);
        if (!isDebug) {
            AppContext.packagePath = url;
        } else {
            AppContext.packagePath = url.substr(0, url.lastIndexOf("/"));
        }
    };

    // 临时包的位置，例如SlideApp/client/main/tmp
    AppContext.getTmpPackPath = function () {
        return path.join(AppContext.getBinPath(), "tmp");
    };

    //课件包的描述文件manifest.json的位置，例如SlideApp/client/main/lotuspackage/manifest.json
    AppContext.getPackageJsonPath = function () {
        return path.join(AppContext.getCurSlidePackPath(), "/manifest.json");
    };


    //课件包的缩略图thumbnail.jpg的位置，例如SlideApp/client/main/lotuspackage/thumbnail.jpg
    AppContext.getPackageThumbPath = function () {
        return path.join(AppContext.getCurSlidePackPath(), "/thumbnail.jpg");
    };

    //默认图片保存的位置
    AppContext.getDefaultImagePath = function(){
       return path.join(this.getBinPath(),"/share/assert/images");
    };

    //默认模板位置
    AppContext.getDefaultTemplate = function(){
        return path.join(this.getBinPath(),"/template");
    }

    //测验试填卡片位置
    AppContext.getExerciseExamplePath = function(){
        return path.join(this.getBinPath(),"/template/exerciseExample/slides/1.sco");
    }

    //组合路径
    AppContext.joinPath = function()
    {
        return path.join.apply(this,arguments);
    }

    //svg目录
    AppContext.getSVGPath = function()
    {
        return this.joinPath(this.getBinPath(),'editor/assert/svg');
    }

    //插件目录
    AppContext.pluginPath = function()
    {
        var _s = this.getBinPath();
        _s = _s.substr(0,_s.lastIndexOf('\\')+1);
        return _s;
    }

    if(RunningPlatform ==="NodeWebkit"){
        AppContext.setCurSlidePackPath(path.join(AppContext.getBinPath(), AppContext.packageName), false);
    }

    if(RunningPlatform ==="Android"){
        AppContext.setCurSlidePackPath(AppContext.packageName, false);
    }

    //
    AppContext.getFontWidth = function(fontSize,str)
    {
        var span = document.getElementById("__getwidth");
        if (span == null) {
            span = document.createElement("span");
            span.id = "__getwidth";
            document.body.appendChild(span);
            span.style.visibility = "hidden";
            span.style.whiteSpace = "nowrap";
        }
        span.innerText = str;
        span.style.fontSize = fontSize + "px";

        return span.offsetWidth;
    }

    /**
     * 拷贝对象
     * @param fromObj
     */
    AppContext.clone = function(fromObj){
        if(typeof(fromObj) != 'object') return fromObj;
        if(fromObj == null) return fromObj;

        var myNewObj = new Object();
        for(var i in fromObj)
            myNewObj[i] = AppContext.clone(fromObj[i]);

        return myNewObj;
    }

    exports.AppContext = AppContext;
});