/**
 * Created with JetBrains WebStorm.
 * User: dfwang
 * edit: jhwang
 * 可以在下面URL修改播放器的样式
 * http://designer.videojs.com/
 * Date: 14-7-15
 * Time: 下午8:14
 * To change this template use File | Settings | File Templates.
 */
define(function (require, exports) {
    var IOUtil;
    if (RunningPlatform === "NodeWebkit") {
        IOUtil = require("../../../../share/assert/js/ioutil_desktop.js").IOUtil;
    }
    else if (RunningPlatform === "Android") {
        IOUtil = require("../../../../share/assert/js/ioutil_android.js").IOUtil;
    }
    else if (RunningPlatform === "CEF") {
        IOUtil = require("../../../../share/assert/js/ioutil_cef.js").IOUtil;
    }
    else {
        IOUtil = require("../../../../share/assert/js/ioutil_web.js").IOUtil;
    }

    function isSupportH264() {
        if (Modernizr.video && Modernizr.video.h264) {
            return true;
        }
        return false;
    }


    fabric.Video.prototype.getRenderDOM = function (relatedResPath) {
        var def = $.Deferred();
        var _self = this;

        function getSourceDom(path) {
            var _str = '';
            switch (getExtName(path)) {
                case "mp4":
                    _str = '<source src="' + path + '" type="video/mp4" />'
                    break
                case "ogg":
                    _str = '<source src="' + path + '" type="video/ogg" />'
                    break
                case "webm":
                    _str = '<source src="' + path + '" type="video/webm" />'
                    break
            }
            return _str;
        }

        //获取扩展名
        function getExtName(url) {
//        var result =/\.[^\.]+/.exec(url);
            var _name = null;
            _name = url.split(".");
            _name = _name[_name.length - 1];
            return _name.toLowerCase();
        };

        if (getExtName(relatedResPath) === 'swf') {

            var _dom = null;
            if(RunningPlatform === "Android")
            {
                _dom = $('<div videoType="flash" class="flashDiv" style="position: relative;left: 0px;top: 0px;">' +
                    '<img style="width: 100%;height: 100%;" src="'+this.src+'">'+
                    '</div>');
                _dom.click(function(){
                    window.commInterface.openSwfFile(relatedResPath,0);
                });
            }else{
                _dom = $('<div videoType="flash" class="flashDiv" style="position: relative;left: 0px;top: 0px;">' +
                    '<div style="position: relative;width: 100%;height: 100%">' +
                    '<embed id="example_video_1" wmode="opaque" class="video-js vjs-default-skin"  width="100%" height="100%" src="' + relatedResPath + '">' +
                    '</div>' +
                    '</div>');
           }
            console.log(_dom);
            def.resolve(_dom);

        } else {
            //if (RunningPlatform === 'CEF') {
                var _dom = $('<video width="100%" height="100%" poster="' + _self.src + '" src="'+relatedResPath+'" controls="controls"></video>');
                def.resolve(_dom);


        }

        return def.promise();
    };
});