/**
 * Created with JetBrains WebStorm.
 * User: Cmma
 * Date: 7/10/14
 * Time: 2:54 PM
 * To change this template use File | Settings | File Templates.
 */
define(function(require, exports) {
    var PPTCard=require("../../../../share/assert/js/cloudcard/js-debug/speechui/code/cards/pptcard").Constructor;
    var IOUtil;
    if (RunningPlatform === "NodeWebkit") {
        IOUtil = require("../../../../share/assert/js/ioutil_desktop.js").IOUtil;
    }
    else if (RunningPlatform === "Android") {
        IOUtil = require("../../../../share/assert/js/ioutil_android.js").IOUtil;
    }
    else if (RunningPlatform === "CEF") {
        IOUtil = require("../../../../share/assert/js/ioutil_cef.js").IOUtil;
    }
    else{
        IOUtil = require("../../../../share/assert/js/ioutil_web.js").IOUtil;
    }
    fabric.PPT.prototype.getRenderDOM = function(relateResPath) {
        console.log('ppt getcardoptions');
        var def = $.Deferred();
        this.getCardOptions(relateResPath).done(function(cardOptions){
            //console.log(option,cardOptions);

            var pptCard = new PPTCard(cardOptions);

            var pptCardDiv = pptCard.getContent();

            def.resolve(pptCardDiv);
        });
//        var dom='<div>xxxxx</div>';
//        def.resolve(dom);
        return def.promise();
    };

    fabric.PPT.prototype.getCardOptions = function(relateResPath) {

        console.log('ppt getcardoptions');
        var def = $.Deferred();

        IOUtil.readFile(relateResPath + "/meta.json").done(function(jsonStr) {
            var jsonObj = JSON.parse(jsonStr);
            var speechUIDir = "./share/assert/js/cloudcard/js-debug/speechui/";
            var cardOptions = {"title":jsonObj.title,"speechUIDir":speechUIDir, "des": jsonObj.des};
            cardOptions.imageInfos = [];
            for(var i = 0; i < jsonObj.images.length; i++) {
                var imageInfo = {};
                imageInfo.index = i;
                imageInfo.dex = "";
                imageInfo.imgUrl = relateResPath + "/" + jsonObj.images[i];

                cardOptions.imageInfos.push(imageInfo);
            }
            def.resolve(cardOptions);
        });

//        var dom='<div>xxxxx</div>';
//        def.resolve(dom);
        return def.promise();
    }
})