/**
 * 分类题播放
 * Created by hyt on 14-7-22.
 * @vision 1.0
 */
define(function (require, exports) {
    var Pickcard = require("../../../../share/assert/js/cloudcard/js-debug/speechui/code/cards/pickcard").Constructor;
    var IOUtil;
    if (RunningPlatform === "NodeWebkit") {
        IOUtil = require("../../../../share/assert/js/ioutil_desktop.js").IOUtil;
    }
    else if (RunningPlatform === "Android") {
        IOUtil = require("../../../../share/assert/js/ioutil_android.js").IOUtil;
    }
    else if (RunningPlatform === "CEF") {
        IOUtil = require("../../../../share/assert/js/ioutil_cef.js").IOUtil;
    }
    else {
        IOUtil = require("../../../../share/assert/js/ioutil_web.js").IOUtil;
    }
    var AppCtx = require("../../../../share/assert/js/appcontext").AppContext;

    fabric.Pickcard.prototype.getRenderDOM = function (relatedResPath) {
        var _dom;
        var _self = this;
        var def = $.Deferred();
        this.getCardOptions(relatedResPath).done(function (cardOptions) {
//            var ctxZoomX = AppCtx.zoomRate.x;
//            var ctxZoomY = AppCtx.zoomRate.y;
//
//            var zoomX = ctxZoomX * _self.scaleX;
//            var zoomY = ctxZoomY * _self.scaleY;

//            if(zoomX < 1 || zoomY < 1){
                var pickcard = new Pickcard(cardOptions,_self.height, _self.width);
//            }else{
//                var pickcard = new Pickcard(cardOptions,_self.currentHeight*AppCtx.zoomRate.y, _self.currentWidth*AppCtx.zoomRate.x);
//            }

            var pickcardDiv = pickcard.getContent();
            _dom = pickcardDiv;
            def.resolve(_dom);
        });
        return def.promise();
    }

    fabric.Pickcard.prototype.getCardOptions = function (relatedResPath) {
        var def = $.Deferred();
        IOUtil.readFile(relatedResPath + "/meta.json").done(function (jsonStr) {
            var jsonObj = JSON.parse(jsonStr);
            for (var i = 0; i < jsonObj.items.length; i++) {
                if (jsonObj.items[i].title === '') {
                    jsonObj.items[i].title = '分类框'+(i+1);
                }
            }
            for (var i = 0; i < jsonObj.options.length; i++) {
                if (jsonObj.options[i].type === 'img') {
                    jsonObj.options[i].value = relatedResPath + "/" + jsonObj.options[i].value;
                }
            }
            def.resolve(jsonObj);
        });
        return def.promise();
    }

});