/**
 * Created by ythuang on 14-6-27.
 */
define(function (require, exports) {
    var HistoryCard = require("../../../../share/assert/js/cloudcard/js-debug/speechui/code/cards/history").Constructor;
    var IOUtil;
    if (RunningPlatform === "NodeWebkit") {
        IOUtil = require("../../../../share/assert/js/ioutil_desktop.js").IOUtil;
    }
    else if (RunningPlatform === "Android") {
        IOUtil = require("../../../../share/assert/js/ioutil_android.js").IOUtil;
    }
    else if (RunningPlatform === "CEF") {
        IOUtil = require("../../../../share/assert/js/ioutil_cef.js").IOUtil;
    }
    else {
        IOUtil = require("../../../../share/assert/js/ioutil_web.js").IOUtil;
    }
    var AppCtx = require("../../../../share/assert/js/appcontext").AppContext;

    fabric.History.prototype.getRenderDOM = function (relatedResPath) {
        var _dom;
        var def = $.Deferred();
        var _this = this;
        var _scale = AppCtx.zoomRate.y

        this.getCardOptions(relatedResPath).done(function (cardOptions) {
            var ctxZoomX = AppCtx.zoomRate.x;
            var ctxZoomY = AppCtx.zoomRate.y;

            var zoomX = ctxZoomX * _this.scaleX;
            var zoomY = ctxZoomY * _this.scaleY;

//            if(zoomX < 1 || zoomY < 1){
            var historyCard = new HistoryCard(cardOptions, _this.height, _this.width);
//            }else{
//                var historyCard = new HistoryCard(cardOptions,_this.currentHeight*AppCtx.zoomRate.y, _this.currentWidth*AppCtx.zoomRate.x);
//            }

            var historyDiv = historyCard.getContent();
            _dom = historyDiv;
//            console.log(_dom);
            def.resolve(_dom);
        });
        return def.promise();
    }

    fabric.History.prototype.getCardOptions = function (relatedResPath) {
        var def = $.Deferred();
        IOUtil.readFile(relatedResPath + "/meta.json").done(function (jsonStr) {
            //fix���з�����
            jsonStr = jsonStr.replace(/\n/g, '\\n');
            var jsonObj = JSON.parse(jsonStr);
            for (var i = 0; i < jsonObj.items.length; i++) {

                if (jsonObj.items[i].img != '' && jsonObj.items[i].img != null) {
                    jsonObj.items[i].img = relatedResPath + '/' + jsonObj.items[i].img;
                }

            }
            console.log(jsonObj);
            def.resolve(jsonObj);
        });

        return def.promise();
    }
});