/**
 * 画廊播放模块
 * Date: 2014/06/30
 * Author: luxing@iflytek.com
 * @version 1.0
 * @module gallery.play
 */
define(function (require, exports) {
    var GalleryCard = require("../../../../share/assert/js/cloudcard/js-debug/speechui/code/cards/gallery").Constructor;
    var IOUtil;
    if (RunningPlatform === "NodeWebkit") {
        IOUtil = require("../../../../share/assert/js/ioutil_desktop.js").IOUtil;
    }
    else if (RunningPlatform === "Android") {
        IOUtil = require("../../../../share/assert/js/ioutil_android.js").IOUtil;
    }
    else if (RunningPlatform === "CEF") {
        IOUtil = require("../../../../share/assert/js/ioutil_cef.js").IOUtil;
    }
    else {
        IOUtil = require("../../../../share/assert/js/ioutil_web.js").IOUtil;
    }
    fabric.Gallery.prototype.getRenderDOM = function (relatedResPath) {
        var def = $.Deferred();
        var _self = this;
        this.getCardOptions(relatedResPath).done(function (cardOptions) {
            //console.log(option,cardOptions);
            var domWidth = _self.width;
            var domHeight = _self.height;
            var galleryCard = new GalleryCard(cardOptions,domWidth,domHeight);
            _self.galleryCard = galleryCard;
            var galleryDiv = galleryCard.getContent();
            def.resolve(galleryDiv);
        });
        return def.promise();
    };

    fabric.Gallery.prototype.getCardOptions = function (relatedResPath) {
        var def = $.Deferred();
        IOUtil.readFile(relatedResPath + "/meta.json").done(function (jsonStr) {
            //jsonStr = decodeURI(jsonStr);
            //console.log(jsonStr);
            var jsonObj = JSON.parse(jsonStr);
            var cardOptions = {"title": jsonObj.title};
            cardOptions.imageInfos = [];
            for (var i = 0; i < jsonObj.images.length; i++) {
                var imageInfo = {};
                imageInfo.index = jsonObj.images[i].index;
                imageInfo.des = jsonObj.images[i].des;
                imageInfo.imgUrl = relatedResPath + "/" + jsonObj.images[i].src;

                cardOptions.imageInfos.push(imageInfo);
            }
            def.resolve(cardOptions);
        });

        return def.promise();

    }
});