/**
 * Created by feiqian on 2014/7/17.
 */

define(function (require, exports, module) {

    var Exercise = require("../../../../share/assert/js/cloudcard/js-debug/speechui/code/cards/exercise").Constructor;
    var IOUtil;
    if (RunningPlatform === "NodeWebkit") {
        IOUtil = require("../../../../share/assert/js/ioutil_desktop.js").IOUtil;
    }
    else if (RunningPlatform === "Android") {
        IOUtil = require("../../../../share/assert/js/ioutil_android.js").IOUtil;
    }
    else if (RunningPlatform === "CEF") {
        IOUtil = require("../../../../share/assert/js/ioutil_cef.js").IOUtil;
    }
    else {
        IOUtil = require("../../../../share/assert/js/ioutil_web.js").IOUtil;
    }
    fabric.Exercise.prototype.getRenderDOM = function (relatedResPath) {
        var def = $.Deferred();
        var left = this.left, top = this.top;
        this.getCardOptions(relatedResPath).done(function (cardOptions) {
            var exercise = new Exercise(cardOptions);
            exercise.showPanel(left, top).done(function () {
                var content = exercise.getContent();
                setTimeout(function () {
                    //content[0].style.height = null;
                    content = null;
                }, 100);
                def.resolve(content);
            });
        });
        return def.promise();
    };

    fabric.Exercise.prototype.getCardOptions = function (relatedResPath) {
        var def = $.Deferred();
        IOUtil.readFile(relatedResPath + "/meta.json").done(function (jsonStr) {
            jsonStr = jsonStr.replace(/\n/g, '\\n');
            var jsonObj = JSON.parse(jsonStr);
            for (var i = 0; i < jsonObj.items.length; ++i) {
                var item = jsonObj.items[i];
                for (var j = 0; j < item.options.length; ++j) {
                    var option = item.options[j];
                    if (option.type == 'img') {
                        option.value = relatedResPath + "/" + option.value;
                    }
                }
                if (item.thumbNail) {
                    item.thumbNail = relatedResPath + "/" + item.thumbNail;

                }
            }
            def.resolve(jsonObj);
        });

        return def.promise();

    };
});

