/**
 * 中文评测卡片播放模块
 * Date: 2014/07/14
 * Author: luxing@iflytek.com
 * @version 1.0
 * @module cneval.play
 */
define(function(require, exports) {
    var IOUtil;
    if (RunningPlatform === "NodeWebkit") {
        IOUtil = require("../../../../share/assert/js/ioutil_desktop.js").IOUtil;
    }
    else if (RunningPlatform === "Android") {
        IOUtil = require("../../../../share/assert/js/ioutil_android.js").IOUtil;
    }
    else if (RunningPlatform === "CEF") {
        IOUtil = require("../../../../share/assert/js/ioutil_cef.js").IOUtil;
    }
    else{
        IOUtil = require("../../../../share/assert/js/ioutil_web.js").IOUtil;
    }
    fabric.CnEval.prototype.getRenderDOM=function(relatedResPath){
        var iframeID;
        window.gSpeechCardLoadReady = false;
        var intervalID=0;
        var def = $.Deferred();
        this.getCardOptions(relatedResPath).done(function(cardOptions){
            console.log(cardOptions);
            var cardContainerDiv = $("<div></div>");
            iframeID="cardFrm"+new Date().getTime();
            var cardIframe = $('<iframe src="./share/assert/js/cloudcard/index.html" frameborder="0" width="100%" height="100%"></iframe>')
            cardIframe.attr("id",iframeID);
            cardContainerDiv.append(cardIframe);
            cardIframe[0].onload = function(){
                console.log("load iframe finish!!!");
                sendMessage(cardIframe[0],{evt:'loadCard', data:cardOptions, RunningPlatform:window.RunningPlatform});
            };
            /*
            function checkLoaded(){
                console.log(gSpeechCardLoadReady);
                if(window.gSpeechCardLoadReady){
                    window.gSpeechCardLoadReady=false;
                    def.resolve(cardContainerDiv);
                }else{
                    setTimeout(checkLoaded,200);
                }
            }
            setTimeout(checkLoaded,200);
            */

            if (RunningPlatform === "Android") {
                def.resolve(cardContainerDiv);
            }
            else{
                setTimeout(function(){
                    def.resolve(cardContainerDiv);
                },500);
            }
        });
        return def.promise();
    };

    fabric.CnEval.prototype.getCardOptions=function(relatedResPath){
        var def = $.Deferred();
        IOUtil.readFile(relatedResPath+"/meta.json").done(function(jsonStr){
            jsonStr = jsonStr.replace(/\n/g,"");
            var cardInfo = JSON.parse(jsonStr);

            var wordsArr=cardInfo.words;
            var constFilePath = relatedResPath+"/";
            var audioPaths = new Array();
            var words=new Array();
            var wordsType = 1; // 单字
            var paperContent = "";

            var pyPath = constFilePath + cardInfo.py;
            IOUtil.readFile(pyPath).done(function(pyfile){
                paperContent = pyfile;

                for (var i = 0; i < wordsArr.length; i++) {
                    var audioPath = constFilePath.replace("file:/","") + wordsArr[i].audio;
                    words.push(wordsArr[i].word);
                    if (words[i].length > 1) {
                        wordsType = 2;  //词
                    }
                    audioPaths[i] = audioPath;
                }
                paperContent = paperContent.replace(/\0/g, "").replace(/\r\n/g,"\n");

                var options = {
                    paperContent: paperContent,
                    audios: audioPaths,
                    isSyllable: wordsType == 1
                };

                var cardOptions={"cardName":"cnwordeval","options":options};
                def.resolve(cardOptions);
            });
        });

        return def.promise();
    }

    function sendMessage(cardIframe,msg)
    {
        //var ifr = document.getElementById(iframeID);
        msg = JSON.stringify(msg);
        var targetOrigin = '*';
        cardIframe.contentWindow.postMessage(msg, targetOrigin);
    }
});