/**
 * Created by feiqian on 2014/7/18.
 */

define(function(require,exports,module){

    /**
     * 在一个JSON对象中查找某个属性并设置该属性的值
     * @param {object} obj JSON对象
     * @param {string} name  搜索条件
     * @param {boolean=} bRepeat 是否重复查找
     * @param value 要重新设置的值,也可以是Function
     * @returns {*}
     */

    JSON.setValueByAttrName=function(obj,name,bRepeat,value)
    {
        if(value==undefined) return;
        var result= this.getObjectByAttrName(obj,name,bRepeat);
        if(result){
            var key=name.split(",");
            key=key[key.length-1];
            if(key[0]=='>') key=key.substr(1);
            key = key.split("&")[0].split("=")[0];
            if(result instanceof Array) {
                for(var i= 0,len=result.length;i<len;++i){
                   if(value instanceof Function){
                       value(result[i]);
                   }
                   else result[i][key]=value;
                }
            }
            else result[key]=value;
            return result;
        }
        return false;
    };


    function _isEqual(obj,condition,value){
        var temp = condition.split("=");
        var name= temp[0];
        if(name[0]=='>') name=name.substr(1);
        value= value||temp[1];
        if (obj[name]!=undefined) {
            if (value == undefined || obj[name] == value){
                return true;
            }
        }
        return false;
    }


    /**
     * 在一个JSON对象中查找某个属性并得到包含该属性的对象
     * @param obj JSON对象
     * @param name  属性名
     * @param bRepeat 是否重复查找
     * @returns {*}
     * @private
     */

    JSON.getObjectByAttrName=(function(){

        function _getObjectByAttrName(obj,name,bRepeat,value){
            if (!obj || !name) return null;
            var result= [] ;
            var condition = name.split(",");

            var _self = arguments.callee;

            if (condition.length === 1) {
                var bContinue=true;

                condition[0]  = condition[0].split("&");
                for(var i= 0,len = condition[0].length;i<len;++i){
                    var temp2 =_isEqual(obj,condition[0][i],value);
                    if (temp2) {
                        if(i==len-1) {
                            result=result.concat(obj);
                            bContinue = bRepeat;
                        }
                    }
                    else break;
                }

                if(bContinue){
                    if(obj instanceof  Array){
                        for(var i= 0,len=obj.length;i<len;++i){
                            var data = obj[i];
                            if (typeof data === 'object') {
                                var temp = _self.apply(this, [data, name, bRepeat,value]);
                                if (temp) {
                                    result=result.concat(temp);
                                    if(!bRepeat) break;
                                }
                            }
                        }
                    }
                    else if (obj instanceof Object) {
                        for (var key in obj) {
                            var data = obj[key];
                            if (typeof data === 'object') {
                                var temp = _self.apply(this, [data, name, bRepeat,value]);
                                if (temp) {
                                    result=result.concat(temp);
                                    if(!bRepeat) break;
                                }
                            }
                        }
                    }
                }
            }
            else
            {
                var tempData = [[obj]];
                for (var i = 0, len = condition.length; i < len; ++i) {
                    if(!tempData[i]) break;
                    for(var j= 0,len2=tempData[i].length;j<len2;++j){
                        if (result&&result.length&&!bRepeat) break;
                        var obj=tempData[i][j],key;

                        key = condition[i];

                        var temp = _self.apply(this, [obj, key, bRepeat,(i==len-1)?value:undefined]);
                        if (temp) {
                            if(i!=len-1)  {
                                tempData[i+1]=[];
                                tempData[i+1]=tempData[i+1].concat(temp);
                                for(var k = 0,len3=tempData[i+1].length;k<len3;++k){
                                    var index = condition[i+1][0]=='>'?true:false;
                                    if(index){
                                        if(key[0]=='>')  key=key.substr(1);
                                        key=key.split("&")[0].split("=")[0];
                                        tempData[i+1][k]=tempData[i+1][k][key];
                                        condition[i+1]=condition[i+1].substr(1);
                                    }
                                }
                            }
                            else result=result.concat(temp);
                        }
                    }
                }
            }
            return result?(result.length?(bRepeat?result:result[0]):null):null;
        }

        return function(obj,name,bRepeat){
            return _getObjectByAttrName(obj,name,bRepeat);
        }
    })();

    /**
     * 在一个JSON对象中查找某个属性并得到该属性的值
     * 现在的搜索条件支持以下四种格式(搜索的对象满足:)
     * “a,b,c” ： 具有c属性,且拥有b属性或者是拥有b属性的对象的子节点，b和a的关系以此类推
     * “a,>b,c” ： 具有c属性,且是拥有b属性的对象的子节点
     * “a,b=xx,c” ： 具有c属性,且拥有b属性或者是拥有b属性的对象(并且该对象的b属性的值等于xx)的子节点
     * “a,b=xx&c=xx&d,”拥有a属性，拥有对象：拥有b属性=xx,拥有c=xx,且拥有d属性
     * @param {object} obj    JSON对象
     * @param {string} name     搜索条件
     * @param {boolean=} bRepeat 是否重复搜索
     * @returns {*}
     */
    JSON.getValueByAttrName=function(obj,name,bRepeat){
        var obj=this.getObjectByAttrName(obj,name,bRepeat);
        if(obj) {
            var key = name.split(",");
            key= key[key.length-1];
            if(key[0]=='>') key=key.substr(1);
            key = key.split("&")[0].split("=")[0];
            if(bRepeat){
                var data=[];
                for(var i= 0,len=obj.length;i<len;++i)
                    data[i]=obj[i][key];
                obj=data;
            }
            else obj=obj[key];
        }
        return obj;
    };

});
