/**
 * Created by feiqian on 2014/7/16.
 */

define(function(require,exports,module){

    function ExerciseItem(type,subject,title,options){
       this.setType(type);
       this.setSubject(subject);
       this.setTitle(title);
       this.setOptions(options);
       this.answer = [];
    }

    ExerciseItem.prototype.setType = function(type){
        this.type = type;
    };

    ExerciseItem.prototype.setTitle= function(title){
        if(!title) return;
        if(title == '点击此处添加测验题目') title="";
        this.title = title;
    };

    ExerciseItem.prototype.setOptionsNum= function(num){
        if(!this.options) this.options = [];
        var i= this.options.length;
        if(i<num){
            for(;i<num; ++i){
                this.options[i]={
                    type:'',
                    value:''
                };
            }
        }
        else if(i>num){
            this.options = this.options.slice(0,num);
        }

    };

    ExerciseItem.prototype.setOptions= function(answer,type,index){
        if(!answer ) return;
        if(!type) {
            this.options = answer;
            return;
        }
        var _self = this;
        if(!index && answer.length){
            $.each(answer,function(i,value){
                _self.options[i] = {
                    type: type,
                    value :  value=='点击此处添加答案'?'':value
                };
            });
        }
        else {
            if(index){
                _self.options[index] = {
                    type: type,
                    value :  answer
                };
            }
        }
    };

    ExerciseItem.prototype.setSubject= function(subject){
        if(!subject) return;
        if(subject == '请输入标题') subject="";
        this.subject = subject;
    };

    ExerciseItem.prototype.getCompleteInfo = function(){
        var _self = this;
        var errMsg = "";
//        if(!this.subject)  errMsg= "请输入标题";
//        else
        if(!this.title)  errMsg =  "请添加测验题目";
        else if(!this.answer || !this.answer.length) errMsg = "请设定题目的答案";
        else if(this.type === "3" &&(!this.thumbNail || !this.thumbNail.length)) errMsg = "请添加本题对应的图片";
        else {
            $.each(this.options,function(i,data){
                if(!data.value ||(_self.type ==="2" && data.value ==="editor/assert/images/btn_gallery_add.jpg")) {
                    errMsg = "请设定答案选项";
                    return false;
                }
            });
        }
        return errMsg;
    };

    ExerciseItem.prototype.setAnswer = function(answer){
        this.answer = answer;
    };

    ExerciseItem.prototype.setThumbNail = function(thumbNail){
      this.thumbNail =  thumbNail;
    };
    module.exports = ExerciseItem;

});