import dagre from 'dagre'

const data = {
  fathers: [
    {
      id: 0,
      married: false,
      name: 'Eric Taylor',
      // sons: [
      //   {
      //     age: 21,
      //     name: 'Jose',
      //   },
      //   {
      //     age: 1,
      //     name: 'James',
      //   },
      //   {
      //     age: 17,
      //     name: 'Gary',
      //   },
      //   {
      //     age: 29,
      //     name: 'Thomas',
      //   },
      //   {
      //     age: 3,
      //     name: 'John',
      //   },
      //   {
      //     age: 10,
      //     name: 'Michael',
      //   },
      //   {
      //     age: 13,
      //     name: 'Jose',
      //   },
      //   {
      //     age: 26,
      //     name: 'James',
      //   },
      //   {
      //     age: 19,
      //     name: 'Christopher',
      //   },
      //   {
      //     age: 20,
      //     name: 'George',
      //   },
      // ],
      daughters: [
        {
          age: 30,
          name: 'Sarah',
        },
        {
          age: 6,
          name: 'Cynthia',
        },
        {
          age: 15,
          name: 'Linda',
        },
        {
          age: 7,
          name: 'Barbara',
        },
        {
          age: 18,
          name: 'Margaret',
        },
      ],
    },
    // {
    //   id: 1,
    //   married: true,
    //   name: 'Michael Taylor',
    //   sons: [
    //     {
    //       age: 18,
    //       name: 'Timothy',
    //     },
    //     {
    //       age: 3,
    //       name: 'George',
    //     },
    //   ],
    //   daughters: [
    //     {
    //       age: 12,
    //       name: 'Karen',
    //     },
    //     {
    //       age: 22,
    //       name: 'Patricia',
    //     },
    //     {
    //       age: 4,
    //       name: 'Linda',
    //     },
    //     {
    //       age: 24,
    //       name: 'Jennifer',
    //     },
    //     {
    //       age: 8,
    //       name: 'Laura',
    //     },
    //     {
    //       age: 23,
    //       name: 'Kimberly',
    //     },
    //     {
    //       age: 11,
    //       name: 'Anna',
    //     },
    //   ],
    // },
    // {
    //   id: 2,
    //   married: false,
    //   name: 'James Lopez',
    //   sons: [
    //     {
    //       age: 2,
    //       name: 'Ronald',
    //     },
    //   ],
    //   daughters: [
    //     {
    //       age: 28,
    //       name: 'Karen',
    //     },
    //   ],
    // },
    // {
    //   id: 3,
    //   married: false,
    //   name: 'Charles Thomas',
    //   sons: [
    //     {
    //       age: 12,
    //       name: 'Michael',
    //     },
    //     {
    //       age: 24,
    //       name: 'Anthony',
    //     },
    //     {
    //       age: 14,
    //       name: 'Eric',
    //     },
    //     {
    //       age: 8,
    //       name: 'Steven',
    //     },
    //   ],
    //   daughters: [
    //     {
    //       age: 10,
    //       name: 'Nancy',
    //     },
    //     {
    //       age: 12,
    //       name: 'Angela',
    //     },
    //     {
    //       age: 18,
    //       name: 'Deborah',
    //     },
    //     {
    //       age: 3,
    //       name: 'Cynthia',
    //     },
    //     {
    //       age: 26,
    //       name: 'Patricia',
    //     },
    //   ],
    // },
    // {
    //   id: 4,
    //   married: false,
    //   name: 'Donald Martinez',
    //   sons: [
    //     {
    //       age: 21,
    //       name: 'Timothy',
    //     },
    //     {
    //       age: 19,
    //       name: 'James',
    //     },
    //     {
    //       age: 22,
    //       name: 'Christopher',
    //     },
    //     {
    //       age: 24,
    //       name: 'Michael',
    //     },
    //     {
    //       age: 24,
    //       name: 'Edward',
    //     },
    //     {
    //       age: 24,
    //       name: 'Charles',
    //     },
    //     {
    //       age: 11,
    //       name: 'Jason',
    //     },
    //   ],
    //   daughters: [
    //     {
    //       age: 13,
    //       name: 'Jennifer',
    //     },
    //     {
    //       age: 20,
    //       name: 'Margaret',
    //     },
    //     {
    //       age: 16,
    //       name: 'Sharon',
    //     },
    //     {
    //       age: 25,
    //       name: 'Carol',
    //     },
    //     {
    //       age: 30,
    //       name: 'Carol',
    //     },
    //     {
    //       age: 23,
    //       name: 'Donna',
    //     },
    //   ],
    // },
    // {
    //   id: 5,
    //   married: true,
    //   name: 'Timothy Lewis',
    //   sons: [
    //     {
    //       age: 15,
    //       name: 'Ronald',
    //     },
    //     {
    //       age: 29,
    //       name: 'Robert',
    //     },
    //     {
    //       age: 15,
    //       name: 'Richard',
    //     },
    //   ],
    //   daughters: [
    //     {
    //       age: 27,
    //       name: 'Linda',
    //     },
    //     {
    //       age: 5,
    //       name: 'Carol',
    //     },
    //     {
    //       age: 17,
    //       name: 'Helen',
    //     },
    //     {
    //       age: 27,
    //       name: 'Margaret',
    //     },
    //     {
    //       age: 4,
    //       name: 'Ruth',
    //     },
    //     {
    //       age: 22,
    //       name: 'Michelle',
    //     },
    //     {
    //       age: 8,
    //       name: 'Elizabeth',
    //     },
    //   ],
    // },
    // {
    //   id: 6,
    //   married: true,
    //   name: 'Daniel Martin',
    //   sons: [
    //     {
    //       age: 10,
    //       name: 'Brian',
    //     },
    //     {
    //       age: 4,
    //       name: 'Gary',
    //     },
    //   ],
    //   daughters: [
    //     {
    //       age: 24,
    //       name: 'Cynthia',
    //     },
    //     {
    //       age: 18,
    //       name: 'Melissa',
    //     },
    //     {
    //       age: 18,
    //       name: 'Elizabeth',
    //     },
    //     {
    //       age: 11,
    //       name: 'Margaret',
    //     },
    //     {
    //       age: 18,
    //       name: 'Shirley',
    //     },
    //     {
    //       age: 17,
    //       name: 'Sandra',
    //     },
    //     {
    //       age: 2,
    //       name: 'Brenda',
    //     },
    //     {
    //       age: 8,
    //       name: 'Elizabeth',
    //     },
    //     {
    //       age: 2,
    //       name: 'Elizabeth',
    //     },
    //     {
    //       age: 25,
    //       name: 'Kimberly',
    //     },
    //   ],
    // },
    // {
    //   id: 7,
    //   married: false,
    //   name: 'Kevin Walker',
    //   sons: [
    //     {
    //       age: 8,
    //       name: 'Brian',
    //     },
    //     {
    //       age: 31,
    //       name: 'Kenneth',
    //     },
    //     {
    //       age: 1,
    //       name: 'David',
    //     },
    //     {
    //       age: 22,
    //       name: 'John',
    //     },
    //     {
    //       age: 30,
    //       name: 'Thomas',
    //     },
    //     {
    //       age: 19,
    //       name: 'Matthew',
    //     },
    //     {
    //       age: 31,
    //       name: 'Thomas',
    //     },
    //   ],
    //   daughters: [
    //     {
    //       age: 13,
    //       name: 'Barbara',
    //     },
    //     {
    //       age: 22,
    //       name: 'Donna',
    //     },
    //     {
    //       age: 11,
    //       name: 'Michelle',
    //     },
    //   ],
    // },
    // {
    //   id: 8,
    //   married: false,
    //   name: 'Jose Taylor',
    //   sons: [
    //     {
    //       age: 21,
    //       name: 'Richard',
    //     },
    //     {
    //       age: 3,
    //       name: 'Thomas',
    //     },
    //     {
    //       age: 26,
    //       name: 'Charles',
    //     },
    //   ],
    //   daughters: [
    //     {
    //       age: 5,
    //       name: 'Jessica',
    //     },
    //     {
    //       age: 11,
    //       name: 'Nancy',
    //     },
    //     {
    //       age: 3,
    //       name: 'Maria',
    //     },
    //     {
    //       age: 26,
    //       name: 'Cynthia',
    //     },
    //     {
    //       age: 16,
    //       name: 'Helen',
    //     },
    //   ],
    // },
    // {
    //   id: 9,
    //   married: false,
    //   name: 'Michael Young',
    //   sons: [
    //     {
    //       age: 3,
    //       name: 'George',
    //     },
    //     {
    //       age: 25,
    //       name: 'Jeffrey',
    //     },
    //     {
    //       age: 7,
    //       name: 'Edward',
    //     },
    //     {
    //       age: 18,
    //       name: 'Anthony',
    //     },
    //     {
    //       age: 31,
    //       name: 'Eric',
    //     },
    //     {
    //       age: 8,
    //       name: 'Donald',
    //     },
    //     {
    //       age: 31,
    //       name: 'Christopher',
    //     },
    //     {
    //       age: 23,
    //       name: 'Brian',
    //     },
    //     {
    //       age: 18,
    //       name: 'George',
    //     },
    //   ],
    //   daughters: [
    //     {
    //       age: 12,
    //       name: 'Susan',
    //     },
    //     {
    //       age: 4,
    //       name: 'Elizabeth',
    //     },
    //     {
    //       age: 13,
    //       name: 'Shirley',
    //     },
    //     {
    //       age: 17,
    //       name: 'Barbara',
    //     },
    //     {
    //       age: 12,
    //       name: 'Susan',
    //     },
    //   ],
    // },
    // {
    //   id: 10,
    //   married: false,
    //   name: 'Jason Miller',
    //   sons: [
    //     {
    //       age: 11,
    //       name: 'Mark',
    //     },
    //     {
    //       age: 30,
    //       name: 'Kevin',
    //     },
    //     {
    //       age: 14,
    //       name: 'Edward',
    //     },
    //     {
    //       age: 22,
    //       name: 'Thomas',
    //     },
    //     {
    //       age: 1,
    //       name: 'Jose',
    //     },
    //     {
    //       age: 18,
    //       name: 'Daniel',
    //     },
    //     {
    //       age: 2,
    //       name: 'Jeffrey',
    //     },
    //     {
    //       age: 20,
    //       name: 'Christopher',
    //     },
    //   ],
    //   daughters: [
    //     {
    //       age: 26,
    //       name: 'Dorothy',
    //     },
    //     {
    //       age: 8,
    //       name: 'Angela',
    //     },
    //     {
    //       age: 28,
    //       name: 'Elizabeth',
    //     },
    //     {
    //       age: 11,
    //       name: 'Laura',
    //     },
    //     {
    //       age: 23,
    //       name: 'Karen',
    //     },
    //     {
    //       age: 0,
    //       name: 'Brenda',
    //     },
    //   ],
    // },
    // {
    //   id: 11,
    //   married: true,
    //   name: 'Larry Miller',
    //   sons: [
    //     {
    //       age: 16,
    //       name: 'James',
    //     },
    //     {
    //       age: 21,
    //       name: 'Jeffrey',
    //     },
    //     {
    //       age: 15,
    //       name: 'Scott',
    //     },
    //     {
    //       age: 24,
    //       name: 'Matthew',
    //     },
    //     {
    //       age: 24,
    //       name: 'Anthony',
    //     },
    //     {
    //       age: 7,
    //       name: 'Anthony',
    //     },
    //   ],
    //   daughters: [
    //     {
    //       age: 17,
    //       name: 'Karen',
    //     },
    //     {
    //       age: 26,
    //       name: 'Lisa',
    //     },
    //     {
    //       age: 18,
    //       name: 'Cynthia',
    //     },
    //     {
    //       age: 27,
    //       name: 'Susan',
    //     },
    //     {
    //       age: 13,
    //       name: 'Michelle',
    //     },
    //     {
    //       age: 21,
    //       name: 'Lisa',
    //     },
    //     {
    //       age: 10,
    //       name: 'Maria',
    //     },
    //     {
    //       age: 17,
    //       name: 'Barbara',
    //     },
    //   ],
    // },
    // {
    //   id: 12,
    //   married: true,
    //   name: 'Christopher Thomas',
    //   sons: [
    //     {
    //       age: 22,
    //       name: 'William',
    //     },
    //     {
    //       age: 7,
    //       name: 'Paul',
    //     },
    //   ],
    //   daughters: [
    //     {
    //       age: 12,
    //       name: 'Amy',
    //     },
    //     {
    //       age: 1,
    //       name: 'Melissa',
    //     },
    //     {
    //       age: 4,
    //       name: 'Mary',
    //     },
    //     {
    //       age: 26,
    //       name: 'Anna',
    //     },
    //     {
    //       age: 24,
    //       name: 'Donna',
    //     },
    //     {
    //       age: 30,
    //       name: 'Jessica',
    //     },
    //     {
    //       age: 8,
    //       name: 'Lisa',
    //     },
    //     {
    //       age: 5,
    //       name: 'Maria',
    //     },
    //     {
    //       age: 7,
    //       name: 'Jessica',
    //     },
    //   ],
    // },
    // {
    //   id: 13,
    //   married: true,
    //   name: 'Daniel Johnson',
    //   sons: [
    //     {
    //       age: 29,
    //       name: 'Gary',
    //     },
    //     {
    //       age: 30,
    //       name: 'Frank',
    //     },
    //   ],
    //   daughters: [
    //     {
    //       age: 31,
    //       name: 'Patricia',
    //     },
    //     {
    //       age: 23,
    //       name: 'Melissa',
    //     },
    //     {
    //       age: 10,
    //       name: 'Shirley',
    //     },
    //     {
    //       age: 10,
    //       name: 'Kimberly',
    //     },
    //     {
    //       age: 15,
    //       name: 'Maria',
    //     },
    //     {
    //       age: 11,
    //       name: 'Ruth',
    //     },
    //     {
    //       age: 26,
    //       name: 'Linda',
    //     },
    //     {
    //       age: 13,
    //       name: 'Jennifer',
    //     },
    //     {
    //       age: 8,
    //       name: 'Jennifer',
    //     },
    //   ],
    // },
    // {
    //   id: 14,
    //   married: false,
    //   name: 'Daniel Martinez',
    //   sons: [
    //     {
    //       age: 26,
    //       name: 'Eric',
    //     },
    //     {
    //       age: 26,
    //       name: 'Joseph',
    //     },
    //     {
    //       age: 5,
    //       name: 'Richard',
    //     },
    //     {
    //       age: 28,
    //       name: 'Gary',
    //     },
    //   ],
    //   daughters: [
    //     {
    //       age: 15,
    //       name: 'Maria',
    //     },
    //     {
    //       age: 25,
    //       name: 'Kimberly',
    //     },
    //     {
    //       age: 27,
    //       name: 'Lisa',
    //     },
    //   ],
    // },
    // {
    //   id: 15,
    //   married: false,
    //   name: 'Edward Jackson',
    //   sons: [
    //     {
    //       age: 6,
    //       name: 'William',
    //     },
    //     {
    //       age: 16,
    //       name: 'Robert',
    //     },
    //     {
    //       age: 27,
    //       name: 'Jason',
    //     },
    //   ],
    //   daughters: [
    //     {
    //       age: 24,
    //       name: 'Carol',
    //     },
    //     {
    //       age: 17,
    //       name: 'Laura',
    //     },
    //     {
    //       age: 30,
    //       name: 'Shirley',
    //     },
    //     {
    //       age: 3,
    //       name: 'Deborah',
    //     },
    //     {
    //       age: 24,
    //       name: 'Sharon',
    //     },
    //     {
    //       age: 23,
    //       name: 'Jessica',
    //     },
    //     {
    //       age: 19,
    //       name: 'Angela',
    //     },
    //     {
    //       age: 10,
    //       name: 'Cynthia',
    //     },
    //     {
    //       age: 0,
    //       name: 'Patricia',
    //     },
    //     {
    //       age: 18,
    //       name: 'Jennifer',
    //     },
    //   ],
    // },
  ],
}

let counter = 0
function getNodeMetadata(label: string) {
  counter += 1
  return {
    id: counter,
    shape: 'tree-node',
    width: isNaN(+`${label}`) ? 70 : 28,
    height: 26,
    leaf: false,
    attrs: {
      label: {
        textWrap: {
          text: label,
        },
      },
    },
  }
}

function formatData(output: any, data: any, parent?: any) {
  const { nodes, edges } = output

  Object.keys(data).forEach((key) => {
    const val = data[key]
    const child = getNodeMetadata(key)
    nodes.push(child)

    if (parent) {
      edges.push({
        source: parent.id,
        target: child.id,
        shape: 'tree-edge',
      })
    }

    if (Array.isArray(val) || typeof val === 'object') {
      formatData(output, val, child)
    } else {
      const sub = getNodeMetadata(val)
      const edge = {
        source: child.id,
        target: sub.id,
        shape: 'tree-edge',
      }
      sub.leaf = true
      nodes.push(sub)
      edges.push(edge)
    }
  })
}

export function getData() {
  const output = { nodes: [], edges: [] }
  formatData(output, data)

  var g = new dagre.graphlib.Graph({})
  g.setGraph({ rankdir: 'LR', ranksep: 100, nodesep: 30 })
  g.setDefaultEdgeLabel(() => ({}))

  output.nodes.forEach((node: any) => {
    g.setNode(node.id, { ...node })
  })

  output.edges.forEach((edge: any) => {
    g.setEdge(edge.source, edge.target)
  })

  dagre.layout(g)

  return {
    nodes: g.nodes().map((id: string) => g.node(id)),
    edges: output.edges,
  }
}
