/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.favorites;

import java.awt.EventQueue;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.favorites.Actions;
import org.netbeans.modules.favorites.Tab;
import org.netbeans.modules.favorites.api.Favorites;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataShadow;
import org.openide.loaders.LoaderTransfer;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.datatransfer.PasteType;

public final class FavoritesNode
extends FilterNode
implements Index {
    private static Node node;
    static RequestProcessor RP;
    private static DataFlavor uriListDataFlavor;

    private FavoritesNode(Node node) {
        super(node, (Children)new Chldrn(node, false));
    }

    public PasteType getDropType(Transferable transferable, int n, int n2) {
        if (n2 != -1) {
            return null;
        }
        DataObject[] dataObjectArray = LoaderTransfer.getDataObjects((Transferable)transferable, (int)7);
        if (dataObjectArray == null) {
            List<File> list = this.getDraggedFilesList(transferable);
            if (!list.isEmpty()) {
                return new FavoritesExternalPasteType(list);
            }
            return null;
        }
        for (DataObject dataObject : dataObjectArray) {
            if (Actions.Add.isAllowed(dataObject)) continue;
            return null;
        }
        return new FavoritesPasteType(dataObjectArray);
    }

    public <T extends Node.Cookie> T getCookie(Class<T> clazz) {
        if (clazz == Index.class) {
            return (T)((Node.Cookie)clazz.cast((Object)this));
        }
        return (T)super.getCookie(clazz);
    }

    public int getNodesCount() {
        Index index = (Index)this.getOriginal().getCookie(Index.class);
        if (index != null) {
            return index.getNodesCount();
        }
        return 0;
    }

    public Node[] getNodes() {
        Index index = (Index)this.getOriginal().getCookie(Index.class);
        if (index != null) {
            return index.getNodes();
        }
        return new Node[0];
    }

    public int indexOf(Node node) {
        Index index = (Index)this.getOriginal().getCookie(Index.class);
        if (index != null) {
            if (node instanceof ProjectFilterNode) {
                ProjectFilterNode projectFilterNode = (ProjectFilterNode)node;
                int n = index.indexOf(projectFilterNode.getOriginal());
                return n;
            }
            int n = index.indexOf(node);
            return n;
        }
        return -1;
    }

    public void reorder() {
        Index index = (Index)this.getOriginal().getCookie(Index.class);
        if (index != null) {
            index.reorder();
        }
    }

    public void reorder(int[] nArray) {
        Index index = (Index)this.getOriginal().getCookie(Index.class);
        if (index != null) {
            index.reorder(nArray);
        }
    }

    public void move(int n, int n2) {
        Index index = (Index)this.getOriginal().getCookie(Index.class);
        if (index != null) {
            index.move(n, n2);
        }
    }

    public void exchange(int n, int n2) {
        Index index = (Index)this.getOriginal().getCookie(Index.class);
        if (index != null) {
            index.exchange(n, n2);
        }
    }

    public void moveUp(int n) {
        Index index = (Index)this.getOriginal().getCookie(Index.class);
        if (index != null) {
            index.moveUp(n);
        }
    }

    public void moveDown(int n) {
        Index index = (Index)this.getOriginal().getCookie(Index.class);
        if (index != null) {
            index.moveDown(n);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        Index index = (Index)this.getOriginal().getCookie(Index.class);
        if (index != null) {
            index.addChangeListener(changeListener);
        }
    }

    public void removeChangeListener(ChangeListener changeListener) {
        Index index = (Index)this.getOriginal().getCookie(Index.class);
        if (index != null) {
            index.removeChangeListener(changeListener);
        }
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    public static DataFolder getFolder() {
        try {
            FileObject fileObject = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)"Favorites");
            DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
            return dataFolder;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return DataFolder.findFolder((FileObject)FileUtil.getConfigRoot());
        }
    }

    public static synchronized Node getNode() {
        if (node == null) {
            node = new FavoritesNode(FavoritesNode.getFolder().getNodeDelegate());
        }
        return node;
    }

    public static URL getHome() throws FileStateInvalidException, MalformedURLException {
        String string = System.getProperty("user.home");
        File file = new File(string);
        file = FileUtil.normalizeFile((File)file);
        return Utilities.toURI((File)file).toURL();
    }

    static File fileForNode(Node node) {
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject == null) {
            return null;
        }
        return FileUtil.toFile((FileObject)dataObject.getPrimaryFile());
    }

    public Node.Handle getHandle() {
        return new RootHandle();
    }

    public Action[] getActions(boolean bl) {
        return new Action[]{Actions.addOnFavoritesNode()};
    }

    private List<File> getDraggedFilesList(Transferable transferable) {
        try {
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                if (null != list) {
                    return NbCollections.checkedListByCopy((List)list, File.class, (boolean)true);
                }
            } else if (transferable.isDataFlavorSupported(this.getUriListDataFlavor())) {
                String string = (String)transferable.getTransferData(this.getUriListDataFlavor());
                return this.textURIListToFileList(string);
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            Logger.getLogger(FavoritesNode.class.getName()).log(Level.WARNING, null, unsupportedFlavorException);
        }
        catch (IOException iOException) {
            Logger.getLogger(FavoritesNode.class.getName()).log(Level.FINE, null, iOException);
        }
        return Collections.emptyList();
    }

    private DataFlavor getUriListDataFlavor() {
        if (null == uriListDataFlavor) {
            try {
                uriListDataFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new AssertionError((Object)classNotFoundException);
            }
        }
        return uriListDataFlavor;
    }

    private List<File> textURIListToFileList(String string) {
        ArrayList<File> arrayList = new ArrayList<File>(1);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("#")) continue;
            try {
                URI uRI = new URI(string2);
                File file = Utilities.toFile((URI)uRI);
                arrayList.add(file);
            }
            catch (URISyntaxException uRISyntaxException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return arrayList;
    }

    static Node createFilterNode(Node node) {
        return new ProjectFilterNode(node, EventQueue.isDispatchThread() ? FilterNode.Children.LEAF : FavoritesNode.findChildren(node));
    }

    private static Children findChildren(Node node) {
        assert (!EventQueue.isDispatchThread());
        DataFolder dataFolder = (DataFolder)node.getLookup().lookup(DataFolder.class);
        Object object = dataFolder != null ? new Chldrn((Node)new FilterNode(node, dataFolder.createNodeChildren((DataFilter)new VisQ())), true) : (node.isLeaf() ? Children.LEAF : new Chldrn(node, true));
        return object;
    }

    static {
        RP = new RequestProcessor("Favorites Nodes");
    }

    private static class FavoritesExternalPasteType
    extends PasteType {
        private final List<File> files;

        private FavoritesExternalPasteType(List<File> list) {
            this.files = list;
        }

        public Transferable paste() throws IOException {
            Tab.RP.post(new Runnable(){

                @Override
                public void run() {
                    HashSet<FileObject> hashSet = new HashSet<FileObject>(FavoritesExternalPasteType.this.files.size());
                    for (File file : FavoritesExternalPasteType.this.files) {
                        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
                        if (fileObject == null) continue;
                        hashSet.add(fileObject);
                    }
                    if (!hashSet.isEmpty()) {
                        try {
                            Favorites.getDefault().add(hashSet.toArray(new FileObject[hashSet.size()]));
                        }
                        catch (DataObjectNotFoundException dataObjectNotFoundException) {
                            Logger.getLogger(FavoritesNode.class.getName()).log(Level.INFO, null, dataObjectNotFoundException);
                        }
                    }
                }
            });
            return null;
        }
    }

    private static class FavoritesPasteType
    extends PasteType {
        private final DataObject[] dos;

        private FavoritesPasteType(DataObject[] dataObjectArray) {
            this.dos = dataObjectArray;
        }

        public Transferable paste() throws IOException {
            Tab.RP.post(new Runnable(){

                @Override
                public void run() {
                    Actions.Add.addToFavorites(Arrays.asList(FavoritesPasteType.this.dos));
                }
            });
            return null;
        }
    }

    private static class ProjectFilterNode
    extends FilterNode
    implements NodeListener,
    Runnable {
        private DataShadow ds;

        public ProjectFilterNode(Node node, Children children) {
            super(node, children);
            this.addNodeListener(this);
            RP.post((Runnable)this);
        }

        @Override
        public void run() {
            this.setChildren(FavoritesNode.findChildren(this.getOriginal()));
            if (FavoritesNode.getNode().equals((Object)this.getParentNode())) {
                this.ds = (DataShadow)this.getCookie(DataShadow.class);
                this.fireDisplayNameChange(null, null);
            }
        }

        protected NodeListener createNodeListener() {
            return new FilterNode.NodeAdapter(this){

                protected void propertyChange(FilterNode filterNode, PropertyChangeEvent propertyChangeEvent) {
                    super.propertyChange(filterNode, propertyChangeEvent);
                    if ("leaf".equals(propertyChangeEvent.getPropertyName())) {
                        RP.post((Runnable)ProjectFilterNode.this);
                    }
                }
            };
        }

        public void setName(String string) {
            DataFolder dataFolder = FavoritesNode.getFolder();
            DataObject[] dataObjectArray = dataFolder.getChildren();
            super.setName(string);
            try {
                dataFolder.setOrder(dataObjectArray);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }

        public String getDisplayName() {
            if (FavoritesNode.getNode().equals((Object)this.getParentNode())) {
                DataShadow dataShadow = this.getShadow();
                if (dataShadow != null) {
                    String string = dataShadow.getName();
                    String string2 = FileUtil.getFileDisplayName((FileObject)dataShadow.getOriginal().getPrimaryFile());
                    return NbBundle.getMessage(FavoritesNode.class, (String)"CTL_DisplayNameTemplate", (Object)string, (Object)string2);
                }
                return super.getDisplayName();
            }
            return super.getDisplayName();
        }

        public String getHtmlDisplayName() {
            if (FavoritesNode.getNode().equals((Object)this.getParentNode())) {
                DataShadow dataShadow = this.getShadow();
                if (dataShadow != null) {
                    String string = dataShadow.getName();
                    String string2 = FileUtil.getFileDisplayName((FileObject)dataShadow.getOriginal().getPrimaryFile());
                    return NbBundle.getMessage(FavoritesNode.class, (String)"CTL_DisplayNameTemplateHtml", (Object)string, (Object)string2);
                }
                return super.getDisplayName();
            }
            return this.getOriginal().getHtmlDisplayName();
        }

        protected Node getOriginal() {
            return super.getOriginal();
        }

        public Action[] getActions(boolean bl) {
            Action[] actionArray = super.getActions(bl);
            boolean bl2 = false;
            FileObject fileObject = (FileObject)this.getOriginal().getLookup().lookup(FileObject.class);
            if (fileObject == null) {
                Logger.getLogger(FavoritesNode.class.getName()).log(Level.INFO, "No FO in node: {0}:{1}", new Object[]{this.getOriginal().getName(), this.getOriginal()});
            } else {
                bl2 = fileObject.isRoot();
            }
            if (bl2) {
                return this.createActionsForRoot(actionArray, FavoritesNode.getNode().equals((Object)this.getParentNode()));
            }
            if (FavoritesNode.getNode().equals((Object)this.getParentNode())) {
                DataShadow dataShadow = this.getShadow();
                if (dataShadow != null) {
                    if (dataShadow.getOriginal().getPrimaryFile().isFolder()) {
                        return this.createActionsForFavoriteFolder(actionArray);
                    }
                    return this.createActionsForFavoriteFile(actionArray);
                }
            } else if (fileObject != null) {
                if (fileObject.isFolder()) {
                    return this.createActionsForFolder(actionArray);
                }
                return this.createActionsForFile(actionArray);
            }
            return actionArray;
        }

        private Action[] createActionsForRoot(Action[] actionArray, boolean bl) {
            if (bl) {
                ArrayList<Action> arrayList = new ArrayList<Action>(actionArray.length + 2);
                arrayList.addAll(Arrays.asList(actionArray));
                if (!arrayList.isEmpty()) {
                    arrayList.add(null);
                }
                arrayList.add(Actions.remove());
                return arrayList.toArray(new Action[arrayList.size()]);
            }
            return actionArray;
        }

        private Action[] createActionsForFavoriteFolder(Action[] actionArray) {
            boolean bl = false;
            ArrayList<Action> arrayList = new ArrayList<Action>();
            for (int i = 0; i < actionArray.length; ++i) {
                if (!bl && (actionArray[i] instanceof CopyAction || actionArray[i] instanceof CutAction)) {
                    bl = true;
                    arrayList.add(Actions.remove());
                    arrayList.add(null);
                }
                if (actionArray[i] instanceof DeleteAction) continue;
                arrayList.add(actionArray[i]);
            }
            if (!bl) {
                bl = true;
                arrayList.add(null);
                arrayList.add(Actions.remove());
            }
            return arrayList.toArray(new Action[arrayList.size()]);
        }

        private Action[] createActionsForFavoriteFile(Action[] actionArray) {
            boolean bl = false;
            ArrayList<Action> arrayList = new ArrayList<Action>();
            for (int i = 0; i < actionArray.length; ++i) {
                if (!bl && (actionArray[i] instanceof CopyAction || actionArray[i] instanceof CutAction)) {
                    bl = true;
                    arrayList.add(Actions.remove());
                    arrayList.add(null);
                }
                if (actionArray[i] instanceof DeleteAction) continue;
                arrayList.add(actionArray[i]);
            }
            if (!bl) {
                bl = true;
                arrayList.add(null);
                arrayList.add(Actions.remove());
            }
            return arrayList.toArray(new Action[arrayList.size()]);
        }

        private Action[] createActionsForFolder(Action[] actionArray) {
            boolean bl = false;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 0; i < actionArray.length; ++i) {
                if (!bl && (actionArray[i] instanceof CopyAction || actionArray[i] instanceof CutAction)) {
                    bl = true;
                    arrayList.add(Actions.add());
                    arrayList.add(null);
                }
                arrayList.add(actionArray[i]);
            }
            if (!bl) {
                bl = true;
                arrayList.add(null);
                arrayList.add(Actions.add());
            }
            return arrayList.toArray(new Action[arrayList.size()]);
        }

        private Action[] createActionsForFile(Action[] actionArray) {
            boolean bl = false;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 0; i < actionArray.length; ++i) {
                if (!bl && (actionArray[i] instanceof CopyAction || actionArray[i] instanceof CutAction)) {
                    bl = true;
                    arrayList.add(Actions.add());
                    arrayList.add(null);
                }
                arrayList.add(actionArray[i]);
            }
            if (!bl) {
                bl = true;
                arrayList.add(null);
                arrayList.add(Actions.add());
            }
            return arrayList.toArray(new Action[arrayList.size()]);
        }

        public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
        }

        public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
        }

        public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
        }

        public void nodeDestroyed(NodeEvent nodeEvent) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        }

        private DataShadow getShadow() {
            return this.ds;
        }
    }

    private static class Chldrn
    extends FilterNode.Children {
        private boolean hideHidden;

        public Chldrn(Node node, boolean bl) {
            super(node);
            this.hideHidden = bl;
        }

        protected Node[] createNodes(Node node) {
            return new Node[]{FavoritesNode.createFilterNode(node)};
        }
    }

    static class VisQ
    implements DataFilter.FileBased,
    ChangeableDataFilter,
    ChangeListener {
        public static final VisQ DEFAULT = new VisQ();
        private ChangeListener weak;
        private ChangeSupport support = new ChangeSupport((Object)this);

        VisQ() {
            this.weak = WeakListeners.change((ChangeListener)this, (Object)VisibilityQuery.getDefault());
            VisibilityQuery.getDefault().addChangeListener(this.weak);
        }

        public boolean acceptFileObject(FileObject fileObject) {
            return VisibilityQuery.getDefault().isVisible(fileObject);
        }

        public boolean acceptDataObject(DataObject dataObject) {
            return this.acceptFileObject(dataObject.getPrimaryFile());
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.support.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.support.removeChangeListener(changeListener);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.support.fireChange();
        }
    }

    private static class RootHandle
    implements Node.Handle {
        static final long serialVersionUID = 1907300072945111595L;

        private RootHandle() {
        }

        public Node getNode() {
            return FavoritesNode.getNode();
        }
    }
}

