/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors;

import java.io.IOException;
import org.jf.baksmali.Adaptors.EncodedValue.EncodedValueAdaptor;
import org.jf.dexlib2.iface.reference.CallSiteReference;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodHandleReference;
import org.jf.dexlib2.iface.reference.MethodProtoReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.iface.reference.Reference;
import org.jf.dexlib2.iface.reference.StringReference;
import org.jf.dexlib2.iface.reference.TypeReference;
import org.jf.dexlib2.iface.value.EncodedValue;
import org.jf.dexlib2.util.ReferenceUtil;
import org.jf.util.IndentingWriter;
import org.jf.util.StringUtils;

public class ReferenceFormatter {
    public static void writeStringReference(IndentingWriter writer, String item) throws IOException {
        writer.write(34);
        StringUtils.writeEscapedString(writer, item);
        writer.write(34);
    }

    public static void writeCallSiteReference(IndentingWriter writer, CallSiteReference callSite) throws IOException {
        writer.write(callSite.getName());
        writer.write(40);
        writer.write(34);
        StringUtils.writeEscapedString(writer, callSite.getMethodName());
        writer.write("\", ");
        ReferenceFormatter.writeReference(writer, 4, callSite.getMethodProto());
        for (EncodedValue encodedValue : callSite.getExtraArguments()) {
            writer.write(", ");
            EncodedValueAdaptor.writeTo(writer, encodedValue, null);
        }
        writer.write(")@");
        MethodHandleReference methodHandle = callSite.getMethodHandle();
        if (methodHandle.getMethodHandleType() != 4) {
            throw new IllegalArgumentException("The linker method handle for a call site must be of type invoke-static");
        }
        ReferenceFormatter.writeReference(writer, 3, callSite.getMethodHandle().getMemberReference());
    }

    public static void writeReference(IndentingWriter writer, int referenceType, Reference reference) throws IOException {
        switch (referenceType) {
            case 0: {
                ReferenceFormatter.writeStringReference(writer, ((StringReference)reference).getString());
                return;
            }
            case 1: {
                writer.write(((TypeReference)reference).getType());
                return;
            }
            case 3: {
                ReferenceUtil.writeMethodDescriptor(writer, (MethodReference)reference);
                return;
            }
            case 2: {
                ReferenceUtil.writeFieldDescriptor(writer, (FieldReference)reference);
                return;
            }
            case 4: {
                ReferenceUtil.writeMethodProtoDescriptor(writer, (MethodProtoReference)reference);
                return;
            }
            case 6: {
                ReferenceUtil.writeMethodHandle(writer, (MethodHandleReference)reference);
                return;
            }
            case 5: {
                ReferenceFormatter.writeCallSiteReference(writer, (CallSiteReference)reference);
                return;
            }
        }
        throw new IllegalStateException("Unknown reference type");
    }
}

