/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.src;

import brut.androlib.AndrolibException;
import brut.androlib.mod.SmaliMod;
import brut.directory.DirectoryException;
import brut.directory.ExtFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import org.antlr.runtime.RecognitionException;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.writer.builder.DexBuilder;
import org.jf.dexlib2.writer.io.FileDataStore;

public class SmaliBuilder {
    private final ExtFile mSmaliDir;
    private final File mDexFile;
    private int mApiLevel = 0;
    private static final Logger LOGGER = Logger.getLogger(SmaliBuilder.class.getName());

    public static void build(ExtFile smaliDir, File dexFile, int apiLevel) throws AndrolibException {
        new SmaliBuilder(smaliDir, dexFile, apiLevel).build();
    }

    private SmaliBuilder(ExtFile smaliDir, File dexFile, int apiLevel) {
        this.mSmaliDir = smaliDir;
        this.mDexFile = dexFile;
        this.mApiLevel = apiLevel;
    }

    private void build() throws AndrolibException {
        try {
            DexBuilder dexBuilder = this.mApiLevel > 0 ? new DexBuilder(Opcodes.forApi(this.mApiLevel)) : new DexBuilder(Opcodes.getDefault());
            for (String fileName : this.mSmaliDir.getDirectory().getFiles(true)) {
                this.buildFile(fileName, dexBuilder);
            }
            dexBuilder.writeTo(new FileDataStore(new File(this.mDexFile.getAbsolutePath())));
        }
        catch (DirectoryException | IOException ex) {
            throw new AndrolibException(ex);
        }
    }

    private void buildFile(String fileName, DexBuilder dexBuilder) throws AndrolibException, IOException {
        FileInputStream inStream;
        block4: {
            File inFile = new File(this.mSmaliDir, fileName);
            inStream = new FileInputStream(inFile);
            if (fileName.endsWith(".smali")) {
                try {
                    if (!SmaliMod.assembleSmaliFile(inFile, dexBuilder, this.mApiLevel, false, false)) {
                        throw new AndrolibException("Could not smali file: " + fileName);
                    }
                    break block4;
                }
                catch (IOException | RecognitionException ex) {
                    throw new AndrolibException(ex);
                }
            }
            LOGGER.warning("Unknown file type, ignoring: " + inFile);
        }
        ((InputStream)inStream).close();
    }
}

