/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.mod;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.jf.dexlib2.writer.builder.DexBuilder;
import org.jf.smali.smaliFlexLexer;
import org.jf.smali.smaliParser;
import org.jf.smali.smaliTreeWalker;

public class SmaliMod {
    public static boolean assembleSmaliFile(File smaliFile, DexBuilder dexBuilder, int apiLevel, boolean verboseErrors, boolean printTokens) throws IOException, RecognitionException {
        FileInputStream is = new FileInputStream(smaliFile);
        InputStreamReader reader = new InputStreamReader((InputStream)is, StandardCharsets.UTF_8);
        smaliFlexLexer lexer = new smaliFlexLexer(reader, apiLevel);
        lexer.setSourceFile(smaliFile);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        if (printTokens) {
            tokens.getTokens();
            for (int i = 0; i < tokens.size(); ++i) {
                Token token = tokens.get(i);
                if (token.getChannel() == 99) continue;
                System.out.println(smaliParser.tokenNames[token.getType()] + ": " + token.getText());
            }
        }
        smaliParser parser = new smaliParser(tokens);
        parser.setApiLevel(apiLevel);
        parser.setVerboseErrors(verboseErrors);
        smaliParser.smali_file_return result = parser.smali_file();
        if (parser.getNumberOfSyntaxErrors() > 0 || lexer.getNumberOfSyntaxErrors() > 0) {
            ((InputStream)is).close();
            reader.close();
            return false;
        }
        CommonTree t = result.getTree();
        CommonTreeNodeStream treeStream = new CommonTreeNodeStream(t);
        treeStream.setTokenStream(tokens);
        smaliTreeWalker dexGen = new smaliTreeWalker(treeStream);
        dexGen.setApiLevel(apiLevel);
        dexGen.setVerboseErrors(verboseErrors);
        dexGen.setDexBuilder(dexBuilder);
        dexGen.smali_file();
        ((InputStream)is).close();
        reader.close();
        return dexGen.getNumberOfSyntaxErrors() == 0;
    }
}

