/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.orthogonalsupport;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PriorityQueue;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.EmbeddedPlanarGraph;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.Face;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.FlowNetwork;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.OrthogonalRepresentation;

public class MinimumBendOrthogonalizer {
    public Collection<OrthogonalRepresentation> orthogonalize(Collection<EmbeddedPlanarGraph> collection) {
        ArrayList<OrthogonalRepresentation> arrayList = new ArrayList<OrthogonalRepresentation>();
        for (EmbeddedPlanarGraph embeddedPlanarGraph : collection) {
            FlowNetwork flowNetwork = FlowNetwork.createGraph(embeddedPlanarGraph);
            this.computeMinimumCostFlowNetwork(flowNetwork);
            flowNetwork.removeSourceAndSink();
            OrthogonalRepresentation orthogonalRepresentation = this.computeOrthogonalRepresentation(flowNetwork);
            arrayList.add(orthogonalRepresentation);
        }
        return arrayList;
    }

    private void computeMinimumCostFlowNetwork(FlowNetwork flowNetwork) {
        FlowNetwork.ResidualFlowNetwork residualFlowNetwork = new FlowNetwork.ResidualFlowNetwork(flowNetwork);
        int n = 0;
        int n2 = flowNetwork.getSource().getProduction();
        while (n < n2) {
            Collection<FlowNetwork.ResidualArc> collection = this.computeDijkstraShortestPath(residualFlowNetwork);
            if (collection == null) {
                return;
            }
            int n3 = Integer.MAX_VALUE;
            for (FlowNetwork.Arc arc : collection) {
                int n4 = arc.getCapacity();
                if (n4 >= n3) continue;
                n3 = n4;
            }
            n += n3;
            for (FlowNetwork.ResidualArc residualArc : collection) {
                FlowNetwork.Arc arc = residualArc.getArc();
                FlowNetwork.ResidualArc residualArc2 = null;
                FlowNetwork.ResidualArc residualArc3 = null;
                int n5 = n3;
                if (!residualArc.isReverse()) {
                    residualArc2 = residualArc;
                    residualArc3 = residualFlowNetwork.getReverseResidualArcFromArc(arc);
                } else {
                    n5 = -n5;
                    residualArc3 = residualArc;
                    residualArc2 = residualFlowNetwork.getResidualArcFromArc(arc);
                }
                arc.addFlow(n5);
                residualArc2.substractCapacity(n5);
                residualArc3.addCapacity(n5);
                residualArc3.setFlow(arc.getFlow());
            }
        }
    }

    private Collection<FlowNetwork.ResidualArc> computeDijkstraShortestPath(FlowNetwork.ResidualFlowNetwork residualFlowNetwork) {
        Collection<FlowNetwork.Node> collection = residualFlowNetwork.getNodes();
        HashMap<FlowNetwork.Node, FlowNetwork.ResidualArc> hashMap = new HashMap<FlowNetwork.Node, FlowNetwork.ResidualArc>();
        HashMap<FlowNetwork.Node, Integer> hashMap2 = new HashMap<FlowNetwork.Node, Integer>();
        FlowNetwork.Node node = residualFlowNetwork.getSource();
        for (FlowNetwork.Node hashSet2 : collection) {
            hashMap2.put(hashSet2, Integer.MAX_VALUE);
        }
        hashMap2.put(node, 0);
        PriorityQueue<FlowNetwork.Node> priorityQueue = this.createPriorityQueue(hashMap2);
        for (FlowNetwork.Node node2 : collection) {
            priorityQueue.offer(node2);
        }
        HashSet<FlowNetwork.Node> hashSet = new HashSet<FlowNetwork.Node>();
        while (priorityQueue.size() > 0) {
            FlowNetwork.Node node3 = (FlowNetwork.Node)priorityQueue.poll();
            if ((Integer)hashMap2.get(node3) == Integer.MAX_VALUE || hashSet.contains(node3)) continue;
            for (FlowNetwork.Arc arc : node3.getOutputArcs()) {
                if (arc.getCapacity() <= 0) continue;
                this.computeRelaxation(arc, hashMap, hashMap2, priorityQueue);
            }
            hashSet.add(node3);
        }
        ArrayList<FlowNetwork.ResidualArc> arrayList = new ArrayList<FlowNetwork.ResidualArc>();
        Object object = residualFlowNetwork.getSink();
        while (object != node) {
            FlowNetwork.Arc arc;
            arc = (FlowNetwork.Arc)hashMap.get(object);
            if (arc == null) {
                return null;
            }
            arrayList.add((FlowNetwork.ResidualArc)arc);
            object = arc.getSourceNode();
        }
        return arrayList;
    }

    private void computeRelaxation(FlowNetwork.Arc arc, Map<FlowNetwork.Node, FlowNetwork.ResidualArc> map, Map<FlowNetwork.Node, Integer> map2, PriorityQueue<FlowNetwork.Node> priorityQueue) {
        int n;
        FlowNetwork.Node node = arc.getSourceNode();
        FlowNetwork.Node node2 = arc.getDestinationNode();
        int n2 = map2.get(node);
        int n3 = map2.get(node2);
        if (n3 > n2 + (n = arc.getCost())) {
            map2.put(node2, n2 + n);
            map.put(node2, (FlowNetwork.ResidualArc)arc);
            priorityQueue.offer(node2);
        }
    }

    private PriorityQueue<FlowNetwork.Node> createPriorityQueue(final Map<FlowNetwork.Node, Integer> map) {
        return new PriorityQueue<FlowNetwork.Node>(map.size(), new Comparator<FlowNetwork.Node>(){

            @Override
            public int compare(FlowNetwork.Node node, FlowNetwork.Node node2) {
                int n;
                int n2 = (Integer)map.get(node);
                if (n2 < (n = ((Integer)map.get(node2)).intValue())) {
                    return -1;
                }
                if (n2 == n) {
                    return 0;
                }
                return 1;
            }

            @Override
            public boolean equals(Object object) {
                return this == object;
            }
        });
    }

    private OrthogonalRepresentation computeOrthogonalRepresentation(FlowNetwork flowNetwork) {
        OrthogonalRepresentation orthogonalRepresentation = OrthogonalRepresentation.createGraph(flowNetwork.getOriginalGraph());
        for (FlowNetwork.Arc arc : flowNetwork.getArcs()) {
            int n;
            int n2;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            if (arc.isVertexArc()) {
                object5 = arc.getSourceNode().getVertex();
                object4 = arc.getDestinationNode().getFace();
                object3 = orthogonalRepresentation.getShape((Face)object4);
                object2 = arc.getDart();
                object = ((OrthogonalRepresentation.OrthogonalShape)object3).getTuple((Face.Dart)object2);
                ((OrthogonalRepresentation.Tuple)object).setAngles(arc.getFlow() + 1);
                continue;
            }
            if (!arc.isFaceArc()) continue;
            object5 = arc.getSourceNode();
            object4 = arc.getDestinationNode();
            object3 = ((FlowNetwork.Node)object5).getFace();
            object2 = ((FlowNetwork.Node)object4).getArcToVia((FlowNetwork.Node)object5, arc.getDart());
            object = orthogonalRepresentation.getShape((Face)object3);
            Face.Dart dart = arc.getDart();
            OrthogonalRepresentation.Tuple tuple = ((OrthogonalRepresentation.OrthogonalShape)object).getTuple(dart);
            BitSet bitSet = tuple.getBends();
            int n3 = arc.getFlow();
            int n4 = n3 + (n2 = ((FlowNetwork.Arc)object2).getFlow());
            if (n4 == 0) continue;
            for (n = 0; n < n3; ++n) {
                bitSet.clear(n);
            }
            for (n = n3; n < n4; ++n) {
                bitSet.set(n);
            }
            bitSet.set(n4);
        }
        return orthogonalRepresentation;
    }
}

