﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using WeiSha.Common;
using WeiSha.Data;
namespace Demo
{
    public partial class WebForm1 : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            Label1.Text = "Hello World!";

            //获取条个记录,ToFirst
            Song.Entities.Book book = Gateway.Default.From<Song.Entities.Book>()
                   .ToFirst<Song.Entities.Book>();

            //获取数据记录的集合
            Song.Entities.Book[] books = Gateway.Default.From<Song.Entities.Book>()
               .ToArray<Song.Entities.Book>();
            //按条件获取
            books = Gateway.Default.From<Song.Entities.Book>()
                .Where(Song.Entities.Book._.Author == "作者名称")
               .ToArray<Song.Entities.Book>();

            //分页获取
            int size = 10;  //每页显示的条数
            int index = 1;  //页码，
            books = Gateway.Default.From<Song.Entities.Book>()
               .ToArray<Song.Entities.Book>(size, (index - 1) * size);

            //排序
            books = Gateway.Default.From<Song.Entities.Book>()
                .Where(Song.Entities.Book._.Author == "作者名称")
                .OrderBy(Song.Entities.Book._.ID.Desc)
               .ToArray<Song.Entities.Book>();

            //求和
            int sum = 0;
            int.TryParse(Gateway.Default.Sum<Song.Entities.Book>(Song.Entities.Book._.ID, null).ToString(),
                out sum);
            //求平均值
            int avg = 0;
            int.TryParse(Gateway.Default.Avg<Song.Entities.Book>(Song.Entities.Book._.ID, null).ToString(),
                out avg);
            //求记录数
            int count = Gateway.Default.Count<Song.Entities.Book>(null);
            //取最大值，此为取最大的id
            int max = 0;
            int.TryParse(Gateway.Default.Max<Song.Entities.Book>(Song.Entities.Book._.ID, null).ToString(),
                out max);
            //取最小值
            int min = 0;
            int.TryParse(Gateway.Default.Min<Song.Entities.Book>(Song.Entities.Book._.ID, null).ToString(),
                out min);

        }
    }
}