namespace Song.Entities {
    	using System;
    	
    	
    	/// <summary>
    	/// 表名：Book 主键列：ID
    	/// </summary>
    	[SerializableAttribute()]
    	public partial class Book : WeiSha.Data.Entity {
    		
    		protected Int32 _ID;
    		
    		protected String _Name;
    		
    		protected String _Author;
    		
    		protected String _Type;
    		
    		protected String _Coder;
    		
    		public Int32 ID {
    			get {
    				return this._ID;
    			}
    			set {
    				this.OnPropertyValueChange(_.ID, _ID, value);
    				this._ID = value;
    			}
    		}
    		
    		public String Name {
    			get {
    				return this._Name;
    			}
    			set {
    				this.OnPropertyValueChange(_.Name, _Name, value);
    				this._Name = value;
    			}
    		}
    		
    		public String Author {
    			get {
    				return this._Author;
    			}
    			set {
    				this.OnPropertyValueChange(_.Author, _Author, value);
    				this._Author = value;
    			}
    		}
    		
    		public String Type {
    			get {
    				return this._Type;
    			}
    			set {
    				this.OnPropertyValueChange(_.Type, _Type, value);
    				this._Type = value;
    			}
    		}
    		
    		public String Coder {
    			get {
    				return this._Coder;
    			}
    			set {
    				this.OnPropertyValueChange(_.Coder, _Coder, value);
    				this._Coder = value;
    			}
    		}
    		
    		/// <summary>
    		/// 获取实体对应的表名
    		/// </summary>
    		protected override WeiSha.Data.Table GetTable() {
    			return new WeiSha.Data.Table<Book>("Book");
    		}
    		
    		/// <summary>
    		/// 获取实体中的标识列
    		/// </summary>
    		protected override WeiSha.Data.Field GetIdentityField() {
    			return _.ID;
    		}
    		
    		/// <summary>
    		/// 获取实体中的主键列
    		/// </summary>
    		protected override WeiSha.Data.Field[] GetPrimaryKeyFields() {
    			return new WeiSha.Data.Field[] {
    					_.ID};
    		}
    		
    		/// <summary>
    		/// 获取列信息
    		/// </summary>
    		protected override WeiSha.Data.Field[] GetFields() {
    			return new WeiSha.Data.Field[] {
    					_.ID,
    					_.Name,
    					_.Author,
    					_.Type,
    					_.Coder};
    		}
    		
    		/// <summary>
    		/// 获取列数据
    		/// </summary>
    		protected override object[] GetValues() {
    			return new object[] {
    					this._ID,
    					this._Name,
    					this._Author,
    					this._Type,
    					this._Coder};
    		}
    		
    		/// <summary>
    		/// 给当前实体赋值
    		/// </summary>
    		protected override void SetValues(WeiSha.Data.IRowReader reader) {
    			if ((false == reader.IsDBNull(_.ID))) {
    				this._ID = reader.GetInt32(_.ID);
    			}
    			if ((false == reader.IsDBNull(_.Name))) {
    				this._Name = reader.GetString(_.Name);
    			}
    			if ((false == reader.IsDBNull(_.Author))) {
    				this._Author = reader.GetString(_.Author);
    			}
    			if ((false == reader.IsDBNull(_.Type))) {
    				this._Type = reader.GetString(_.Type);
    			}
    			if ((false == reader.IsDBNull(_.Coder))) {
    				this._Coder = reader.GetString(_.Coder);
    			}
    		}
    		
    		public override int GetHashCode() {
    			return base.GetHashCode();
    		}
    		
    		public override bool Equals(object obj) {
    			if ((obj == null)) {
    				return false;
    			}
    			if ((false == typeof(Book).IsAssignableFrom(obj.GetType()))) {
    				return false;
    			}
    			if ((((object)(this)) == ((object)(obj)))) {
    				return true;
    			}
    			return false;
    		}
    		
    		public class _ {
    			
    			/// <summary>
    			/// 表示选择所有列，与*等同
    			/// </summary>
    			public static WeiSha.Data.AllField All = new WeiSha.Data.AllField<Book>();
    			
    			/// <summary>
    			/// 字段名：ID - 数据类型：Int32
    			/// </summary>
    			public static WeiSha.Data.Field ID = new WeiSha.Data.Field<Book>("ID");
    			
    			/// <summary>
    			/// 字段名：Name - 数据类型：String
    			/// </summary>
    			public static WeiSha.Data.Field Name = new WeiSha.Data.Field<Book>("Name");
    			
    			/// <summary>
    			/// 字段名：Author - 数据类型：String
    			/// </summary>
    			public static WeiSha.Data.Field Author = new WeiSha.Data.Field<Book>("Author");
    			
    			/// <summary>
    			/// 字段名：Type - 数据类型：String
    			/// </summary>
    			public static WeiSha.Data.Field Type = new WeiSha.Data.Field<Book>("Type");
    			
    			/// <summary>
    			/// 字段名：Coder - 数据类型：String
    			/// </summary>
    			public static WeiSha.Data.Field Coder = new WeiSha.Data.Field<Book>("Coder");
    		}
    	}
    }
