﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using WeiSha.Common;
using WeiSha.Data;

namespace Demo
{
    public partial class Edit : System.Web.UI.Page
    {
        //获取传递过来的Id，如果不存在，则为0
        private int id = WeiSha.Common.Request.QueryString["id"].Int32 ?? 0;
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                //获取当前书本的对象
                Song.Entities.Book book = Gateway.Default.From<Song.Entities.Book>()
                    .Where(Song.Entities.Book._.ID == id).ToFirst<Song.Entities.Book>();
                //填充到界面
                WeiSha.Common.Data.EntityBind(this, book);
            }
        }
        /// <summary>
        /// 编辑按钮的事件
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void btnEdit_Click(object sender, EventArgs e)
        {
            //获取当前书本的对象
            Song.Entities.Book book = Gateway.Default.From<Song.Entities.Book>()
                .Where(Song.Entities.Book._.ID == id).ToFirst<Song.Entities.Book>();
            //将界面上填写的信息，填充到书本对象
            book = WeiSha.Common.Data.EntityFill(this, book) as Song.Entities.Book;
            //将对象保存到数据库
            Gateway.Default.Save<Song.Entities.Book>(book);
            //返回列表页
            btnBack_Click(null, null);
        }

        protected void btnBack_Click(object sender, EventArgs e)
        {
            Response.Redirect("list.aspx");
        }
    }
}