import vimeo
import base64
import random
import traceback
import json
from ctypes import *
import os
from baseau import *
from apiclient.discovery import build

class VimeoAU(BaseAU):
    def __init__(self):
        BaseAU.__init__(self)
        self.state = ''
        self.scope = ['public', 'private', 'upload', 'edit']
        self.userInfo = ''
        self.vimeo = None

    def SetBrand(self,brand):
        if brand == 'wondershare':
            self.appId = '63f0546aa26b1ead0cf6363ef965518dcb597e05'
            self.appSecret = '9530378a1c87ba84f23b5e1d34ca4430b4424392'
            self.redirectURL = 'http://pop.wondershare.com/filmora/sns-authorization.html'

    def GetLoginURL(self):
        vimeo_authorization_url = ''
        try:
            v = vimeo.VimeoClient(key=self.appId, secret=self.appSecret)
            self.state = base64.b64encode(str(random.uniform(1, 100)))
            vimeo_authorization_url = v.auth_url(self.scope, self.redirectURL, self.state)
        except:
            vimeo_authorization_url = '%s' % traceback.format_exc()

        return vimeo_authorization_url

    def Logout(self):
        return

    def VerifyRedirectURL(self,url):
        if url.find(self.redirectURL) == 0:
            uri = urlparse.urlparse(url)
            paramlist = urlparse.parse_qs(uri.query)
            if paramlist.has_key('code'):
                try:
                    v = vimeo.VimeoClient(key=self.appId, secret=self.appSecret)
                    self.accessToken, self.userInfo, self.scope = v.exchange_code(paramlist['code'][0], self.redirectURL)
                    self.vimeo = v
                    self.UpdateInfo()
                    return BaseAU.VerifyCode.S_OK
                except vimeo.auth.GrantFailed, e:
                    self.accessError = 'Vimeo Auth GrantFailed'
            if paramlist.has_key('error'):
                self.accessError = paramlist['error'][0]
            return BaseAU.VerifyCode.E_FAILED
        return BaseAU.VerifyCode.E_INVALIDARG

    def UpdateInfo(self):
        if self.vimeo:
            about_me = self.vimeo.get('/me')
            if about_me.status_code != 200:
                self.accessError = about_me.reason
                return False
            try:
                self.userInfo = about_me.json()
                self.userName = self.userInfo['name']
                self.limit_file_size = long(self.userInfo['upload_quota']['space']['free'])
                self.video_hd = bool(self.userInfo['upload_quota']['quota']['hd'])
                self.video_sd = bool(self.userInfo['upload_quota']['quota']['sd'])
                return True
            except AttributeError, e:
                self.accessError = e.message
            except KeyError, e:
                self.accessError = 'KeyError:'+ e.message
        return False

    def SetAccessToken(self, token):
        self.accessToken = token
        self.vimeo = vimeo.VimeoClient(token=self.accessToken, key=self.appId, secret=self.appSecret)
        return self.UpdateInfo()

    def start_upload(self):
        if self.vimeo == None:
            self.SendMessage(self.Event.MSG_TOKEN_INVALID, self.accessError)
            return
        try:
            video_uri = self.vimeo.upload(self.filepath, uploadparam=self)
            if video_uri:
                privacy = {}
                privacy['view'] = self.privacy
                response = self.vimeo.patch(video_uri, data={'name': self.title, 'description': self.desc, 'privacy': privacy})
                print response
                content = json.JSONDecoder().decode(response.content)
                self.vimeo.put(video_uri + '/tags/' + self.tags)
                print response
                self.SendMessage(self.Event.MSG_FINISH, content['link'])
                return;
        except Exception, e:
            self.accessError = str(e)
            if self.accessError.find('access token') >= 0:
                self.SendMessage(self.Event.MSG_TOKEN_INVALID, self.accessError)
            else:
                self.SendMessage(self.Event.MSG_ERROR, self.accessError)

def CreateVimeoInstance():
    return VimeoAU()

# if __name__ == '__main__':
#     v = CreateVimeoInstance()
#     v.SetBrand('wondershare')
#     print v.GetLoginURL()
#     c = raw_input('input :')
#     v.VerifyRedirectURL(c)
#     # v.SetAccessToken('13ab38dbe79ce80b61f833cc939feda4')
#     print 'AccessToken=', v.GetAccessToken()
#     print 'UserName=', v.GetUserName()
#     v.StartUpload('D:/My Document/Videos/TubeDigger/nnngoedl.mp4', 'hello','vimeo','nobody','first,wondershare filmora','other')
#     # v.Wait()