import urlparse
from twitch import TwitchClient
import requests
from baseau import *
import os

class TwitchAU(BaseAU):
    def __init__(self):
        BaseAU.__init__(self)
        self.scope = ['user_read','channel_read','channel_editor']
        self.userInfo = []
        self.client = None
        self.channel_id = 0

    def start_upload(self):
        video = self.client.videos
        try:
            # check oauth_token valid
            self.client.users.get()
            url = video.upload_video(channel_id=self.channel_id, title=self.title, desc=self.desc, path=self.filepath, tags=self.tags, privacy=self.privacy, uploadparam=self)
            self.SendMessage(self.Event.MSG_FINISH, str(url))
        except requests.HTTPError, e:
            self.SendMessage(self.Event.MSG_ERROR, e.message)
        except Exception, e:
            self.SendMessage(self.Event.MSG_ERROR, str(e))
        return

    def SetBrand(self, brand):
        if brand == 'wondershare':
            self.appId = 'e1iax5mnkn1rfo0oskqz6vruknoe8w'
            self.appSecret = 'v87xzy1orb3xwt8c4w0jdo832qmmin'
            self.redirectURL = 'http://pop.wondershare.com/filmora/sns-authorization.html'

    def GetLoginURL(self):
        client = TwitchClient(client_id=self.appId)
        authorization_url = client.auth_url(self.appId, self.appSecret, self.redirectURL, self.scope)
        return authorization_url

    def Logout(self):
        return

    def VerifyRedirectURL(self, url):
        if url.find(self.redirectURL) == 0:
            uri = urlparse.urlparse(url)
            fragment = urlparse.parse_qs(uri.fragment)
            paramlist = urlparse.parse_qs(uri.query)
            if fragment.has_key('access_token'):
                if self.SetAccessToken(fragment['access_token'][0]) == True:
                    return 0
            if paramlist.has_key('error_code'):
                if paramlist.has_key('error_description'):
                    self.accessError = paramlist['error_description'][0]
                elif paramlist.has_key('error_message'):
                    self.accessError = paramlist['error_message'][0]
                elif paramlist.has_key('error'):
                    self.accessError = paramlist['error'][0]
                self.accessError = '(' + paramlist['error_code'][0] + ') ' + self.accessError
            return BaseAU.VerifyCode.E_FAILED
        return BaseAU.VerifyCode.E_INVALIDARG

    def SetAccessToken(self, token):
        self.accessToken = token
        try:
            self.client = TwitchClient(client_id=self.appId, oauth_token=self.accessToken)
            user = self.client.users
            channels = self.client.channels
            channel = channels.get()
            self.channel_id = channel['id']
            self.userInfo = user.get()
            self.userName = self.userInfo['display_name']
        except requests.HTTPError, e:
            self.accessError = e.message
            print e.message
            return False
        return True

def CreateTwitchInstance():
    return TwitchAU()

# if __name__ == '__main__':
#     facebookau = CreateFacebookInstance()
#     facebookau.SetBrand('wondershare')
#     print facebookau.GetLoginURL()
#     c = raw_input('input :')
#     facebookau.VerifyRedirectURL(c)
# #  facebookau.SetAccessToken('CAAED8qP7qZC0BAHCLIyFRZAeIIVmRwewrwrZAMJiEZCbZApvahWfT4SIc8jsR4I80GwXX4mYRJDyLUuRthlZC9sYZAIN5zoobFMM7i7kaBHfxy0lYHKGfZBxZAmDVkpToMxKK4CZBxtnHSeNDr7uOOIqNFRv7mSB9aod0pB8tOW2o7RCvZCEgnkx5xah7E3dtvkZBFMZC4e5p1sKJ5QZDZD')
#     print facebookau.GetUserName()
#     # facebookau.Logout()
#     # facebookau.StartUpload('/Users/chenming/Movies/Wondershare Filmora/Output/My Video-2.mov', 'Hello time', 'test desc', '', 'wondershare filmora', 'public')
