import os
import base64
import random
from ConfigParser import ConfigParser

from .api import (
    ChannelFeed, Channels, Chat, Clips, Collections, Communities,
    Games, Ingests, Search, Streams, Teams, Users, Videos
)
from .constants import CONFIG_FILE_PATH
import requests
try:
    from urllib.parse import parse_qs, urlencode
except ImportError:
    from urlparse import parse_qs
    from urllib import urlencode


class TwitchClient(object):
    def __init__(self, client_id=None, oauth_token=None):
        self._client_id = client_id
        self._oauth_token = oauth_token

        if not client_id:
            self._read_credentials_from_file()

        self._clips = None
        self._channel_feed = None
        self._channels = None
        self._chat = None
        self._collections = None
        self._communities = None
        self._games = None
        self._ingests = None
        self._search = None
        self._streams = None
        self._teams = None
        self._users = None
        self._videos = None

    def auth_url(self, app_id, secret_id, canvas_url, perms=None, **kwargs):
        url = "https://api.twitch.tv/kraken/oauth2/authorize?"
        kvps = {'client_id': app_id,
                'state':base64.b64encode(str(random.uniform(1, 100))),
                'response_type':'token',
                'redirect_uri': canvas_url,
                'force_verify':'true'}
        if perms:
            kvps['scope'] = "+".join(perms)
        kvps.update(kwargs)
        kvps = kvps.items()
        l = []
        for k, v in kvps:
            k = str(k)
            v = str(v)
            l.append(k + '=' + v)
        return url + '&'.join(l)

    def revoke(self):
        url = "https://api.twitch.tv/kraken/oauth2/revoke?"
        complete_url = url + 'client_id=%s' % self._client_id + '&token=%s' % self._oauth_token
        response = requests.post(complete_url)

    def _read_credentials_from_file(self):
        config = ConfigParser()
        config.read(os.path.expanduser(CONFIG_FILE_PATH))

        if 'Credentials' in config.sections():
            self._client_id = config['Credentials'].get('client_id')
            self._oauth_token = config['Credentials'].get('oauth_token')

    @property
    def channel_feed(self):
        if not self._channel_feed:
            self._channel_feed = ChannelFeed(
                client_id=self._client_id, oauth_token=self._oauth_token)
        return self._channel_feed

    @property
    def clips(self):
        if not self._clips:
            self._clips = Clips(
                client_id=self._client_id, oauth_token=self._oauth_token)
        return self._clips

    @property
    def channels(self):
        if not self._channels:
            self._channels = Channels(
                client_id=self._client_id, oauth_token=self._oauth_token)
        return self._channels

    @property
    def chat(self):
        if not self._chat:
            self._chat = Chat(
                client_id=self._client_id, oauth_token=self._oauth_token)
        return self._chat

    @property
    def collections(self):
        if not self._collections:
            self._collections = Collections(
                client_id=self._client_id, oauth_token=self._oauth_token)
        return self._collections

    @property
    def communities(self):
        if not self._communities:
            self._communities = Communities(
                client_id=self._client_id, oauth_token=self._oauth_token)
        return self._communities

    @property
    def games(self):
        if not self._games:
            self._games = Games(
                client_id=self._client_id, oauth_token=self._oauth_token)
        return self._games

    @property
    def ingests(self):
        if not self._ingests:
            self._ingests = Ingests(
                client_id=self._client_id, oauth_token=self._oauth_token)
        return self._ingests

    @property
    def search(self):
        if not self._search:
            self._search = Search(
                client_id=self._client_id, oauth_token=self._oauth_token)
        return self._search

    @property
    def streams(self):
        if not self._streams:
            self._streams = Streams(
                client_id=self._client_id, oauth_token=self._oauth_token)
        return self._streams

    @property
    def teams(self):
        if not self._teams:
            self._teams = Teams(
                client_id=self._client_id, oauth_token=self._oauth_token)
        return self._teams

    @property
    def users(self):
        if not self._users:
            self._users = Users(
                client_id=self._client_id, oauth_token=self._oauth_token)
        return self._users

    @property
    def videos(self):
        if not self._videos:
            self._videos = Videos(
                client_id=self._client_id, oauth_token=self._oauth_token)
        return self._videos
