from twitch.api.base import TwitchAPI
from twitch.constants import BROADCAST_TYPE_HIGHLIGHT, BROADCATS_TYPES, PERIODS, PERIOD_WEEK
from twitch.decorators import oauth_required
from twitch.exceptions import TwitchAttributeException
from twitch.resources import Video
import os
import requests

class Videos(TwitchAPI):

    def get_by_id(self, video_id):
        response = self._request_get('videos/%s' % video_id)
        return Video.construct_from(response)

    def get_top(self, limit=10, offset=0, game=None, period=PERIOD_WEEK,
                broadcast_type=BROADCAST_TYPE_HIGHLIGHT):
        if limit > 100:
            raise TwitchAttributeException(
                'Maximum number of objects returned in one request is 100')
        if period not in PERIODS:
            raise TwitchAttributeException('Period is not valid. Valid values are %s' % PERIODS)
        if broadcast_type not in BROADCATS_TYPES:
            raise TwitchAttributeException(
                'Broadcast type is not valid. Valid values are %s' % BROADCATS_TYPES)

        params = {
            'limit': limit,
            'offset': offset,
            'game': game,
            'period': period,
            'broadcast_type': broadcast_type
        }

        response = self._request_get('videos/top', params=params)
        return [Video.construct_from(x) for x in response['vods']]

    @oauth_required
    def get_followed_videos(self, limit=10, offset=0, broadcast_type=BROADCAST_TYPE_HIGHLIGHT):
        if limit > 100:
            raise TwitchAttributeException(
                'Maximum number of objects returned in one request is 100')
        if broadcast_type not in BROADCATS_TYPES:
            raise TwitchAttributeException(
                'Broadcast type is not valid. Valid values are %s' % BROADCATS_TYPES)

        params = {
            'limit': limit,
            'offset': offset,
            'broadcast_type': broadcast_type
        }

        response = self._request_get('videos/followed', params=params)
        return [Video.construct_from(x) for x in response['videos']]

    @oauth_required
    def upload_video(self, channel_id, path, title, desc='', privacy='', tags='', uploadparam=None):

        f = open(path, 'rb')
        file_size = os.path.getsize(path)

        params = {
            'channel_id': channel_id,
            'title': title,
            'description':desc,
            'tag_list':tags,
            'viewable':privacy
        }

        response = self._request_post('videos', params=params)

        upload_url = response['upload']['url'];#https://uploads.twitch.tv/upload/201159942'
        upload_token = response['upload']['token']
        result_url = response['video']['url']

        chunk_size = max(5 * 1024 * 1024, min(file_size / 100, 10 * 1024 * 1024))
        chunk_more = file_size % chunk_size
        start_offset = 0
        idx = 1
        while start_offset < file_size:
            if uploadparam.stop:
                break;
            chunk = f.read(chunk_size + chunk_more)
            chunk_more = 0
            if not chunk:
                break

            url = upload_url + '?part=%d' % idx + '&upload_token=%s' % upload_token
            try:
                response = self._request_put(url, data=chunk, data_json=False)
                start_offset += len(chunk)
                uploadparam.SendMessage(uploadparam.Event.MSG_PROGRESS, str(int(start_offset * 100 / file_size)))
                idx = idx+1
            except requests.HTTPError, e:
                f.close()
                raise e
        f.close()

        complete_url = upload_url + '/complete?upload_token=%s' % upload_token
        response = requests.post(complete_url)
        response.raise_for_status()
        return result_url

