import json
import httplib2
from apiclient import discovery
from oauth2client import client
from oauth2client import file
from youtube_upload import main
import sys
import os
from apiclient.discovery import build
import base64
import StringIO
from baseau import *

class GoogleAU(BaseAU):
    def __init__(self):
        BaseAU.__init__(self)
        self.scope = 'https://www.googleapis.com/auth/userinfo.profile ' \
                 'https://www.googleapis.com/auth/youtube.upload https://www.googleapis.com/auth/youtube.readonly'
        self.code = ''
        self.credentials = None
        self.flow = None
        home = os.path.expanduser("~")
        self.credentialsfile = os.path.join(home, ".youtube-upload-credentials.json")

    def SetBrand(self, brand):
        if brand == 'wondershare':
            self.appId = '867604994458-35auu5smi7rh5padj8jnk9vd0qh8thoe.apps.googleusercontent.com'
            self.appSecret = 'abtqV-2p1cxKpWHtcFpXnA3K'
            self.redirectURL = 'https://filmora.wondershare.com/filmora/sns-authorization.html'


    def GetLoginURL(self):
        if self.flow == None:
            self.flow = client.OAuth2WebServerFlow(
                client_id =self.appId,
                client_secret=self.appSecret,
                scope=self.scope,
                access_type='offline',
                include_granted_scopes='true',
                redirect_uri=self.redirectURL)
        authURI = self.flow.step1_get_authorize_url()
        return authURI
    
    def Logout(self):
        if self.credentials != None:
            self.credentials.revoke(httplib2.Http())
        return
    
    def VerifyRedirectURL(self, url):
        if url.find(self.redirectURL) == 0:
            uri = urlparse.urlparse(url)
            paramlist = urlparse.parse_qs(uri.query)
            if paramlist.has_key('code'):
                try:
                    self.credentials = self.flow.step2_exchange(paramlist['code'][0])
                    if  self.UpdateInfo() == True:
                        storage = file.Storage(self.credentialsfile)
                        storage.put(self.credentials)
                        return BaseAU.VerifyCode.S_OK
                except client.FlowExchangeError, e:
                    self.accessError = e.message
            if paramlist.has_key('error'):
                self.accessError = paramlist['error'][0]
            return BaseAU.VerifyCode.E_FAILED
        return BaseAU.VerifyCode.E_INVALIDARG


    def SetAccessToken(self, tokeninfo):
        try:
            token = base64.decodestring(tokeninfo)
            self.credentials = client.Credentials.new_from_json(token)
            if self.credentials.refresh_token == None: # need re-login
                self.credentials.revoke(httplib2.Http())
                return False
            if  self.UpdateInfo() == True:
                storage = file.Storage(self.credentialsfile)
                storage.put(self.credentials)
                return True
        except:
            self.accessError = 'invalid token.'
        return False

    def UpdateInfo(self):
        try:
            users_service = build("oauth2", "v2", http=self.credentials.authorize(httplib2.Http()))
            user_document = users_service.userinfo().get().execute()
            self.userName = user_document['name']
            youtube = build("youtube", "v3", http=self.credentials.authorize(httplib2.Http()))
            cat = youtube.videoCategories().list(part="snippet",regionCode="us").execute()
            all = cat['items']
            cats = []
            for it in all:
                if it['snippet']['assignable'] == True:
                    cats.append(it['snippet']['title'])
            self.videoCategories = '|'.join(cats)
            return True
        except Exception, e:
            self.accessError = str(e)
            return False

    def GetAccessToken(self):
        return base64.encodestring(self.credentials.to_json())
    
    def start_upload(self):
        arguments = []
        arguments.append('--credentials-file=%s' % self.credentialsfile)
        arguments.append('--title=%s' % self.title)
        if len(self.desc) > 0:
            arguments.append('--description=%s' % self.desc)
        if len(self.category) > 0:
            arguments.append('--category=%s' % self.category)
        if len(self.tags) > 0:
            arguments.append('--tags=%s' % self.tags)
        if len(self.privacy) > 0:
            arguments.append('--privacy=%s' % self.privacy)
        if len(self.thumb) > 0:
            arguments.append('--thumbnail=%s' % self.thumb)
        arguments.append(self.filepath)

        try:
            http = httplib2.Http()
            http = self.credentials.authorize(http)
            self.credentials.refresh(http)

            storage = file.Storage(self.credentialsfile)
            storage.put(self.credentials)

            main.upload(arguments, self)
        except client.AccessTokenRefreshError, e:
            self.SendMessage(self.Event.MSG_TOKEN_INVALID, e.message)
        except main.AuthenticationError, e:
            self.SendMessage(self.Event.MSG_TOKEN_INVALID, e.message)
        except Exception, e:
            self.SendMessage(self.Event.MSG_ERROR,str(e))

def CreateGoogleInstance():
    return GoogleAU()

# if __name__ == '__main__':
#     ytb = CreateGoogleInstance()
#     ytb.SetBrand('wondershare')
#     print ytb.GetLoginURL()
#     c = raw_input('input :')
#     ytb.VerifyRedirectURL(c)
#     print ytb.GetUserName()
#     ytb.Logout()
#     # ytb.SetAccessToken('aaa')
#     # ytb.StartUpload('D:/My Document/Videos/TubeDigger/nnngoedl.mp4', 'Happy Lulu','my baby', 'private', 'Film & Animation')
#