import urlparse
import facebook
import facebookads
from facebookads.objects import *
from facebookads.exceptions import FacebookRequestError
from baseau import *

class FacebookAU(BaseAU):
    def __init__(self):
        BaseAU.__init__(self)
        self.scope = ['email', 'user_photos', 'user_posts', 'user_videos', 'publish_stream', 'publish_actions']
        self.graph = None
        self.userInfo = []

    def start_sharing(self):
        if self.graph == None:
            self.SendMessage(4, self.accessError)
            return
        attachment =  {
            'link':self.link_url,
        }
        try:
            self.graph.put_wall_post(message=self.message, attachment=attachment)
        except Exception, e:
            self.SendMessage(3, str(e))

    def start_upload(self):
        if self.graph == None:
            self.SendMessage(4, self.accessError)
            return
        gSession = facebookads.FacebookSession(self.appId, self.appSecret, self.accessToken)
        facebookads.FacebookAdsApi.set_default_api(facebookads.FacebookAdsApi(gSession))
        try:
            video = AdVideo(parent_id=self.userInfo['id'])
            video[AdVideo.Field.filepath] = self.filepath
            video[AdVideo.Field.title] = self.title
            video[AdVideo.Field.description] = self.desc
            response = video.remote_create(uploadparam = self)
            self.SendMessage(self.Event.MSG_FINISH, 'https://www.facebook.com/' + video._data['id'])
        except FacebookRequestError, e:
            if str(e.body()).find('OAuthException') > -1:
                self.SendMessage(self.Event.MSG_TOKEN_INVALID, str(e.body()))
            else:
                self.SendMessage(self.Event.MSG_ERROR, str(e.body()))
        except KeyError:
            self.SendMessage(self.Event.MSG_ERROR, 'Wrong user id.')
        except Exception, e:
            self.SendMessage(self.Event.MSG_ERROR, str(e))

    def SetBrand(self, brand):
        if brand == 'wondershare':
            self.appId = '285815644859389'
            self.appSecret = '8c4af54e67dc07307ab80766383d0613'
            self.redirectURL = 'https://rest.wondershare.com/account/v1/facebook/login'
        elif brand == 'iskysoft':
            self.appId = '917705148272157'
            self.appSecret = '30a92fa36eeae4da1d1ef2e5a54606df'
            self.redirectURL = 'http://filmora.iskysoft.com/redirect'

    def GetLoginURL(self):
        facebook_authorization_url = facebook.auth_url(self.appId, self.redirectURL, self.scope, response_type='token')
        return facebook_authorization_url

    def Logout(self):
        if self.graph != None:
            response = self.graph.request(path='/me/permissions', method='DELETE')
            print response

    def VerifyRedirectURL(self, url):
        if url.find(self.redirectURL) == 0:
            uri = urlparse.urlparse(url)
            fragment = urlparse.parse_qs(uri.fragment)
            paramlist = urlparse.parse_qs(uri.query)
            if fragment.has_key('access_token'):
                if self.SetAccessToken(fragment['access_token'][0]) == True:
                    return 0
            if paramlist.has_key('error_code'):
                if paramlist.has_key('error_description'):
                    self.accessError = paramlist['error_description'][0]
                elif paramlist.has_key('error_message'):
                    self.accessError = paramlist['error_message'][0]
                elif paramlist.has_key('error'):
                    self.accessError = paramlist['error'][0]
                self.accessError = '(' + paramlist['error_code'][0] + ') ' + self.accessError
            return BaseAU.VerifyCode.E_FAILED
        return BaseAU.VerifyCode.E_INVALIDARG

    def SetAccessToken(self, token):
        self.accessToken = token
        try:
            self.graph = facebook.GraphAPI(self.accessToken)
            self.userInfo = self.graph.get_object("me")
            self.userName = self.userInfo['name']
            return True
        except facebook.GraphAPIError, e:
            self.graph = None
            self.accessError = e.message
            print e.message
        return False

def CreateFacebookInstance():
    return FacebookAU()

# if __name__ == '__main__':
#     facebookau = CreateFacebookInstance()
#     facebookau.SetBrand('wondershare')
#     print facebookau.GetLoginURL()
#     c = raw_input('input :')
#     facebookau.VerifyRedirectURL(c)
# #  facebookau.SetAccessToken('CAAED8qP7qZC0BAHCLIyFRZAeIIVmRwewrwrZAMJiEZCbZApvahWfT4SIc8jsR4I80GwXX4mYRJDyLUuRthlZC9sYZAIN5zoobFMM7i7kaBHfxy0lYHKGfZBxZAmDVkpToMxKK4CZBxtnHSeNDr7uOOIqNFRv7mSB9aod0pB8tOW2o7RCvZCEgnkx5xah7E3dtvkZBFMZC4e5p1sKJ5QZDZD')
#     print facebookau.GetUserName()
#     # facebookau.Logout()
#     # facebookau.StartUpload('/Users/chenming/Movies/Wondershare Filmora/Output/My Video-2.mov', 'Hello time', 'test desc', '', 'wondershare filmora', 'public')
