__author__ = 'chenming'

from ctypes import *
import threading
import ntpath
import urlparse


class BaseAU:
    class VerifyCode(object):
        S_OK = 0
        E_INVALIDARG = 1
        E_FAILED = 2
        E_CANCELLED = 3

    class Event(object):
        MSG_PROGRESS = 1
        MSG_FINISH = 2
        MSG_ERROR = 3
        MSG_TOKEN_INVALID = 4
        MSG_DEBUG = 99

    def __init__(self):
        self.appId = ''
        self.appSecret = ''
        self.accessToken = ''
        self.redirectURL = ''
        self.accessError = ''
        self.userName = ''
        self.callback = None
        self.userObj = None
        self.stop = False
        self.filepath = ''
        self.title = ''
        self.desc = ''
        self.privacy = ''
        self.tags = ''
        self.category = ''
        self.thumb = ''
        self.thread = None
        self.limit_file_size = 0
        self.video_hd = True
        self.video_sd = True
        self.videoCategories = ''
        self.redirectURL = 'http://pop.wondershare.com/filmora/sns-authorization.html'
        self.message = ''
        self.link_url = ''
        self.link_name = ''
        self.link_desc = ''
        self.link_caption = ''

    def start_upload(self):
        return

    def start_sharing(self):
        return;

    def SetUserObj(self, userobj):
        self.userObj = userobj

    def SetCallback(self, c_callback):
        PyCObject_AsVoidPtr = PYFUNCTYPE(c_void_p, py_object)(
                              ('PyCObject_AsVoidPtr', pythonapi))
        c_callbackaddr = PyCObject_AsVoidPtr(c_callback)
        CALLBACKFUNC_T = CFUNCTYPE(None, c_longlong, c_int, c_char_p)
        self.callback = CALLBACKFUNC_T(c_callbackaddr)

    def SendMessage(self, event, msg):
        if self.callback and self.stop == False:
            self.callback(self.userObj, event, c_char_p(msg))

    def GetLoginURL(self):
        return ''

    def Logout(self):
        return

    def VerifyRedirectURL(self, url):
        return 1

    def SetRedirectURL(self, url):
        self.redirectURL = url

    def SetAppKey(self, key):
        self.appId = key

    def SetAppSecret(self, secret):
        self.appSecret = secret

    def GetAppKey(self):
        return self.appId

    def GetAppSecret(self):
        return self.appSecret

    def GetAccessToken(self):
        return self.accessToken

    def SetAccessToken(self, token):
        self.accessToken = token

    def GetUserName(self):
        return self.userName

    def GetLimitSpace(self):
        return self.limit_file_size

    def GetVideoHD(self):
        return self.video_hd

    def GetVideoSD(self):
        return self.video_sd

    def GetVideoCategories(self):
        return self.videoCategories

    def UpdateInfo(self):
        return

    def GetLastError(self):
        return self.accessError

    def StartUpload(self, filepath, title='', desc='', privacy='', tags='', category='', thumb=''):
        self.filepath = unicode(filepath, "utf-8")
        self.title = title
        if len(title) <= 0:
            self.title = ntpath.basename(filepath)
        self.desc = desc
        self.privacy = privacy
        self.tags = tags
        self.category = category
        self.thumb = thumb
        self.StopUpload()
        self.thread = threading.Thread(target=self.start_upload)
        self.thread.start()

    def ShareLink(self, message, link, privacy):
        self.message = message
        self.privacy = privacy
        self.link_url = link
        self.thread = threading.Thread(target=self.start_sharing)
        self.thread.start()

    def Wait(self, timeout = None):
        self.thread.join(timeout)

    def StopUpload(self):
        self.stop = True
        if self.thread != None:
            self.Wait()
            self.thread = None
        self.stop = False