
#define BITONIC_BLOCK_SIZE 16

cbuffer CB : register( b0 )
{
	unsigned int width;
	unsigned int height;
	unsigned int shift;
	unsigned int nothing2;
};

RWTexture2D<unsigned int> outputtextureY : register(u0);
RWTexture2D<unsigned int> outputtextureUV : register(u1);
Texture2D<unsigned int> inputTextureY: register(t0);
Texture2D<unsigned int> inputTextureUV: register(t1);


[numthreads(BITONIC_BLOCK_SIZE, BITONIC_BLOCK_SIZE, 1)]
void P010ToNV12( uint3 Gid : SV_GroupID, 
                  uint3 DTid : SV_DispatchThreadID, 
                  uint3 GTid : SV_GroupThreadID, 
                  uint GI : SV_GroupIndex )
{
	if (DTid.x > width || DTid.y > height)
	{
		return;			
	}
	
	if(shift > 0)
	{
		if (DTid.y < height / 2)
		{
			unsigned int pix = inputTextureUV[DTid.xy];
			outputtextureUV[DTid.xy] = ((pix >> 8) & 0xff);
		}
		unsigned int pix = inputTextureY[DTid.xy];
		outputtextureY[DTid.xy] = ((pix >> 8) & 0xff);
	}
	else
	{
		if (DTid.y < height / 2)
		{
			unsigned int pix = inputTextureUV[DTid.xy];
			outputtextureUV[DTid.xy] = ((pix >> 2) & 0xff);
		}
		unsigned int pix = inputTextureY[DTid.xy];
		outputtextureY[DTid.xy] = ((pix >> 2) & 0xff);
	}
	
}


