module.exports = {
    zh_CN: {
        totalMemoryAlert: '浏览器为每个扩展提供 {size}MB 来存储本地数据',
        usedMemoryAlert: '当前已使用 {size}MB',
        operationAlert: '您可以归档或者删除那些无关紧要的数据，来减小内存空间',
        filterItems: '数据筛选',
        filterFocus: '当日阅览时间在 {start} 秒至 {end} 秒之间。',
        filterTotal: '当日运行时间在 {start} 秒至 {end} 秒之间。',
        filterTime: '当日打开次数在 {start} 次至 {end} 次之间。',
        filterDate: '{picker} 产生的数据。',
        unlimited: '无限',
        archiveAlert: '归档后的数据不再按天统计，将累加至域名的归档数据中。',
        dateShortcut: {
            tillYesturday: '直到昨天',
            till7DaysAgo: '直到7天前',
            till30DaysAgo: '直到30天前'
        },
        paramError: '参数错误，请检查！',
        deleteConfirm: '共筛选出 {count} 条数据，是否全部删除？',
        deleteSuccess: '删除成功',
        archiveConfirm: '共筛选出 {count} 条数据，是否全部归档？',
        archiveSuccess: '归档成功'
    },
    en: {
        totalMemoryAlert: 'The browser provides {size}MB to store local data for each extension',
        usedMemoryAlert: '{Size}MB is currently used',
        operationAlert: 'You can archive or delete those irrelevant data to reduce memory usage',
        filterItems: 'Filter data',
        filterFocus: 'The browse time of the day is between {start} seconds and {end} seconds.',
        filterFocus: 'The run time of the day is between {start} seconds and {end} seconds.',
        filterTime: 'Opens on the day are between {start} and {end}.',
        filterDate: 'Generated between {picker}.',
        unlimited: 'Unlimited',
        archiveAlert: 'The archived data will no longer be counted daily, and will be accumulated to its domain.',
        dateShortcut: {
            tillYesturday: 'Until yesterday',
            till7DaysAgo: 'Until 7 days ago',
            till30DaysAgo: 'Until 30 days ago'
        },
        paramError: 'Parameter error, please check!',
        deleteConfirm: 'A total of {count} data have been filtered out, delete all of them?',
        deleteSuccess: 'Successfully deleted',
        archiveConfirm: 'A total of {count} data have been filtered out, archive all of them?',
        archiveSuccess: 'Archived successfully'
    },
    ja: {
        totalMemoryAlert: 'ブラウザは、データを保存するために各拡張機能に {size}MB のメモリを提供します',
        usedMemoryAlert: '現在 {size}MB が使用されています',
        operationAlert: 'これらの無関係なデータをアーカイブまたは削除して、メモリ使用量を減らすことができます',
        filterItems: 'データフィルタリング',
        filterFocus: '当日の閲覧時間は、{start} 秒から {end} 秒の間です。',
        filterTotal: '当日の実行時間は、{start} 秒から {end} 秒の間です。',
        filterTime: '当日のオープン数は {start} から {end} の間です。',
        filterDate: '{picker} までに生成されたデータ',
        unlimited: '無制限',
        archiveAlert: 'アーカイブされたデータは毎日カウントされなくなり、ドメイン名のアーカイブされたデータに追加されます。',
        dateShortcut: {
            tillYesturday: '昨日まで',
            till7DaysAgo: '7日前まで',
            till30DaysAgo: '30日前まで'
        },
        paramError: 'パラメータエラー、確認してください！',
        deleteConfirm: '合計 {count} 個のデータが除外されました。すべて削除しますか？',
        deleteSuccess: '正常に削除されました',
        archiveConfirm: '合計 {count} 個のデータが除外されました。それらはすべてアーカイブされていますか？',
        archiveSuccess: '正常にアーカイブされました'
    }
}