## Public and Private API ##

_API documentation automatically generated by [docmeteor](https://github.com/raix/docmeteor)._

***

__File: ["fileWorker.js"](fileWorker.js) Where: {server}__

***

TODO: Use power queue to handle throttling etc.
Use observe to monitor changes and have it create tasks for the power queue
to perform.

-

### <a name="FS.FileWorker"></a>*fs*.FileWorker Object&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This property __FileWorker__ is defined in `FS`*


> ```FS.FileWorker = { ...``` [fileWorker.js:9](fileWorker.js#L9)


-

### <a name="FS.FileWorker.observe"></a>*fsFileworker*.observe(fsCollection)&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method __observe__ is defined in `FS.FileWorker`*

__Arguments__

* __fsCollection__ *{[FS.Collection](#FS.Collection)}*  

__Returns__  *{undefined}*


Sets up observes on the fsCollection to store file copies and delete
temp files at the appropriate times.

> ```FS.FileWorker.observe = function(fsCollection) { ...``` [fileWorker.js:20](fileWorker.js#L20)


-

### <a name="getReadyQuery"></a>getReadyQuery(storeName)&nbsp;&nbsp;<sub><i>undefined</i></sub> ###

*This method is private*

__Arguments__

* __storeName__ *{string}*  

 The name of the store to observe



Returns a selector that will be used to identify files that
have been uploaded but have not yet been stored to the
specified store.

{
$where: "this.chunkSum === this.chunkCount",
'copies.storeName`: null,
'failures.copies.storeName.doneTrying': {$ne: true}
}

> ```function getReadyQuery(storeName) { ...``` [fileWorker.js:83](fileWorker.js#L83)


-

### <a name="getDoneQuery"></a>getDoneQuery(stores)&nbsp;&nbsp;<sub><i>undefined</i></sub> ###

*This method is private*

__Arguments__

* __stores__ *{Object}*  

 The stores object from the FS.Collection options



Returns a selector that will be used to identify files where all
stores have successfully save or have failed the
max number of times but still have chunks. The resulting selector
should be something like this:

{
$and: [
{chunks: {$exists: true}},
{
$or: [
{
$and: [
{
'copies.storeName': {$ne: null}
},
{
'copies.storeName': {$ne: false}
}
]
},
{
'failures.copies.storeName.doneTrying': true
}
]
},
REPEATED FOR EACH STORE
]
}


> ```function getDoneQuery(stores) { ...``` [fileWorker.js:129](fileWorker.js#L129)


-

### <a name="saveCopy"></a>saveCopy(fsFile, storeName, options)&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method is private*

__Arguments__

* __fsFile__ *{[FS.File](#FS.File)}*  
* __storeName__ *{string}*  
* __options__ *{Object}*  
    * __overwrite__ *{Boolean}*  (Optional, Default = false)

     Force save to the specified store?


__Returns__  *{undefined}*


Saves to the specified store. If the
`overwrite` option is `true`, will save to the store even if we already
have, potentially overwriting any previously saved data. Synchronous.

> ```var makeSafeCallback = function (callback) { ...``` [fileWorker.js:168](fileWorker.js#L168)


