## cfs-base-package Public API ##

CollectionFS, Base package

_API documentation automatically generated by [docmeteor](https://github.com/raix/docmeteor)._

#############################################################################

HELPERS

#############################################################################
-

### <a name="FS.Utility.cloneFileRecord"></a>*fsUtility*.cloneFileRecord(rec, [options])&nbsp;&nbsp;<sub><i>Anywhere</i></sub> ###

*This method __cloneFileRecord__ is defined in `FS.Utility`*

__Arguments__

* __rec__ *{[FS.File](#FS.File)|[FS.Collection filerecord](#FS.Collection filerecord)}*  
* __options__ *{Object}*  (Optional)
    * __full__ *{Boolean}*  (Optional, Default = false)

    Set `true` to prevent certain properties from being omitted from the clone.


__Returns__  *{Object}*
Cloned filerecord


Makes a shallow clone of `rec`, filtering out some properties that might be present if
it's an FS.File instance, but which we never want to be part of the stored
filerecord.

This is a blacklist clone rather than a whitelist because we want the user to be able
to specify whatever additional properties they wish.

In general, we expect the following whitelist properties used by the internal and
external APIs:

_id, name, size, type, chunkCount, chunkSize, chunkSum, copies, createdAt, updatedAt, uploadedAt

Those properties, and any additional properties added by the user, should be present
in the returned object, which is suitable for inserting into the backing collection or
extending an FS.File instance.


> ```FS.Utility.cloneFileRecord = function(rec, options) { ...``` [base-common.js:71](base-common.js#L71)


-

### <a name="FS.Utility.defaultCallback"></a>*fsUtility*.defaultCallback([err])&nbsp;&nbsp;<sub><i>Anywhere</i></sub> ###

*This method __defaultCallback__ is defined in `FS.Utility`*

__Arguments__

* __err__ *{[Error](#Error)}*  (Optional)

__Returns__  *{undefined}*


Can be used as a default callback for client methods that need a callback.
Simply throws the provided error if there is one.

> ```FS.Utility.defaultCallback = function defaultCallback(err) { ...``` [base-common.js:96](base-common.js#L96)


-

### <a name="FS.Utility.defaultCallback"></a>*fsUtility*.defaultCallback([f], [err])&nbsp;&nbsp;<sub><i>Anywhere</i></sub> ###

*This method __defaultCallback__ is defined in `FS.Utility`*

__Arguments__

* __f__ *{Function}*  (Optional)

 A callback function, if you have one. Can be undefined or null.

* __err__ *{[Meteor.Error ](#Meteor.Error )|[ Error ](# Error )|[ String](# String)}*  (Optional)

 Error or error message (string)


__Returns__  *{Any}*
the callback result if any


Handle Error, creates an Error instance with the given text. If callback is
a function, passes the error to that function. Otherwise throws it. Useful
for dealing with errors in methods that optionally accept a callback.

> ```FS.Utility.handleError = function(f, err, result) { ...``` [base-common.js:120](base-common.js#L120)


-

### <a name="FS.Utility.noop"></a>*fsUtility*.noop()&nbsp;&nbsp;<sub><i>Anywhere</i></sub> ###

*This method __noop__ is defined in `FS.Utility`*

Use this to hand a no operation / empty function

> ```FS.Utility.noop = function() { ...``` [base-common.js:134](base-common.js#L134)


-

### <a name="FS.Utility.getFileExtension"></a>*fsUtility*.getFileExtension(name)&nbsp;&nbsp;<sub><i>Anywhere</i></sub> ###

*This method __getFileExtension__ is defined in `FS.Utility`*

__Arguments__

* __name__ *{String}*  

 A filename, filepath, or URL that may or may not have an extension.


__Returns__  *{String}*
The extension or an empty string if no extension found.


> ```FS.Utility.getFileExtension = function utilGetFileExtension(name) { ...``` [base-common.js:205](base-common.js#L205)


-

### <a name="FS.Utility.setFileExtension"></a>*fsUtility*.setFileExtension(name, ext)&nbsp;&nbsp;<sub><i>Anywhere</i></sub> ###

*This method __setFileExtension__ is defined in `FS.Utility`*

__Arguments__

* __name__ *{String}*  

 A filename that may or may not already have an extension.

* __ext__ *{String}*  

 An extension without leading period, which you want to be the new extension on `name`.


__Returns__  *{String}*
The filename with changed extension.


> ```FS.Utility.setFileExtension = function utilSetFileExtension(name, ext) { ...``` [base-common.js:222](base-common.js#L222)


-

### <a name="FS.Utility.binaryToBuffer"></a>*fsUtility*.binaryToBuffer(data)&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method __binaryToBuffer__ is defined in `FS.Utility`*

__Arguments__

* __data__ *{Uint8Array}*  

__Returns__  *{Buffer}*


Converts a Uint8Array instance to a Node Buffer instance

> ```FS.Utility.binaryToBuffer = function(data) { ...``` [base-server.js:9](base-server.js#L9)


-

### <a name="FS.Utility.bufferToBinary"></a>*fsUtility*.bufferToBinary(data)&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method __bufferToBinary__ is defined in `FS.Utility`*

__Arguments__

* __data__ *{Buffer}*  

__Returns__  *{Uint8Array}*


Converts a Node Buffer instance to a Uint8Array instance

> ```FS.Utility.bufferToBinary = function(data) { ...``` [base-server.js:26](base-server.js#L26)


-

### <a name="FS.Utility.eachFile"></a>*fsUtility*.eachFile(e, f)&nbsp;&nbsp;<sub><i>Client</i></sub> ###

*This method __eachFile__ is defined in `FS.Utility`*

__Arguments__

* __e__ *{[Event](#Event)}*  

 Browser event

* __f__ *{Function}*  

 Function to run for each file found in the event.


__Returns__  *{undefined}*


Utility for iteration over files in event

> ```FS.Utility.eachFile = function(e, f) { ...``` [base-client.js:37](base-client.js#L37)


