#!/bin/bash
REQUIRED_VERSION=1.7
# Transform the required version string into a number that can be used in comparisons
REQUIRED_VERSION=`echo $REQUIRED_VERSION | sed -e 's;\.;0;g'`

java -version 2> tmp.ver 1> /dev/null
VERSION=`cat tmp.ver | grep "java version" | awk '{ print substr($3, 2, length($3)-2) }'`
rm tmp.ver
if [ $VERSION ]
then
        VERSION=`echo $VERSION | awk '{ print substr($1, 1, 3); }' | sed -e 's;\.;0;g'`
        if [ $VERSION ]
        then
                if [ $VERSION -ge $REQUIRED_VERSION ]
                then
                        :
                else
                        echo 'Your jdk version is too low, Please install java version 1.8 or higher.'
			exit
                fi
        fi
else
        echo 'You don not have to install jdk, Please install java version 1.8 or higher.'
	exit
fi
hostname 127.0.0.1
ITOSS_HOME=$(cd `dirname $0`; pwd)
JAVA_OPTS="-Dosgi.console \
-Dosgi.nl=zh \
-Dorg.osgi.service.http.port=8080 \
-Dosgi.compatibility.bootdelegation=true \
-Dace.osgi.autoupdate=true  \
-Dproductid=WEADMIN \
-Dagent.identification.agentid=weadmin_v1.2 \
-Dagent.discovery.serverurls=http://autop2.weadmin.com
-Dlaunch.trace=false \
-Dagent.logging.level=INFO \
-Declipse.registry.MultiLanguage=true \
-Djava.security.egd=file:/dev/./urandom \
-Djava.awt.headless=true \
-Xms1024m \
-Xmx1024m \
-Xmn512m \
-XX:PermSize=256m \
-XX:MaxPermSize=256m \
"

count=`ps -ef |grep $ITOSS_HOME/weadmin.jar |grep -v "grep" |wc -l`
#echo $count
if [ 0 == $count ];then
	java $JAVA_OPTS -jar $ITOSS_HOME/weadmin.jar
else
	echo ITOSS is running ...
fi
