/*
 * Decompiled with CFR 0.152.
 */
package aQute.launcher.embedded;

import [Ljava.lang.String;;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.Manifest;

public class EmbeddedLauncher {
    public static final String EMBEDDED_RUNPATH = "Embedded-Runpath";
    static byte[] buffer = new byte[30000];

    public static void main(String[] args) throws Exception {
        ClassLoader cl = EmbeddedLauncher.class.getClassLoader();
        Enumeration<URL> manifests = cl.getResources("META-INF/MANIFEST.MF");
        while (manifests.hasMoreElements()) {
            Manifest m = new Manifest(manifests.nextElement().openStream());
            String runpath = m.getMainAttributes().getValue(EMBEDDED_RUNPATH);
            if (runpath == null) continue;
            ArrayList<URL> classpath = new ArrayList<URL>();
            String[] arr$ = runpath.split("\\s*,\\s*");
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String path = arr$[i$];
                URL url = EmbeddedLauncher.toFileURL(cl.getResource(path));
                classpath.add(url);
            }
            URLClassLoader urlc = new URLClassLoader(classpath.toArray(new URL[classpath.size()]));
            Class<?> embeddedLauncher = urlc.loadClass("aQute.launcher.Launcher");
            Method method = embeddedLauncher.getMethod("main", String;.class);
            method.invoke(null, new Object[]{args});
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URL toFileURL(URL resource) throws IOException {
        File f = File.createTempFile("resource", ".jar");
        f.getParentFile().mkdirs();
        InputStream in = resource.openStream();
        try {
            FileOutputStream out = new FileOutputStream(f);
            try {
                int size = in.read(buffer);
                while (size > 0) {
                    ((OutputStream)out).write(buffer, 0, size);
                    size = in.read(buffer);
                }
            }
            finally {
                ((OutputStream)out).close();
            }
        }
        finally {
            in.close();
        }
        f.deleteOnExit();
        return f.toURL();
    }
}

