/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.platform;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import org.jackhuang.hmcl.util.Lang;

public final class SystemUtils {
    public static final boolean JRE_CAPABILITY_PACK200 = Lang.test(() -> Class.forName("java.util.jar.Pack200"));

    private SystemUtils() {
    }

    public static int callExternalProcess(String ... command) throws IOException, InterruptedException {
        return SystemUtils.callExternalProcess(Arrays.asList(command));
    }

    public static int callExternalProcess(List<String> command) throws IOException, InterruptedException {
        Process process = new ProcessBuilder(command).start();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
            }
        }
        return process.waitFor();
    }
}

